/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AfdSignaling;
import software.amazon.awssdk.services.medialive.model.Av1ColorSpaceSettings;
import software.amazon.awssdk.services.medialive.model.Av1GopSizeUnits;
import software.amazon.awssdk.services.medialive.model.Av1Level;
import software.amazon.awssdk.services.medialive.model.Av1LookAheadRateControl;
import software.amazon.awssdk.services.medialive.model.Av1SceneChangeDetect;
import software.amazon.awssdk.services.medialive.model.FixedAfd;
import software.amazon.awssdk.services.medialive.model.TimecodeBurninSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Av1Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Av1Settings> {
    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AfdSignaling").getter(Av1Settings.getter(Av1Settings::afdSignalingAsString)).setter(Av1Settings.setter(Builder::afdSignaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()}).build();
    private static final SdkField<Integer> BUF_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BufSize").getter(Av1Settings.getter(Av1Settings::bufSize)).setter(Av1Settings.setter(Builder::bufSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bufSize").build()}).build();
    private static final SdkField<Av1ColorSpaceSettings> COLOR_SPACE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColorSpaceSettings").getter(Av1Settings.getter(Av1Settings::colorSpaceSettings)).setter(Av1Settings.setter(Builder::colorSpaceSettings)).constructor(Av1ColorSpaceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorSpaceSettings").build()}).build();
    private static final SdkField<String> FIXED_AFD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FixedAfd").getter(Av1Settings.getter(Av1Settings::fixedAfdAsString)).setter(Av1Settings.setter(Builder::fixedAfd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedAfd").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(Av1Settings.getter(Av1Settings::framerateDenominator)).setter(Av1Settings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(Av1Settings.getter(Av1Settings::framerateNumerator)).setter(Av1Settings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("GopSize").getter(Av1Settings.getter(Av1Settings::gopSize)).setter(Av1Settings.setter(Builder::gopSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()}).build();
    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GopSizeUnits").getter(Av1Settings.getter(Av1Settings::gopSizeUnitsAsString)).setter(Av1Settings.setter(Builder::gopSizeUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Level").getter(Av1Settings.getter(Av1Settings::levelAsString)).setter(Av1Settings.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final SdkField<String> LOOK_AHEAD_RATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LookAheadRateControl").getter(Av1Settings.getter(Av1Settings::lookAheadRateControlAsString)).setter(Av1Settings.setter(Builder::lookAheadRateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lookAheadRateControl").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(Av1Settings.getter(Av1Settings::maxBitrate)).setter(Av1Settings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinIInterval").getter(Av1Settings.getter(Av1Settings::minIInterval)).setter(Av1Settings.setter(Builder::minIInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()}).build();
    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParDenominator").getter(Av1Settings.getter(Av1Settings::parDenominator)).setter(Av1Settings.setter(Builder::parDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()}).build();
    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParNumerator").getter(Av1Settings.getter(Av1Settings::parNumerator)).setter(Av1Settings.setter(Builder::parNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()}).build();
    private static final SdkField<Integer> QVBR_QUALITY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("QvbrQualityLevel").getter(Av1Settings.getter(Av1Settings::qvbrQualityLevel)).setter(Av1Settings.setter(Builder::qvbrQualityLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrQualityLevel").build()}).build();
    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SceneChangeDetect").getter(Av1Settings.getter(Av1Settings::sceneChangeDetectAsString)).setter(Av1Settings.setter(Builder::sceneChangeDetect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()}).build();
    private static final SdkField<TimecodeBurninSettings> TIMECODE_BURNIN_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimecodeBurninSettings").getter(Av1Settings.getter(Av1Settings::timecodeBurninSettings)).setter(Av1Settings.setter(Builder::timecodeBurninSettings)).constructor(TimecodeBurninSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeBurninSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFD_SIGNALING_FIELD, BUF_SIZE_FIELD, COLOR_SPACE_SETTINGS_FIELD, FIXED_AFD_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, LEVEL_FIELD, LOOK_AHEAD_RATE_CONTROL_FIELD, MAX_BITRATE_FIELD, MIN_I_INTERVAL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, QVBR_QUALITY_LEVEL_FIELD, SCENE_CHANGE_DETECT_FIELD, TIMECODE_BURNIN_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Av1Settings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String afdSignaling;
    private final Integer bufSize;
    private final Av1ColorSpaceSettings colorSpaceSettings;
    private final String fixedAfd;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final Double gopSize;
    private final String gopSizeUnits;
    private final String level;
    private final String lookAheadRateControl;
    private final Integer maxBitrate;
    private final Integer minIInterval;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final Integer qvbrQualityLevel;
    private final String sceneChangeDetect;
    private final TimecodeBurninSettings timecodeBurninSettings;

    private Av1Settings(BuilderImpl builder) {
        this.afdSignaling = builder.afdSignaling;
        this.bufSize = builder.bufSize;
        this.colorSpaceSettings = builder.colorSpaceSettings;
        this.fixedAfd = builder.fixedAfd;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.level = builder.level;
        this.lookAheadRateControl = builder.lookAheadRateControl;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qvbrQualityLevel = builder.qvbrQualityLevel;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.timecodeBurninSettings = builder.timecodeBurninSettings;
    }

    public final AfdSignaling afdSignaling() {
        return AfdSignaling.fromValue(this.afdSignaling);
    }

    public final String afdSignalingAsString() {
        return this.afdSignaling;
    }

    public final Integer bufSize() {
        return this.bufSize;
    }

    public final Av1ColorSpaceSettings colorSpaceSettings() {
        return this.colorSpaceSettings;
    }

    public final FixedAfd fixedAfd() {
        return FixedAfd.fromValue(this.fixedAfd);
    }

    public final String fixedAfdAsString() {
        return this.fixedAfd;
    }

    public final Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public final Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public final Double gopSize() {
        return this.gopSize;
    }

    public final Av1GopSizeUnits gopSizeUnits() {
        return Av1GopSizeUnits.fromValue(this.gopSizeUnits);
    }

    public final String gopSizeUnitsAsString() {
        return this.gopSizeUnits;
    }

    public final Av1Level level() {
        return Av1Level.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    public final Av1LookAheadRateControl lookAheadRateControl() {
        return Av1LookAheadRateControl.fromValue(this.lookAheadRateControl);
    }

    public final String lookAheadRateControlAsString() {
        return this.lookAheadRateControl;
    }

    public final Integer maxBitrate() {
        return this.maxBitrate;
    }

    public final Integer minIInterval() {
        return this.minIInterval;
    }

    public final Integer parDenominator() {
        return this.parDenominator;
    }

    public final Integer parNumerator() {
        return this.parNumerator;
    }

    public final Integer qvbrQualityLevel() {
        return this.qvbrQualityLevel;
    }

    public final Av1SceneChangeDetect sceneChangeDetect() {
        return Av1SceneChangeDetect.fromValue(this.sceneChangeDetect);
    }

    public final String sceneChangeDetectAsString() {
        return this.sceneChangeDetect;
    }

    public final TimecodeBurninSettings timecodeBurninSettings() {
        return this.timecodeBurninSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bufSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorSpaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedAfdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookAheadRateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.qvbrQualityLevel());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeBurninSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Av1Settings)) {
            return false;
        }
        Av1Settings other = (Av1Settings)obj;
        return Objects.equals(this.afdSignalingAsString(), other.afdSignalingAsString()) && Objects.equals(this.bufSize(), other.bufSize()) && Objects.equals(this.colorSpaceSettings(), other.colorSpaceSettings()) && Objects.equals(this.fixedAfdAsString(), other.fixedAfdAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.gopSizeUnitsAsString(), other.gopSizeUnitsAsString()) && Objects.equals(this.levelAsString(), other.levelAsString()) && Objects.equals(this.lookAheadRateControlAsString(), other.lookAheadRateControlAsString()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.minIInterval(), other.minIInterval()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && Objects.equals(this.qvbrQualityLevel(), other.qvbrQualityLevel()) && Objects.equals(this.sceneChangeDetectAsString(), other.sceneChangeDetectAsString()) && Objects.equals(this.timecodeBurninSettings(), other.timecodeBurninSettings());
    }

    public final String toString() {
        return ToString.builder((String)"Av1Settings").add("AfdSignaling", (Object)this.afdSignalingAsString()).add("BufSize", (Object)this.bufSize()).add("ColorSpaceSettings", (Object)this.colorSpaceSettings()).add("FixedAfd", (Object)this.fixedAfdAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopSize", (Object)this.gopSize()).add("GopSizeUnits", (Object)this.gopSizeUnitsAsString()).add("Level", (Object)this.levelAsString()).add("LookAheadRateControl", (Object)this.lookAheadRateControlAsString()).add("MaxBitrate", (Object)this.maxBitrate()).add("MinIInterval", (Object)this.minIInterval()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("QvbrQualityLevel", (Object)this.qvbrQualityLevel()).add("SceneChangeDetect", (Object)this.sceneChangeDetectAsString()).add("TimecodeBurninSettings", (Object)this.timecodeBurninSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AfdSignaling": {
                return Optional.ofNullable(clazz.cast(this.afdSignalingAsString()));
            }
            case "BufSize": {
                return Optional.ofNullable(clazz.cast(this.bufSize()));
            }
            case "ColorSpaceSettings": {
                return Optional.ofNullable(clazz.cast(this.colorSpaceSettings()));
            }
            case "FixedAfd": {
                return Optional.ofNullable(clazz.cast(this.fixedAfdAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "GopSize": {
                return Optional.ofNullable(clazz.cast(this.gopSize()));
            }
            case "GopSizeUnits": {
                return Optional.ofNullable(clazz.cast(this.gopSizeUnitsAsString()));
            }
            case "Level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
            case "LookAheadRateControl": {
                return Optional.ofNullable(clazz.cast(this.lookAheadRateControlAsString()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MinIInterval": {
                return Optional.ofNullable(clazz.cast(this.minIInterval()));
            }
            case "ParDenominator": {
                return Optional.ofNullable(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.ofNullable(clazz.cast(this.parNumerator()));
            }
            case "QvbrQualityLevel": {
                return Optional.ofNullable(clazz.cast(this.qvbrQualityLevel()));
            }
            case "SceneChangeDetect": {
                return Optional.ofNullable(clazz.cast(this.sceneChangeDetectAsString()));
            }
            case "TimecodeBurninSettings": {
                return Optional.ofNullable(clazz.cast(this.timecodeBurninSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("afdSignaling", AFD_SIGNALING_FIELD);
        map.put("bufSize", BUF_SIZE_FIELD);
        map.put("colorSpaceSettings", COLOR_SPACE_SETTINGS_FIELD);
        map.put("fixedAfd", FIXED_AFD_FIELD);
        map.put("framerateDenominator", FRAMERATE_DENOMINATOR_FIELD);
        map.put("framerateNumerator", FRAMERATE_NUMERATOR_FIELD);
        map.put("gopSize", GOP_SIZE_FIELD);
        map.put("gopSizeUnits", GOP_SIZE_UNITS_FIELD);
        map.put("level", LEVEL_FIELD);
        map.put("lookAheadRateControl", LOOK_AHEAD_RATE_CONTROL_FIELD);
        map.put("maxBitrate", MAX_BITRATE_FIELD);
        map.put("minIInterval", MIN_I_INTERVAL_FIELD);
        map.put("parDenominator", PAR_DENOMINATOR_FIELD);
        map.put("parNumerator", PAR_NUMERATOR_FIELD);
        map.put("qvbrQualityLevel", QVBR_QUALITY_LEVEL_FIELD);
        map.put("sceneChangeDetect", SCENE_CHANGE_DETECT_FIELD);
        map.put("timecodeBurninSettings", TIMECODE_BURNIN_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Av1Settings, T> g) {
        return obj -> g.apply((Av1Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String afdSignaling;
        private Integer bufSize;
        private Av1ColorSpaceSettings colorSpaceSettings;
        private String fixedAfd;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private Double gopSize;
        private String gopSizeUnits;
        private String level;
        private String lookAheadRateControl;
        private Integer maxBitrate;
        private Integer minIInterval;
        private Integer parDenominator;
        private Integer parNumerator;
        private Integer qvbrQualityLevel;
        private String sceneChangeDetect;
        private TimecodeBurninSettings timecodeBurninSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(Av1Settings model) {
            this.afdSignaling(model.afdSignaling);
            this.bufSize(model.bufSize);
            this.colorSpaceSettings(model.colorSpaceSettings);
            this.fixedAfd(model.fixedAfd);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopSize(model.gopSize);
            this.gopSizeUnits(model.gopSizeUnits);
            this.level(model.level);
            this.lookAheadRateControl(model.lookAheadRateControl);
            this.maxBitrate(model.maxBitrate);
            this.minIInterval(model.minIInterval);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.qvbrQualityLevel(model.qvbrQualityLevel);
            this.sceneChangeDetect(model.sceneChangeDetect);
            this.timecodeBurninSettings(model.timecodeBurninSettings);
        }

        public final String getAfdSignaling() {
            return this.afdSignaling;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        public final Builder afdSignaling(AfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final Integer getBufSize() {
            return this.bufSize;
        }

        public final void setBufSize(Integer bufSize) {
            this.bufSize = bufSize;
        }

        @Override
        public final Builder bufSize(Integer bufSize) {
            this.bufSize = bufSize;
            return this;
        }

        public final Av1ColorSpaceSettings.Builder getColorSpaceSettings() {
            return this.colorSpaceSettings != null ? this.colorSpaceSettings.toBuilder() : null;
        }

        public final void setColorSpaceSettings(Av1ColorSpaceSettings.BuilderImpl colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings != null ? colorSpaceSettings.build() : null;
        }

        @Override
        public final Builder colorSpaceSettings(Av1ColorSpaceSettings colorSpaceSettings) {
            this.colorSpaceSettings = colorSpaceSettings;
            return this;
        }

        public final String getFixedAfd() {
            return this.fixedAfd;
        }

        public final void setFixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
        }

        @Override
        public final Builder fixedAfd(String fixedAfd) {
            this.fixedAfd = fixedAfd;
            return this;
        }

        @Override
        public final Builder fixedAfd(FixedAfd fixedAfd) {
            this.fixedAfd(fixedAfd == null ? null : fixedAfd.toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final String getGopSizeUnits() {
            return this.gopSizeUnits;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(Av1GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(Av1Level level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final String getLookAheadRateControl() {
            return this.lookAheadRateControl;
        }

        public final void setLookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
        }

        @Override
        public final Builder lookAheadRateControl(String lookAheadRateControl) {
            this.lookAheadRateControl = lookAheadRateControl;
            return this;
        }

        @Override
        public final Builder lookAheadRateControl(Av1LookAheadRateControl lookAheadRateControl) {
            this.lookAheadRateControl(lookAheadRateControl == null ? null : lookAheadRateControl.toString());
            return this;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final Integer getMinIInterval() {
            return this.minIInterval;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final Integer getQvbrQualityLevel() {
            return this.qvbrQualityLevel;
        }

        public final void setQvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
        }

        @Override
        public final Builder qvbrQualityLevel(Integer qvbrQualityLevel) {
            this.qvbrQualityLevel = qvbrQualityLevel;
            return this;
        }

        public final String getSceneChangeDetect() {
            return this.sceneChangeDetect;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(Av1SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final TimecodeBurninSettings.Builder getTimecodeBurninSettings() {
            return this.timecodeBurninSettings != null ? this.timecodeBurninSettings.toBuilder() : null;
        }

        public final void setTimecodeBurninSettings(TimecodeBurninSettings.BuilderImpl timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings != null ? timecodeBurninSettings.build() : null;
        }

        @Override
        public final Builder timecodeBurninSettings(TimecodeBurninSettings timecodeBurninSettings) {
            this.timecodeBurninSettings = timecodeBurninSettings;
            return this;
        }

        public Av1Settings build() {
            return new Av1Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Av1Settings> {
        public Builder afdSignaling(String var1);

        public Builder afdSignaling(AfdSignaling var1);

        public Builder bufSize(Integer var1);

        public Builder colorSpaceSettings(Av1ColorSpaceSettings var1);

        default public Builder colorSpaceSettings(Consumer<Av1ColorSpaceSettings.Builder> colorSpaceSettings) {
            return this.colorSpaceSettings((Av1ColorSpaceSettings)((Av1ColorSpaceSettings.Builder)Av1ColorSpaceSettings.builder().applyMutation(colorSpaceSettings)).build());
        }

        public Builder fixedAfd(String var1);

        public Builder fixedAfd(FixedAfd var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopSize(Double var1);

        public Builder gopSizeUnits(String var1);

        public Builder gopSizeUnits(Av1GopSizeUnits var1);

        public Builder level(String var1);

        public Builder level(Av1Level var1);

        public Builder lookAheadRateControl(String var1);

        public Builder lookAheadRateControl(Av1LookAheadRateControl var1);

        public Builder maxBitrate(Integer var1);

        public Builder minIInterval(Integer var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder qvbrQualityLevel(Integer var1);

        public Builder sceneChangeDetect(String var1);

        public Builder sceneChangeDetect(Av1SceneChangeDetect var1);

        public Builder timecodeBurninSettings(TimecodeBurninSettings var1);

        default public Builder timecodeBurninSettings(Consumer<TimecodeBurninSettings.Builder> timecodeBurninSettings) {
            return this.timecodeBurninSettings((TimecodeBurninSettings)((TimecodeBurninSettings.Builder)TimecodeBurninSettings.builder().applyMutation(timecodeBurninSettings)).build());
        }
    }
}

