/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelResponse;
import software.amazon.awssdk.services.medialive.model.DescribeClusterRequest;
import software.amazon.awssdk.services.medialive.model.DescribeClusterResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputResponse;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexRequest;
import software.amazon.awssdk.services.medialive.model.DescribeMultiplexResponse;
import software.amazon.awssdk.services.medialive.model.DescribeNodeRequest;
import software.amazon.awssdk.services.medialive.model.DescribeNodeResponse;
import software.amazon.awssdk.services.medialive.model.GetSignalMapRequest;
import software.amazon.awssdk.services.medialive.model.GetSignalMapResponse;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.waiters.MediaLiveAsyncWaiter;
import software.amazon.awssdk.services.medialive.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultMediaLiveAsyncWaiter
implements MediaLiveAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final MediaLiveAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeChannelResponse> channelCreatedWaiter;
    private final AsyncWaiter<DescribeChannelResponse> channelRunningWaiter;
    private final AsyncWaiter<DescribeChannelResponse> channelStoppedWaiter;
    private final AsyncWaiter<DescribeChannelResponse> channelDeletedWaiter;
    private final AsyncWaiter<DescribeInputResponse> inputAttachedWaiter;
    private final AsyncWaiter<DescribeInputResponse> inputDetachedWaiter;
    private final AsyncWaiter<DescribeInputResponse> inputDeletedWaiter;
    private final AsyncWaiter<DescribeMultiplexResponse> multiplexCreatedWaiter;
    private final AsyncWaiter<DescribeMultiplexResponse> multiplexRunningWaiter;
    private final AsyncWaiter<DescribeMultiplexResponse> multiplexStoppedWaiter;
    private final AsyncWaiter<DescribeMultiplexResponse> multiplexDeletedWaiter;
    private final AsyncWaiter<GetSignalMapResponse> signalMapCreatedWaiter;
    private final AsyncWaiter<GetSignalMapResponse> signalMapMonitorDeletedWaiter;
    private final AsyncWaiter<GetSignalMapResponse> signalMapMonitorDeployedWaiter;
    private final AsyncWaiter<GetSignalMapResponse> signalMapUpdatedWaiter;
    private final AsyncWaiter<DescribeClusterResponse> clusterCreatedWaiter;
    private final AsyncWaiter<DescribeClusterResponse> clusterDeletedWaiter;
    private final AsyncWaiter<DescribeNodeResponse> nodeRegisteredWaiter;
    private final AsyncWaiter<DescribeNodeResponse> nodeDeregisteredWaiter;
    private final AsyncWaiter<DescribeChannelPlacementGroupResponse> channelPlacementGroupAssignedWaiter;
    private final AsyncWaiter<DescribeChannelPlacementGroupResponse> channelPlacementGroupUnassignedWaiter;
    private final AsyncWaiter<DescribeChannelPlacementGroupResponse> channelPlacementGroupDeletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultMediaLiveAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (MediaLiveAsyncClient)MediaLiveAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.channelCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeChannelResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.channelCreatedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.channelCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.channelRunningWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeChannelResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.channelRunningWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.channelRunningWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.channelStoppedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeChannelResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.channelStoppedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.channelStoppedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.channelDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeChannelResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.channelDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.channelDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.inputAttachedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInputResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.inputAttachedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.inputAttachedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.inputDetachedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInputResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.inputDetachedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.inputDetachedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.inputDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeInputResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.inputDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.inputDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.multiplexCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeMultiplexResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.multiplexCreatedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.multiplexCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.multiplexRunningWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeMultiplexResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.multiplexRunningWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.multiplexRunningWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.multiplexStoppedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeMultiplexResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.multiplexStoppedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.multiplexStoppedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.multiplexDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeMultiplexResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.multiplexDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.multiplexDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.signalMapCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetSignalMapResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.signalMapCreatedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.signalMapCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.signalMapMonitorDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetSignalMapResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.signalMapMonitorDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.signalMapMonitorDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.signalMapMonitorDeployedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetSignalMapResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.signalMapMonitorDeployedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.signalMapMonitorDeployedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.signalMapUpdatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetSignalMapResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.signalMapUpdatedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.signalMapUpdatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.clusterCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeClusterResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.clusterCreatedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.clusterCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.clusterDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeClusterResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.clusterDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.clusterDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.nodeRegisteredWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeNodeResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.nodeRegisteredWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.nodeRegisteredWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.nodeDeregisteredWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeNodeResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.nodeDeregisteredWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.nodeDeregisteredWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.channelPlacementGroupAssignedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeChannelPlacementGroupResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.channelPlacementGroupAssignedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.channelPlacementGroupAssignedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.channelPlacementGroupUnassignedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeChannelPlacementGroupResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.channelPlacementGroupUnassignedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.channelPlacementGroupUnassignedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.channelPlacementGroupDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeChannelPlacementGroupResponse.class).acceptors(DefaultMediaLiveAsyncWaiter.channelPlacementGroupDeletedWaiterAcceptors())).overrideConfiguration(DefaultMediaLiveAsyncWaiter.channelPlacementGroupDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelResponse>> waitUntilChannelCreated(DescribeChannelRequest describeChannelRequest) {
        return this.channelCreatedWaiter.runAsync(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelResponse>> waitUntilChannelCreated(DescribeChannelRequest describeChannelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelCreatedWaiter.runAsync(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)), DefaultMediaLiveAsyncWaiter.channelCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelResponse>> waitUntilChannelDeleted(DescribeChannelRequest describeChannelRequest) {
        return this.channelDeletedWaiter.runAsync(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelResponse>> waitUntilChannelDeleted(DescribeChannelRequest describeChannelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelDeletedWaiter.runAsync(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)), DefaultMediaLiveAsyncWaiter.channelDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelPlacementGroupResponse>> waitUntilChannelPlacementGroupAssigned(DescribeChannelPlacementGroupRequest describeChannelPlacementGroupRequest) {
        return this.channelPlacementGroupAssignedWaiter.runAsync(() -> this.client.describeChannelPlacementGroup(this.applyWaitersUserAgent(describeChannelPlacementGroupRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelPlacementGroupResponse>> waitUntilChannelPlacementGroupAssigned(DescribeChannelPlacementGroupRequest describeChannelPlacementGroupRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelPlacementGroupAssignedWaiter.runAsync(() -> this.client.describeChannelPlacementGroup(this.applyWaitersUserAgent(describeChannelPlacementGroupRequest)), DefaultMediaLiveAsyncWaiter.channelPlacementGroupAssignedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelPlacementGroupResponse>> waitUntilChannelPlacementGroupDeleted(DescribeChannelPlacementGroupRequest describeChannelPlacementGroupRequest) {
        return this.channelPlacementGroupDeletedWaiter.runAsync(() -> this.client.describeChannelPlacementGroup(this.applyWaitersUserAgent(describeChannelPlacementGroupRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelPlacementGroupResponse>> waitUntilChannelPlacementGroupDeleted(DescribeChannelPlacementGroupRequest describeChannelPlacementGroupRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelPlacementGroupDeletedWaiter.runAsync(() -> this.client.describeChannelPlacementGroup(this.applyWaitersUserAgent(describeChannelPlacementGroupRequest)), DefaultMediaLiveAsyncWaiter.channelPlacementGroupDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelPlacementGroupResponse>> waitUntilChannelPlacementGroupUnassigned(DescribeChannelPlacementGroupRequest describeChannelPlacementGroupRequest) {
        return this.channelPlacementGroupUnassignedWaiter.runAsync(() -> this.client.describeChannelPlacementGroup(this.applyWaitersUserAgent(describeChannelPlacementGroupRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelPlacementGroupResponse>> waitUntilChannelPlacementGroupUnassigned(DescribeChannelPlacementGroupRequest describeChannelPlacementGroupRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelPlacementGroupUnassignedWaiter.runAsync(() -> this.client.describeChannelPlacementGroup(this.applyWaitersUserAgent(describeChannelPlacementGroupRequest)), DefaultMediaLiveAsyncWaiter.channelPlacementGroupUnassignedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelResponse>> waitUntilChannelRunning(DescribeChannelRequest describeChannelRequest) {
        return this.channelRunningWaiter.runAsync(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelResponse>> waitUntilChannelRunning(DescribeChannelRequest describeChannelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelRunningWaiter.runAsync(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)), DefaultMediaLiveAsyncWaiter.channelRunningWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelResponse>> waitUntilChannelStopped(DescribeChannelRequest describeChannelRequest) {
        return this.channelStoppedWaiter.runAsync(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeChannelResponse>> waitUntilChannelStopped(DescribeChannelRequest describeChannelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.channelStoppedWaiter.runAsync(() -> this.client.describeChannel(this.applyWaitersUserAgent(describeChannelRequest)), DefaultMediaLiveAsyncWaiter.channelStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterCreated(DescribeClusterRequest describeClusterRequest) {
        return this.clusterCreatedWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterCreated(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterCreatedWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultMediaLiveAsyncWaiter.clusterCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterDeleted(DescribeClusterRequest describeClusterRequest) {
        return this.clusterDeletedWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeClusterResponse>> waitUntilClusterDeleted(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterDeletedWaiter.runAsync(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultMediaLiveAsyncWaiter.clusterDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInputResponse>> waitUntilInputAttached(DescribeInputRequest describeInputRequest) {
        return this.inputAttachedWaiter.runAsync(() -> this.client.describeInput(this.applyWaitersUserAgent(describeInputRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInputResponse>> waitUntilInputAttached(DescribeInputRequest describeInputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inputAttachedWaiter.runAsync(() -> this.client.describeInput(this.applyWaitersUserAgent(describeInputRequest)), DefaultMediaLiveAsyncWaiter.inputAttachedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInputResponse>> waitUntilInputDeleted(DescribeInputRequest describeInputRequest) {
        return this.inputDeletedWaiter.runAsync(() -> this.client.describeInput(this.applyWaitersUserAgent(describeInputRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInputResponse>> waitUntilInputDeleted(DescribeInputRequest describeInputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inputDeletedWaiter.runAsync(() -> this.client.describeInput(this.applyWaitersUserAgent(describeInputRequest)), DefaultMediaLiveAsyncWaiter.inputDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInputResponse>> waitUntilInputDetached(DescribeInputRequest describeInputRequest) {
        return this.inputDetachedWaiter.runAsync(() -> this.client.describeInput(this.applyWaitersUserAgent(describeInputRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeInputResponse>> waitUntilInputDetached(DescribeInputRequest describeInputRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.inputDetachedWaiter.runAsync(() -> this.client.describeInput(this.applyWaitersUserAgent(describeInputRequest)), DefaultMediaLiveAsyncWaiter.inputDetachedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeMultiplexResponse>> waitUntilMultiplexCreated(DescribeMultiplexRequest describeMultiplexRequest) {
        return this.multiplexCreatedWaiter.runAsync(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeMultiplexResponse>> waitUntilMultiplexCreated(DescribeMultiplexRequest describeMultiplexRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.multiplexCreatedWaiter.runAsync(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)), DefaultMediaLiveAsyncWaiter.multiplexCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeMultiplexResponse>> waitUntilMultiplexDeleted(DescribeMultiplexRequest describeMultiplexRequest) {
        return this.multiplexDeletedWaiter.runAsync(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeMultiplexResponse>> waitUntilMultiplexDeleted(DescribeMultiplexRequest describeMultiplexRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.multiplexDeletedWaiter.runAsync(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)), DefaultMediaLiveAsyncWaiter.multiplexDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeMultiplexResponse>> waitUntilMultiplexRunning(DescribeMultiplexRequest describeMultiplexRequest) {
        return this.multiplexRunningWaiter.runAsync(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeMultiplexResponse>> waitUntilMultiplexRunning(DescribeMultiplexRequest describeMultiplexRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.multiplexRunningWaiter.runAsync(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)), DefaultMediaLiveAsyncWaiter.multiplexRunningWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeMultiplexResponse>> waitUntilMultiplexStopped(DescribeMultiplexRequest describeMultiplexRequest) {
        return this.multiplexStoppedWaiter.runAsync(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeMultiplexResponse>> waitUntilMultiplexStopped(DescribeMultiplexRequest describeMultiplexRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.multiplexStoppedWaiter.runAsync(() -> this.client.describeMultiplex(this.applyWaitersUserAgent(describeMultiplexRequest)), DefaultMediaLiveAsyncWaiter.multiplexStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNodeResponse>> waitUntilNodeDeregistered(DescribeNodeRequest describeNodeRequest) {
        return this.nodeDeregisteredWaiter.runAsync(() -> this.client.describeNode(this.applyWaitersUserAgent(describeNodeRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNodeResponse>> waitUntilNodeDeregistered(DescribeNodeRequest describeNodeRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.nodeDeregisteredWaiter.runAsync(() -> this.client.describeNode(this.applyWaitersUserAgent(describeNodeRequest)), DefaultMediaLiveAsyncWaiter.nodeDeregisteredWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNodeResponse>> waitUntilNodeRegistered(DescribeNodeRequest describeNodeRequest) {
        return this.nodeRegisteredWaiter.runAsync(() -> this.client.describeNode(this.applyWaitersUserAgent(describeNodeRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeNodeResponse>> waitUntilNodeRegistered(DescribeNodeRequest describeNodeRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.nodeRegisteredWaiter.runAsync(() -> this.client.describeNode(this.applyWaitersUserAgent(describeNodeRequest)), DefaultMediaLiveAsyncWaiter.nodeRegisteredWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSignalMapResponse>> waitUntilSignalMapCreated(GetSignalMapRequest getSignalMapRequest) {
        return this.signalMapCreatedWaiter.runAsync(() -> this.client.getSignalMap(this.applyWaitersUserAgent(getSignalMapRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSignalMapResponse>> waitUntilSignalMapCreated(GetSignalMapRequest getSignalMapRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.signalMapCreatedWaiter.runAsync(() -> this.client.getSignalMap(this.applyWaitersUserAgent(getSignalMapRequest)), DefaultMediaLiveAsyncWaiter.signalMapCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSignalMapResponse>> waitUntilSignalMapMonitorDeleted(GetSignalMapRequest getSignalMapRequest) {
        return this.signalMapMonitorDeletedWaiter.runAsync(() -> this.client.getSignalMap(this.applyWaitersUserAgent(getSignalMapRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSignalMapResponse>> waitUntilSignalMapMonitorDeleted(GetSignalMapRequest getSignalMapRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.signalMapMonitorDeletedWaiter.runAsync(() -> this.client.getSignalMap(this.applyWaitersUserAgent(getSignalMapRequest)), DefaultMediaLiveAsyncWaiter.signalMapMonitorDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSignalMapResponse>> waitUntilSignalMapMonitorDeployed(GetSignalMapRequest getSignalMapRequest) {
        return this.signalMapMonitorDeployedWaiter.runAsync(() -> this.client.getSignalMap(this.applyWaitersUserAgent(getSignalMapRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSignalMapResponse>> waitUntilSignalMapMonitorDeployed(GetSignalMapRequest getSignalMapRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.signalMapMonitorDeployedWaiter.runAsync(() -> this.client.getSignalMap(this.applyWaitersUserAgent(getSignalMapRequest)), DefaultMediaLiveAsyncWaiter.signalMapMonitorDeployedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSignalMapResponse>> waitUntilSignalMapUpdated(GetSignalMapRequest getSignalMapRequest) {
        return this.signalMapUpdatedWaiter.runAsync(() -> this.client.getSignalMap(this.applyWaitersUserAgent(getSignalMapRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetSignalMapResponse>> waitUntilSignalMapUpdated(GetSignalMapRequest getSignalMapRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.signalMapUpdatedWaiter.runAsync(() -> this.client.getSignalMap(this.applyWaitersUserAgent(getSignalMapRequest)), DefaultMediaLiveAsyncWaiter.signalMapUpdatedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeChannelResponse>> channelCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChannelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChannelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "IDLE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "CREATING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (State=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeChannelResponse>> channelRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChannelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChannelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "STARTING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeChannelResponse>> channelStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChannelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChannelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "IDLE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "STOPPING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeChannelResponse>> channelDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChannelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChannelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInputResponse>> inputAttachedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInputResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "ATTACHED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DETACHED");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInputResponse>> inputDetachedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInputResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DETACHED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "ATTACHED");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInputResponse>> inputDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInputResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInputResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeMultiplexResponse>> multiplexCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "IDLE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "CREATING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (State=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeMultiplexResponse>> multiplexRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "STARTING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeMultiplexResponse>> multiplexStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "IDLE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "STOPPING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeMultiplexResponse>> multiplexDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeMultiplexResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetSignalMapResponse>> signalMapCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetSignalMapResponse>> result = new ArrayList<WaiterAcceptor<? super GetSignalMapResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "CREATE_COMPLETE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "CREATE_IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetSignalMapResponse>> signalMapMonitorDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetSignalMapResponse>> result = new ArrayList<WaiterAcceptor<? super GetSignalMapResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MonitorDeployment").field("Status").value(), "DELETE_COMPLETE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MonitorDeployment").field("Status").value(), "DELETE_IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MonitorDeployment").field("Status").value(), "DELETE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (MonitorDeployment.Status=DELETE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetSignalMapResponse>> signalMapMonitorDeployedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetSignalMapResponse>> result = new ArrayList<WaiterAcceptor<? super GetSignalMapResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MonitorDeployment").field("Status").value(), "DRY_RUN_DEPLOYMENT_COMPLETE");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MonitorDeployment").field("Status").value(), "DEPLOYMENT_COMPLETE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MonitorDeployment").field("Status").value(), "DRY_RUN_DEPLOYMENT_IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MonitorDeployment").field("Status").value(), "DEPLOYMENT_IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MonitorDeployment").field("Status").value(), "DRY_RUN_DEPLOYMENT_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (MonitorDeployment.Status=DRY_RUN_DEPLOYMENT_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("MonitorDeployment").field("Status").value(), "DEPLOYMENT_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (MonitorDeployment.Status=DEPLOYMENT_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetSignalMapResponse>> signalMapUpdatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetSignalMapResponse>> result = new ArrayList<WaiterAcceptor<? super GetSignalMapResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "UPDATE_COMPLETE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "UPDATE_IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "UPDATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=UPDATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Status").value(), "UPDATE_REVERTED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Status=UPDATE_REVERTED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "CREATING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (State=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNodeResponse>> nodeRegisteredWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNodeResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNodeResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "REGISTERING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(404, WaiterState.RETRY));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "REGISTRATION_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (State=REGISTRATION_FAILED) and transitioned the waiter to failure state"));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNodeResponse>> nodeDeregisteredWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNodeResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNodeResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DEREGISTERED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DEREGISTERING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DRAINING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeChannelPlacementGroupResponse>> channelPlacementGroupAssignedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChannelPlacementGroupResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChannelPlacementGroupResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "ASSIGNED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "ASSIGNING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeChannelPlacementGroupResponse>> channelPlacementGroupUnassignedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChannelPlacementGroupResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChannelPlacementGroupResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "UNASSIGNED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "UNASSIGNING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeChannelPlacementGroupResponse>> channelPlacementGroupDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeChannelPlacementGroupResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeChannelPlacementGroupResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("State").value(), "DELETING");
        }));
        result.add(new WaitersRuntime.ResponseStatusAcceptor(500, WaiterState.RETRY));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration channelCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration channelRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration channelStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration channelDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(84);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration inputAttachedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration inputDetachedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(84);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration inputDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration multiplexCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration multiplexRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration multiplexStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(28);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration multiplexDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration signalMapCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration signalMapMonitorDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration signalMapMonitorDeployedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration signalMapUpdatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration nodeRegisteredWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration nodeDeregisteredWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration channelPlacementGroupAssignedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration channelPlacementGroupUnassignedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration channelPlacementGroupDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static MediaLiveAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends MediaLiveRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((MediaLiveRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements MediaLiveAsyncWaiter.Builder {
        private MediaLiveAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public MediaLiveAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public MediaLiveAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public MediaLiveAsyncWaiter.Builder client(MediaLiveAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public MediaLiveAsyncWaiter build() {
            return new DefaultMediaLiveAsyncWaiter(this);
        }
    }
}

