/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.CloudWatchAlarmTemplateGroupSummary;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListCloudWatchAlarmTemplateGroupsResponse;

public class ListCloudWatchAlarmTemplateGroupsPublisher
implements SdkPublisher<ListCloudWatchAlarmTemplateGroupsResponse> {
    private final MediaLiveAsyncClient client;
    private final ListCloudWatchAlarmTemplateGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCloudWatchAlarmTemplateGroupsPublisher(MediaLiveAsyncClient client, ListCloudWatchAlarmTemplateGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCloudWatchAlarmTemplateGroupsPublisher(MediaLiveAsyncClient client, ListCloudWatchAlarmTemplateGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCloudWatchAlarmTemplateGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCloudWatchAlarmTemplateGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CloudWatchAlarmTemplateGroupSummary> cloudWatchAlarmTemplateGroups() {
        Function<ListCloudWatchAlarmTemplateGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudWatchAlarmTemplateGroups() != null) {
                return response.cloudWatchAlarmTemplateGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCloudWatchAlarmTemplateGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCloudWatchAlarmTemplateGroupsResponseFetcher
    implements AsyncPageFetcher<ListCloudWatchAlarmTemplateGroupsResponse> {
        private ListCloudWatchAlarmTemplateGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudWatchAlarmTemplateGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCloudWatchAlarmTemplateGroupsResponse> nextPage(ListCloudWatchAlarmTemplateGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListCloudWatchAlarmTemplateGroupsPublisher.this.client.listCloudWatchAlarmTemplateGroups(ListCloudWatchAlarmTemplateGroupsPublisher.this.firstRequest);
            }
            return ListCloudWatchAlarmTemplateGroupsPublisher.this.client.listCloudWatchAlarmTemplateGroups((ListCloudWatchAlarmTemplateGroupsRequest)((Object)ListCloudWatchAlarmTemplateGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

