/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.internal.UserAgentUtils;
import software.amazon.awssdk.services.medialive.model.DescribeChannelPlacementGroupSummary;
import software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelPlacementGroupsResponse;

public class ListChannelPlacementGroupsPublisher
implements SdkPublisher<ListChannelPlacementGroupsResponse> {
    private final MediaLiveAsyncClient client;
    private final ListChannelPlacementGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListChannelPlacementGroupsPublisher(MediaLiveAsyncClient client, ListChannelPlacementGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListChannelPlacementGroupsPublisher(MediaLiveAsyncClient client, ListChannelPlacementGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListChannelPlacementGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListChannelPlacementGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DescribeChannelPlacementGroupSummary> channelPlacementGroups() {
        Function<ListChannelPlacementGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.channelPlacementGroups() != null) {
                return response.channelPlacementGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListChannelPlacementGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListChannelPlacementGroupsResponseFetcher
    implements AsyncPageFetcher<ListChannelPlacementGroupsResponse> {
        private ListChannelPlacementGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelPlacementGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListChannelPlacementGroupsResponse> nextPage(ListChannelPlacementGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelPlacementGroupsPublisher.this.client.listChannelPlacementGroups(ListChannelPlacementGroupsPublisher.this.firstRequest);
            }
            return ListChannelPlacementGroupsPublisher.this.client.listChannelPlacementGroups((ListChannelPlacementGroupsRequest)((Object)ListChannelPlacementGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

