/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HlsIvSource {
    EXPLICIT("EXPLICIT"),
    FOLLOWS_SEGMENT_NUMBER("FOLLOWS_SEGMENT_NUMBER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HlsIvSource> VALUE_MAP;
    private final String value;

    private HlsIvSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HlsIvSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HlsIvSource> knownValues() {
        EnumSet<HlsIvSource> knownValues = EnumSet.allOf(HlsIvSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HlsIvSource.class, HlsIvSource::toString);
    }
}

