/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.Esam;
import software.amazon.awssdk.services.medialive.model.Scte35SpliceInsert;
import software.amazon.awssdk.services.medialive.model.Scte35TimeSignalApos;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailSettings> {
    private static final SdkField<Esam> ESAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Esam").getter(AvailSettings.getter(AvailSettings::esam)).setter(AvailSettings.setter(Builder::esam)).constructor(Esam::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("esam").build()}).build();
    private static final SdkField<Scte35SpliceInsert> SCTE35_SPLICE_INSERT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Scte35SpliceInsert").getter(AvailSettings.getter(AvailSettings::scte35SpliceInsert)).setter(AvailSettings.setter(Builder::scte35SpliceInsert)).constructor(Scte35SpliceInsert::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35SpliceInsert").build()}).build();
    private static final SdkField<Scte35TimeSignalApos> SCTE35_TIME_SIGNAL_APOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Scte35TimeSignalApos").getter(AvailSettings.getter(AvailSettings::scte35TimeSignalApos)).setter(AvailSettings.setter(Builder::scte35TimeSignalApos)).constructor(Scte35TimeSignalApos::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35TimeSignalApos").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESAM_FIELD, SCTE35_SPLICE_INSERT_FIELD, SCTE35_TIME_SIGNAL_APOS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AvailSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Esam esam;
    private final Scte35SpliceInsert scte35SpliceInsert;
    private final Scte35TimeSignalApos scte35TimeSignalApos;

    private AvailSettings(BuilderImpl builder) {
        this.esam = builder.esam;
        this.scte35SpliceInsert = builder.scte35SpliceInsert;
        this.scte35TimeSignalApos = builder.scte35TimeSignalApos;
    }

    public final Esam esam() {
        return this.esam;
    }

    public final Scte35SpliceInsert scte35SpliceInsert() {
        return this.scte35SpliceInsert;
    }

    public final Scte35TimeSignalApos scte35TimeSignalApos() {
        return this.scte35TimeSignalApos;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.esam());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35SpliceInsert());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35TimeSignalApos());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailSettings)) {
            return false;
        }
        AvailSettings other = (AvailSettings)obj;
        return Objects.equals(this.esam(), other.esam()) && Objects.equals(this.scte35SpliceInsert(), other.scte35SpliceInsert()) && Objects.equals(this.scte35TimeSignalApos(), other.scte35TimeSignalApos());
    }

    public final String toString() {
        return ToString.builder((String)"AvailSettings").add("Esam", (Object)this.esam()).add("Scte35SpliceInsert", (Object)this.scte35SpliceInsert()).add("Scte35TimeSignalApos", (Object)this.scte35TimeSignalApos()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Esam": {
                return Optional.ofNullable(clazz.cast(this.esam()));
            }
            case "Scte35SpliceInsert": {
                return Optional.ofNullable(clazz.cast(this.scte35SpliceInsert()));
            }
            case "Scte35TimeSignalApos": {
                return Optional.ofNullable(clazz.cast(this.scte35TimeSignalApos()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("esam", ESAM_FIELD);
        map.put("scte35SpliceInsert", SCTE35_SPLICE_INSERT_FIELD);
        map.put("scte35TimeSignalApos", SCTE35_TIME_SIGNAL_APOS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AvailSettings, T> g) {
        return obj -> g.apply((AvailSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Esam esam;
        private Scte35SpliceInsert scte35SpliceInsert;
        private Scte35TimeSignalApos scte35TimeSignalApos;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailSettings model) {
            this.esam(model.esam);
            this.scte35SpliceInsert(model.scte35SpliceInsert);
            this.scte35TimeSignalApos(model.scte35TimeSignalApos);
        }

        public final Esam.Builder getEsam() {
            return this.esam != null ? this.esam.toBuilder() : null;
        }

        public final void setEsam(Esam.BuilderImpl esam) {
            this.esam = esam != null ? esam.build() : null;
        }

        @Override
        public final Builder esam(Esam esam) {
            this.esam = esam;
            return this;
        }

        public final Scte35SpliceInsert.Builder getScte35SpliceInsert() {
            return this.scte35SpliceInsert != null ? this.scte35SpliceInsert.toBuilder() : null;
        }

        public final void setScte35SpliceInsert(Scte35SpliceInsert.BuilderImpl scte35SpliceInsert) {
            this.scte35SpliceInsert = scte35SpliceInsert != null ? scte35SpliceInsert.build() : null;
        }

        @Override
        public final Builder scte35SpliceInsert(Scte35SpliceInsert scte35SpliceInsert) {
            this.scte35SpliceInsert = scte35SpliceInsert;
            return this;
        }

        public final Scte35TimeSignalApos.Builder getScte35TimeSignalApos() {
            return this.scte35TimeSignalApos != null ? this.scte35TimeSignalApos.toBuilder() : null;
        }

        public final void setScte35TimeSignalApos(Scte35TimeSignalApos.BuilderImpl scte35TimeSignalApos) {
            this.scte35TimeSignalApos = scte35TimeSignalApos != null ? scte35TimeSignalApos.build() : null;
        }

        @Override
        public final Builder scte35TimeSignalApos(Scte35TimeSignalApos scte35TimeSignalApos) {
            this.scte35TimeSignalApos = scte35TimeSignalApos;
            return this;
        }

        public AvailSettings build() {
            return new AvailSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailSettings> {
        public Builder esam(Esam var1);

        default public Builder esam(Consumer<Esam.Builder> esam) {
            return this.esam((Esam)((Esam.Builder)Esam.builder().applyMutation(esam)).build());
        }

        public Builder scte35SpliceInsert(Scte35SpliceInsert var1);

        default public Builder scte35SpliceInsert(Consumer<Scte35SpliceInsert.Builder> scte35SpliceInsert) {
            return this.scte35SpliceInsert((Scte35SpliceInsert)((Scte35SpliceInsert.Builder)Scte35SpliceInsert.builder().applyMutation(scte35SpliceInsert)).build());
        }

        public Builder scte35TimeSignalApos(Scte35TimeSignalApos var1);

        default public Builder scte35TimeSignalApos(Consumer<Scte35TimeSignalApos.Builder> scte35TimeSignalApos) {
            return this.scte35TimeSignalApos((Scte35TimeSignalApos)((Scte35TimeSignalApos.Builder)Scte35TimeSignalApos.builder().applyMutation(scte35TimeSignalApos)).build());
        }
    }
}

