/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.AudioSelectorSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioSelector> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AudioSelector.getter(AudioSelector::name)).setter(AudioSelector.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<AudioSelectorSettings> SELECTOR_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelectorSettings").getter(AudioSelector.getter(AudioSelector::selectorSettings)).setter(AudioSelector.setter(Builder::selectorSettings)).constructor(AudioSelectorSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectorSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SELECTOR_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AudioSelector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final AudioSelectorSettings selectorSettings;

    private AudioSelector(BuilderImpl builder) {
        this.name = builder.name;
        this.selectorSettings = builder.selectorSettings;
    }

    public final String name() {
        return this.name;
    }

    public final AudioSelectorSettings selectorSettings() {
        return this.selectorSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectorSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSelector)) {
            return false;
        }
        AudioSelector other = (AudioSelector)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.selectorSettings(), other.selectorSettings());
    }

    public final String toString() {
        return ToString.builder((String)"AudioSelector").add("Name", (Object)this.name()).add("SelectorSettings", (Object)this.selectorSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SelectorSettings": {
                return Optional.ofNullable(clazz.cast(this.selectorSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("selectorSettings", SELECTOR_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioSelector, T> g) {
        return obj -> g.apply((AudioSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private AudioSelectorSettings selectorSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSelector model) {
            this.name(model.name);
            this.selectorSettings(model.selectorSettings);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AudioSelectorSettings.Builder getSelectorSettings() {
            return this.selectorSettings != null ? this.selectorSettings.toBuilder() : null;
        }

        public final void setSelectorSettings(AudioSelectorSettings.BuilderImpl selectorSettings) {
            this.selectorSettings = selectorSettings != null ? selectorSettings.build() : null;
        }

        @Override
        public final Builder selectorSettings(AudioSelectorSettings selectorSettings) {
            this.selectorSettings = selectorSettings;
            return this;
        }

        public AudioSelector build() {
            return new AudioSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioSelector> {
        public Builder name(String var1);

        public Builder selectorSettings(AudioSelectorSettings var1);

        default public Builder selectorSettings(Consumer<AudioSelectorSettings.Builder> selectorSettings) {
            return this.selectorSettings((AudioSelectorSettings)((AudioSelectorSettings.Builder)AudioSelectorSettings.builder().applyMutation(selectorSettings)).build());
        }
    }
}

