/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FrameMetricType {
    PSNR("PSNR"),
    SSIM("SSIM"),
    MS_SSIM("MS_SSIM"),
    PSNR_HVS("PSNR_HVS"),
    VMAF("VMAF"),
    QVBR("QVBR"),
    SHOT_CHANGE("SHOT_CHANGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FrameMetricType> VALUE_MAP;
    private final String value;

    private FrameMetricType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FrameMetricType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FrameMetricType> knownValues() {
        EnumSet<FrameMetricType> knownValues = EnumSet.allOf(FrameMetricType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FrameMetricType.class, FrameMetricType::toString);
    }
}

