/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconvert.MediaConvertAsyncClient;
import software.amazon.awssdk.services.mediaconvert.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconvert.model.JobTemplate;
import software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesRequest;
import software.amazon.awssdk.services.mediaconvert.model.ListJobTemplatesResponse;

public class ListJobTemplatesPublisher
implements SdkPublisher<ListJobTemplatesResponse> {
    private final MediaConvertAsyncClient client;
    private final ListJobTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListJobTemplatesPublisher(MediaConvertAsyncClient client, ListJobTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListJobTemplatesPublisher(MediaConvertAsyncClient client, ListJobTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListJobTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListJobTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobTemplate> jobTemplates() {
        Function<ListJobTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobTemplates() != null) {
                return response.jobTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListJobTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListJobTemplatesResponseFetcher
    implements AsyncPageFetcher<ListJobTemplatesResponse> {
        private ListJobTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListJobTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListJobTemplatesResponse> nextPage(ListJobTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListJobTemplatesPublisher.this.client.listJobTemplates(ListJobTemplatesPublisher.this.firstRequest);
            }
            return ListJobTemplatesPublisher.this.client.listJobTemplates((ListJobTemplatesRequest)((Object)ListJobTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

