/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.AacSettings;
import software.amazon.awssdk.services.mediaconvert.model.Ac3Settings;
import software.amazon.awssdk.services.mediaconvert.model.AiffSettings;
import software.amazon.awssdk.services.mediaconvert.model.AudioCodec;
import software.amazon.awssdk.services.mediaconvert.model.Eac3AtmosSettings;
import software.amazon.awssdk.services.mediaconvert.model.Eac3Settings;
import software.amazon.awssdk.services.mediaconvert.model.FlacSettings;
import software.amazon.awssdk.services.mediaconvert.model.Mp2Settings;
import software.amazon.awssdk.services.mediaconvert.model.Mp3Settings;
import software.amazon.awssdk.services.mediaconvert.model.OpusSettings;
import software.amazon.awssdk.services.mediaconvert.model.VorbisSettings;
import software.amazon.awssdk.services.mediaconvert.model.WavSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioCodecSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioCodecSettings> {
    private static final SdkField<AacSettings> AAC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AacSettings").getter(AudioCodecSettings.getter(AudioCodecSettings::aacSettings)).setter(AudioCodecSettings.setter(Builder::aacSettings)).constructor(AacSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aacSettings").build()}).build();
    private static final SdkField<Ac3Settings> AC3_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ac3Settings").getter(AudioCodecSettings.getter(AudioCodecSettings::ac3Settings)).setter(AudioCodecSettings.setter(Builder::ac3Settings)).constructor(Ac3Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ac3Settings").build()}).build();
    private static final SdkField<AiffSettings> AIFF_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AiffSettings").getter(AudioCodecSettings.getter(AudioCodecSettings::aiffSettings)).setter(AudioCodecSettings.setter(Builder::aiffSettings)).constructor(AiffSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiffSettings").build()}).build();
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Codec").getter(AudioCodecSettings.getter(AudioCodecSettings::codecAsString)).setter(AudioCodecSettings.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codec").build()}).build();
    private static final SdkField<Eac3AtmosSettings> EAC3_ATMOS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Eac3AtmosSettings").getter(AudioCodecSettings.getter(AudioCodecSettings::eac3AtmosSettings)).setter(AudioCodecSettings.setter(Builder::eac3AtmosSettings)).constructor(Eac3AtmosSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eac3AtmosSettings").build()}).build();
    private static final SdkField<Eac3Settings> EAC3_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Eac3Settings").getter(AudioCodecSettings.getter(AudioCodecSettings::eac3Settings)).setter(AudioCodecSettings.setter(Builder::eac3Settings)).constructor(Eac3Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eac3Settings").build()}).build();
    private static final SdkField<FlacSettings> FLAC_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlacSettings").getter(AudioCodecSettings.getter(AudioCodecSettings::flacSettings)).setter(AudioCodecSettings.setter(Builder::flacSettings)).constructor(FlacSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flacSettings").build()}).build();
    private static final SdkField<Mp2Settings> MP2_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Mp2Settings").getter(AudioCodecSettings.getter(AudioCodecSettings::mp2Settings)).setter(AudioCodecSettings.setter(Builder::mp2Settings)).constructor(Mp2Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp2Settings").build()}).build();
    private static final SdkField<Mp3Settings> MP3_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Mp3Settings").getter(AudioCodecSettings.getter(AudioCodecSettings::mp3Settings)).setter(AudioCodecSettings.setter(Builder::mp3Settings)).constructor(Mp3Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp3Settings").build()}).build();
    private static final SdkField<OpusSettings> OPUS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpusSettings").getter(AudioCodecSettings.getter(AudioCodecSettings::opusSettings)).setter(AudioCodecSettings.setter(Builder::opusSettings)).constructor(OpusSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("opusSettings").build()}).build();
    private static final SdkField<VorbisSettings> VORBIS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VorbisSettings").getter(AudioCodecSettings.getter(AudioCodecSettings::vorbisSettings)).setter(AudioCodecSettings.setter(Builder::vorbisSettings)).constructor(VorbisSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vorbisSettings").build()}).build();
    private static final SdkField<WavSettings> WAV_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WavSettings").getter(AudioCodecSettings.getter(AudioCodecSettings::wavSettings)).setter(AudioCodecSettings.setter(Builder::wavSettings)).constructor(WavSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wavSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AAC_SETTINGS_FIELD, AC3_SETTINGS_FIELD, AIFF_SETTINGS_FIELD, CODEC_FIELD, EAC3_ATMOS_SETTINGS_FIELD, EAC3_SETTINGS_FIELD, FLAC_SETTINGS_FIELD, MP2_SETTINGS_FIELD, MP3_SETTINGS_FIELD, OPUS_SETTINGS_FIELD, VORBIS_SETTINGS_FIELD, WAV_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AudioCodecSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AacSettings aacSettings;
    private final Ac3Settings ac3Settings;
    private final AiffSettings aiffSettings;
    private final String codec;
    private final Eac3AtmosSettings eac3AtmosSettings;
    private final Eac3Settings eac3Settings;
    private final FlacSettings flacSettings;
    private final Mp2Settings mp2Settings;
    private final Mp3Settings mp3Settings;
    private final OpusSettings opusSettings;
    private final VorbisSettings vorbisSettings;
    private final WavSettings wavSettings;

    private AudioCodecSettings(BuilderImpl builder) {
        this.aacSettings = builder.aacSettings;
        this.ac3Settings = builder.ac3Settings;
        this.aiffSettings = builder.aiffSettings;
        this.codec = builder.codec;
        this.eac3AtmosSettings = builder.eac3AtmosSettings;
        this.eac3Settings = builder.eac3Settings;
        this.flacSettings = builder.flacSettings;
        this.mp2Settings = builder.mp2Settings;
        this.mp3Settings = builder.mp3Settings;
        this.opusSettings = builder.opusSettings;
        this.vorbisSettings = builder.vorbisSettings;
        this.wavSettings = builder.wavSettings;
    }

    public final AacSettings aacSettings() {
        return this.aacSettings;
    }

    public final Ac3Settings ac3Settings() {
        return this.ac3Settings;
    }

    public final AiffSettings aiffSettings() {
        return this.aiffSettings;
    }

    public final AudioCodec codec() {
        return AudioCodec.fromValue(this.codec);
    }

    public final String codecAsString() {
        return this.codec;
    }

    public final Eac3AtmosSettings eac3AtmosSettings() {
        return this.eac3AtmosSettings;
    }

    public final Eac3Settings eac3Settings() {
        return this.eac3Settings;
    }

    public final FlacSettings flacSettings() {
        return this.flacSettings;
    }

    public final Mp2Settings mp2Settings() {
        return this.mp2Settings;
    }

    public final Mp3Settings mp3Settings() {
        return this.mp3Settings;
    }

    public final OpusSettings opusSettings() {
        return this.opusSettings;
    }

    public final VorbisSettings vorbisSettings() {
        return this.vorbisSettings;
    }

    public final WavSettings wavSettings() {
        return this.wavSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.aacSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ac3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiffSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.eac3AtmosSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.eac3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.flacSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mp2Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mp3Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.opusSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.vorbisSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.wavSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioCodecSettings)) {
            return false;
        }
        AudioCodecSettings other = (AudioCodecSettings)obj;
        return Objects.equals(this.aacSettings(), other.aacSettings()) && Objects.equals(this.ac3Settings(), other.ac3Settings()) && Objects.equals(this.aiffSettings(), other.aiffSettings()) && Objects.equals(this.codecAsString(), other.codecAsString()) && Objects.equals(this.eac3AtmosSettings(), other.eac3AtmosSettings()) && Objects.equals(this.eac3Settings(), other.eac3Settings()) && Objects.equals(this.flacSettings(), other.flacSettings()) && Objects.equals(this.mp2Settings(), other.mp2Settings()) && Objects.equals(this.mp3Settings(), other.mp3Settings()) && Objects.equals(this.opusSettings(), other.opusSettings()) && Objects.equals(this.vorbisSettings(), other.vorbisSettings()) && Objects.equals(this.wavSettings(), other.wavSettings());
    }

    public final String toString() {
        return ToString.builder((String)"AudioCodecSettings").add("AacSettings", (Object)this.aacSettings()).add("Ac3Settings", (Object)this.ac3Settings()).add("AiffSettings", (Object)this.aiffSettings()).add("Codec", (Object)this.codecAsString()).add("Eac3AtmosSettings", (Object)this.eac3AtmosSettings()).add("Eac3Settings", (Object)this.eac3Settings()).add("FlacSettings", (Object)this.flacSettings()).add("Mp2Settings", (Object)this.mp2Settings()).add("Mp3Settings", (Object)this.mp3Settings()).add("OpusSettings", (Object)this.opusSettings()).add("VorbisSettings", (Object)this.vorbisSettings()).add("WavSettings", (Object)this.wavSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AacSettings": {
                return Optional.ofNullable(clazz.cast(this.aacSettings()));
            }
            case "Ac3Settings": {
                return Optional.ofNullable(clazz.cast(this.ac3Settings()));
            }
            case "AiffSettings": {
                return Optional.ofNullable(clazz.cast(this.aiffSettings()));
            }
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codecAsString()));
            }
            case "Eac3AtmosSettings": {
                return Optional.ofNullable(clazz.cast(this.eac3AtmosSettings()));
            }
            case "Eac3Settings": {
                return Optional.ofNullable(clazz.cast(this.eac3Settings()));
            }
            case "FlacSettings": {
                return Optional.ofNullable(clazz.cast(this.flacSettings()));
            }
            case "Mp2Settings": {
                return Optional.ofNullable(clazz.cast(this.mp2Settings()));
            }
            case "Mp3Settings": {
                return Optional.ofNullable(clazz.cast(this.mp3Settings()));
            }
            case "OpusSettings": {
                return Optional.ofNullable(clazz.cast(this.opusSettings()));
            }
            case "VorbisSettings": {
                return Optional.ofNullable(clazz.cast(this.vorbisSettings()));
            }
            case "WavSettings": {
                return Optional.ofNullable(clazz.cast(this.wavSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("aacSettings", AAC_SETTINGS_FIELD);
        map.put("ac3Settings", AC3_SETTINGS_FIELD);
        map.put("aiffSettings", AIFF_SETTINGS_FIELD);
        map.put("codec", CODEC_FIELD);
        map.put("eac3AtmosSettings", EAC3_ATMOS_SETTINGS_FIELD);
        map.put("eac3Settings", EAC3_SETTINGS_FIELD);
        map.put("flacSettings", FLAC_SETTINGS_FIELD);
        map.put("mp2Settings", MP2_SETTINGS_FIELD);
        map.put("mp3Settings", MP3_SETTINGS_FIELD);
        map.put("opusSettings", OPUS_SETTINGS_FIELD);
        map.put("vorbisSettings", VORBIS_SETTINGS_FIELD);
        map.put("wavSettings", WAV_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioCodecSettings, T> g) {
        return obj -> g.apply((AudioCodecSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AacSettings aacSettings;
        private Ac3Settings ac3Settings;
        private AiffSettings aiffSettings;
        private String codec;
        private Eac3AtmosSettings eac3AtmosSettings;
        private Eac3Settings eac3Settings;
        private FlacSettings flacSettings;
        private Mp2Settings mp2Settings;
        private Mp3Settings mp3Settings;
        private OpusSettings opusSettings;
        private VorbisSettings vorbisSettings;
        private WavSettings wavSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioCodecSettings model) {
            this.aacSettings(model.aacSettings);
            this.ac3Settings(model.ac3Settings);
            this.aiffSettings(model.aiffSettings);
            this.codec(model.codec);
            this.eac3AtmosSettings(model.eac3AtmosSettings);
            this.eac3Settings(model.eac3Settings);
            this.flacSettings(model.flacSettings);
            this.mp2Settings(model.mp2Settings);
            this.mp3Settings(model.mp3Settings);
            this.opusSettings(model.opusSettings);
            this.vorbisSettings(model.vorbisSettings);
            this.wavSettings(model.wavSettings);
        }

        public final AacSettings.Builder getAacSettings() {
            return this.aacSettings != null ? this.aacSettings.toBuilder() : null;
        }

        public final void setAacSettings(AacSettings.BuilderImpl aacSettings) {
            this.aacSettings = aacSettings != null ? aacSettings.build() : null;
        }

        @Override
        public final Builder aacSettings(AacSettings aacSettings) {
            this.aacSettings = aacSettings;
            return this;
        }

        public final Ac3Settings.Builder getAc3Settings() {
            return this.ac3Settings != null ? this.ac3Settings.toBuilder() : null;
        }

        public final void setAc3Settings(Ac3Settings.BuilderImpl ac3Settings) {
            this.ac3Settings = ac3Settings != null ? ac3Settings.build() : null;
        }

        @Override
        public final Builder ac3Settings(Ac3Settings ac3Settings) {
            this.ac3Settings = ac3Settings;
            return this;
        }

        public final AiffSettings.Builder getAiffSettings() {
            return this.aiffSettings != null ? this.aiffSettings.toBuilder() : null;
        }

        public final void setAiffSettings(AiffSettings.BuilderImpl aiffSettings) {
            this.aiffSettings = aiffSettings != null ? aiffSettings.build() : null;
        }

        @Override
        public final Builder aiffSettings(AiffSettings aiffSettings) {
            this.aiffSettings = aiffSettings;
            return this;
        }

        public final String getCodec() {
            return this.codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        @Override
        public final Builder codec(AudioCodec codec) {
            this.codec(codec == null ? null : codec.toString());
            return this;
        }

        public final Eac3AtmosSettings.Builder getEac3AtmosSettings() {
            return this.eac3AtmosSettings != null ? this.eac3AtmosSettings.toBuilder() : null;
        }

        public final void setEac3AtmosSettings(Eac3AtmosSettings.BuilderImpl eac3AtmosSettings) {
            this.eac3AtmosSettings = eac3AtmosSettings != null ? eac3AtmosSettings.build() : null;
        }

        @Override
        public final Builder eac3AtmosSettings(Eac3AtmosSettings eac3AtmosSettings) {
            this.eac3AtmosSettings = eac3AtmosSettings;
            return this;
        }

        public final Eac3Settings.Builder getEac3Settings() {
            return this.eac3Settings != null ? this.eac3Settings.toBuilder() : null;
        }

        public final void setEac3Settings(Eac3Settings.BuilderImpl eac3Settings) {
            this.eac3Settings = eac3Settings != null ? eac3Settings.build() : null;
        }

        @Override
        public final Builder eac3Settings(Eac3Settings eac3Settings) {
            this.eac3Settings = eac3Settings;
            return this;
        }

        public final FlacSettings.Builder getFlacSettings() {
            return this.flacSettings != null ? this.flacSettings.toBuilder() : null;
        }

        public final void setFlacSettings(FlacSettings.BuilderImpl flacSettings) {
            this.flacSettings = flacSettings != null ? flacSettings.build() : null;
        }

        @Override
        public final Builder flacSettings(FlacSettings flacSettings) {
            this.flacSettings = flacSettings;
            return this;
        }

        public final Mp2Settings.Builder getMp2Settings() {
            return this.mp2Settings != null ? this.mp2Settings.toBuilder() : null;
        }

        public final void setMp2Settings(Mp2Settings.BuilderImpl mp2Settings) {
            this.mp2Settings = mp2Settings != null ? mp2Settings.build() : null;
        }

        @Override
        public final Builder mp2Settings(Mp2Settings mp2Settings) {
            this.mp2Settings = mp2Settings;
            return this;
        }

        public final Mp3Settings.Builder getMp3Settings() {
            return this.mp3Settings != null ? this.mp3Settings.toBuilder() : null;
        }

        public final void setMp3Settings(Mp3Settings.BuilderImpl mp3Settings) {
            this.mp3Settings = mp3Settings != null ? mp3Settings.build() : null;
        }

        @Override
        public final Builder mp3Settings(Mp3Settings mp3Settings) {
            this.mp3Settings = mp3Settings;
            return this;
        }

        public final OpusSettings.Builder getOpusSettings() {
            return this.opusSettings != null ? this.opusSettings.toBuilder() : null;
        }

        public final void setOpusSettings(OpusSettings.BuilderImpl opusSettings) {
            this.opusSettings = opusSettings != null ? opusSettings.build() : null;
        }

        @Override
        public final Builder opusSettings(OpusSettings opusSettings) {
            this.opusSettings = opusSettings;
            return this;
        }

        public final VorbisSettings.Builder getVorbisSettings() {
            return this.vorbisSettings != null ? this.vorbisSettings.toBuilder() : null;
        }

        public final void setVorbisSettings(VorbisSettings.BuilderImpl vorbisSettings) {
            this.vorbisSettings = vorbisSettings != null ? vorbisSettings.build() : null;
        }

        @Override
        public final Builder vorbisSettings(VorbisSettings vorbisSettings) {
            this.vorbisSettings = vorbisSettings;
            return this;
        }

        public final WavSettings.Builder getWavSettings() {
            return this.wavSettings != null ? this.wavSettings.toBuilder() : null;
        }

        public final void setWavSettings(WavSettings.BuilderImpl wavSettings) {
            this.wavSettings = wavSettings != null ? wavSettings.build() : null;
        }

        @Override
        public final Builder wavSettings(WavSettings wavSettings) {
            this.wavSettings = wavSettings;
            return this;
        }

        public AudioCodecSettings build() {
            return new AudioCodecSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioCodecSettings> {
        public Builder aacSettings(AacSettings var1);

        default public Builder aacSettings(Consumer<AacSettings.Builder> aacSettings) {
            return this.aacSettings((AacSettings)((AacSettings.Builder)AacSettings.builder().applyMutation(aacSettings)).build());
        }

        public Builder ac3Settings(Ac3Settings var1);

        default public Builder ac3Settings(Consumer<Ac3Settings.Builder> ac3Settings) {
            return this.ac3Settings((Ac3Settings)((Ac3Settings.Builder)Ac3Settings.builder().applyMutation(ac3Settings)).build());
        }

        public Builder aiffSettings(AiffSettings var1);

        default public Builder aiffSettings(Consumer<AiffSettings.Builder> aiffSettings) {
            return this.aiffSettings((AiffSettings)((AiffSettings.Builder)AiffSettings.builder().applyMutation(aiffSettings)).build());
        }

        public Builder codec(String var1);

        public Builder codec(AudioCodec var1);

        public Builder eac3AtmosSettings(Eac3AtmosSettings var1);

        default public Builder eac3AtmosSettings(Consumer<Eac3AtmosSettings.Builder> eac3AtmosSettings) {
            return this.eac3AtmosSettings((Eac3AtmosSettings)((Eac3AtmosSettings.Builder)Eac3AtmosSettings.builder().applyMutation(eac3AtmosSettings)).build());
        }

        public Builder eac3Settings(Eac3Settings var1);

        default public Builder eac3Settings(Consumer<Eac3Settings.Builder> eac3Settings) {
            return this.eac3Settings((Eac3Settings)((Eac3Settings.Builder)Eac3Settings.builder().applyMutation(eac3Settings)).build());
        }

        public Builder flacSettings(FlacSettings var1);

        default public Builder flacSettings(Consumer<FlacSettings.Builder> flacSettings) {
            return this.flacSettings((FlacSettings)((FlacSettings.Builder)FlacSettings.builder().applyMutation(flacSettings)).build());
        }

        public Builder mp2Settings(Mp2Settings var1);

        default public Builder mp2Settings(Consumer<Mp2Settings.Builder> mp2Settings) {
            return this.mp2Settings((Mp2Settings)((Mp2Settings.Builder)Mp2Settings.builder().applyMutation(mp2Settings)).build());
        }

        public Builder mp3Settings(Mp3Settings var1);

        default public Builder mp3Settings(Consumer<Mp3Settings.Builder> mp3Settings) {
            return this.mp3Settings((Mp3Settings)((Mp3Settings.Builder)Mp3Settings.builder().applyMutation(mp3Settings)).build());
        }

        public Builder opusSettings(OpusSettings var1);

        default public Builder opusSettings(Consumer<OpusSettings.Builder> opusSettings) {
            return this.opusSettings((OpusSettings)((OpusSettings.Builder)OpusSettings.builder().applyMutation(opusSettings)).build());
        }

        public Builder vorbisSettings(VorbisSettings var1);

        default public Builder vorbisSettings(Consumer<VorbisSettings.Builder> vorbisSettings) {
            return this.vorbisSettings((VorbisSettings)((VorbisSettings.Builder)VorbisSettings.builder().applyMutation(vorbisSettings)).build());
        }

        public Builder wavSettings(WavSettings var1);

        default public Builder wavSettings(Consumer<WavSettings.Builder> wavSettings) {
            return this.wavSettings((WavSettings)((WavSettings.Builder)WavSettings.builder().applyMutation(wavSettings)).build());
        }
    }
}

