/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.VideoOverlayUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoOverlayPosition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoOverlayPosition> {
    private static final SdkField<Integer> HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Height").getter(VideoOverlayPosition.getter(VideoOverlayPosition::height)).setter(VideoOverlayPosition.setter(Builder::height)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("height").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(VideoOverlayPosition.getter(VideoOverlayPosition::unitAsString)).setter(VideoOverlayPosition.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<Integer> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Width").getter(VideoOverlayPosition.getter(VideoOverlayPosition::width)).setter(VideoOverlayPosition.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("width").build()}).build();
    private static final SdkField<Integer> X_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("XPosition").getter(VideoOverlayPosition.getter(VideoOverlayPosition::xPosition)).setter(VideoOverlayPosition.setter(Builder::xPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xPosition").build()}).build();
    private static final SdkField<Integer> Y_POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("YPosition").getter(VideoOverlayPosition.getter(VideoOverlayPosition::yPosition)).setter(VideoOverlayPosition.setter(Builder::yPosition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("yPosition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEIGHT_FIELD, UNIT_FIELD, WIDTH_FIELD, X_POSITION_FIELD, Y_POSITION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VideoOverlayPosition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer height;
    private final String unit;
    private final Integer width;
    private final Integer xPosition;
    private final Integer yPosition;

    private VideoOverlayPosition(BuilderImpl builder) {
        this.height = builder.height;
        this.unit = builder.unit;
        this.width = builder.width;
        this.xPosition = builder.xPosition;
        this.yPosition = builder.yPosition;
    }

    public final Integer height() {
        return this.height;
    }

    public final VideoOverlayUnit unit() {
        return VideoOverlayUnit.fromValue(this.unit);
    }

    public final String unitAsString() {
        return this.unit;
    }

    public final Integer width() {
        return this.width;
    }

    public final Integer xPosition() {
        return this.xPosition;
    }

    public final Integer yPosition() {
        return this.yPosition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.height());
        hashCode = 31 * hashCode + Objects.hashCode(this.unitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        hashCode = 31 * hashCode + Objects.hashCode(this.xPosition());
        hashCode = 31 * hashCode + Objects.hashCode(this.yPosition());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoOverlayPosition)) {
            return false;
        }
        VideoOverlayPosition other = (VideoOverlayPosition)obj;
        return Objects.equals(this.height(), other.height()) && Objects.equals(this.unitAsString(), other.unitAsString()) && Objects.equals(this.width(), other.width()) && Objects.equals(this.xPosition(), other.xPosition()) && Objects.equals(this.yPosition(), other.yPosition());
    }

    public final String toString() {
        return ToString.builder((String)"VideoOverlayPosition").add("Height", (Object)this.height()).add("Unit", (Object)this.unitAsString()).add("Width", (Object)this.width()).add("XPosition", (Object)this.xPosition()).add("YPosition", (Object)this.yPosition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Height": {
                return Optional.ofNullable(clazz.cast(this.height()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unitAsString()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
            case "XPosition": {
                return Optional.ofNullable(clazz.cast(this.xPosition()));
            }
            case "YPosition": {
                return Optional.ofNullable(clazz.cast(this.yPosition()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("height", HEIGHT_FIELD);
        map.put("unit", UNIT_FIELD);
        map.put("width", WIDTH_FIELD);
        map.put("xPosition", X_POSITION_FIELD);
        map.put("yPosition", Y_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoOverlayPosition, T> g) {
        return obj -> g.apply((VideoOverlayPosition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer height;
        private String unit;
        private Integer width;
        private Integer xPosition;
        private Integer yPosition;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoOverlayPosition model) {
            this.height(model.height);
            this.unit(model.unit);
            this.width(model.width);
            this.xPosition(model.xPosition);
            this.yPosition(model.yPosition);
        }

        public final Integer getHeight() {
            return this.height;
        }

        public final void setHeight(Integer height) {
            this.height = height;
        }

        @Override
        public final Builder height(Integer height) {
            this.height = height;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(VideoOverlayUnit unit) {
            this.unit(unit == null ? null : unit.toString());
            return this;
        }

        public final Integer getWidth() {
            return this.width;
        }

        public final void setWidth(Integer width) {
            this.width = width;
        }

        @Override
        public final Builder width(Integer width) {
            this.width = width;
            return this;
        }

        public final Integer getXPosition() {
            return this.xPosition;
        }

        public final void setXPosition(Integer xPosition) {
            this.xPosition = xPosition;
        }

        @Override
        public final Builder xPosition(Integer xPosition) {
            this.xPosition = xPosition;
            return this;
        }

        public final Integer getYPosition() {
            return this.yPosition;
        }

        public final void setYPosition(Integer yPosition) {
            this.yPosition = yPosition;
        }

        @Override
        public final Builder yPosition(Integer yPosition) {
            this.yPosition = yPosition;
            return this;
        }

        public VideoOverlayPosition build() {
            return new VideoOverlayPosition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoOverlayPosition> {
        public Builder height(Integer var1);

        public Builder unit(String var1);

        public Builder unit(VideoOverlayUnit var1);

        public Builder width(Integer var1);

        public Builder xPosition(Integer var1);

        public Builder yPosition(Integer var1);
    }
}

