/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.TamsGapHandling;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputTamsSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputTamsSettings> {
    private static final SdkField<String> AUTH_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthConnectionArn").getter(InputTamsSettings.getter(InputTamsSettings::authConnectionArn)).setter(InputTamsSettings.setter(Builder::authConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authConnectionArn").build()}).build();
    private static final SdkField<String> GAP_HANDLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GapHandling").getter(InputTamsSettings.getter(InputTamsSettings::gapHandlingAsString)).setter(InputTamsSettings.setter(Builder::gapHandling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gapHandling").build()}).build();
    private static final SdkField<String> SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceId").getter(InputTamsSettings.getter(InputTamsSettings::sourceId)).setter(InputTamsSettings.setter(Builder::sourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceId").build()}).build();
    private static final SdkField<String> TIMERANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timerange").getter(InputTamsSettings.getter(InputTamsSettings::timerange)).setter(InputTamsSettings.setter(Builder::timerange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timerange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_CONNECTION_ARN_FIELD, GAP_HANDLING_FIELD, SOURCE_ID_FIELD, TIMERANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InputTamsSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String authConnectionArn;
    private final String gapHandling;
    private final String sourceId;
    private final String timerange;

    private InputTamsSettings(BuilderImpl builder) {
        this.authConnectionArn = builder.authConnectionArn;
        this.gapHandling = builder.gapHandling;
        this.sourceId = builder.sourceId;
        this.timerange = builder.timerange;
    }

    public final String authConnectionArn() {
        return this.authConnectionArn;
    }

    public final TamsGapHandling gapHandling() {
        return TamsGapHandling.fromValue(this.gapHandling);
    }

    public final String gapHandlingAsString() {
        return this.gapHandling;
    }

    public final String sourceId() {
        return this.sourceId;
    }

    public final String timerange() {
        return this.timerange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.gapHandlingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.timerange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputTamsSettings)) {
            return false;
        }
        InputTamsSettings other = (InputTamsSettings)obj;
        return Objects.equals(this.authConnectionArn(), other.authConnectionArn()) && Objects.equals(this.gapHandlingAsString(), other.gapHandlingAsString()) && Objects.equals(this.sourceId(), other.sourceId()) && Objects.equals(this.timerange(), other.timerange());
    }

    public final String toString() {
        return ToString.builder((String)"InputTamsSettings").add("AuthConnectionArn", (Object)this.authConnectionArn()).add("GapHandling", (Object)this.gapHandlingAsString()).add("SourceId", (Object)this.sourceId()).add("Timerange", (Object)this.timerange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.authConnectionArn()));
            }
            case "GapHandling": {
                return Optional.ofNullable(clazz.cast(this.gapHandlingAsString()));
            }
            case "SourceId": {
                return Optional.ofNullable(clazz.cast(this.sourceId()));
            }
            case "Timerange": {
                return Optional.ofNullable(clazz.cast(this.timerange()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("authConnectionArn", AUTH_CONNECTION_ARN_FIELD);
        map.put("gapHandling", GAP_HANDLING_FIELD);
        map.put("sourceId", SOURCE_ID_FIELD);
        map.put("timerange", TIMERANGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputTamsSettings, T> g) {
        return obj -> g.apply((InputTamsSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authConnectionArn;
        private String gapHandling;
        private String sourceId;
        private String timerange;

        private BuilderImpl() {
        }

        private BuilderImpl(InputTamsSettings model) {
            this.authConnectionArn(model.authConnectionArn);
            this.gapHandling(model.gapHandling);
            this.sourceId(model.sourceId);
            this.timerange(model.timerange);
        }

        public final String getAuthConnectionArn() {
            return this.authConnectionArn;
        }

        public final void setAuthConnectionArn(String authConnectionArn) {
            this.authConnectionArn = authConnectionArn;
        }

        @Override
        public final Builder authConnectionArn(String authConnectionArn) {
            this.authConnectionArn = authConnectionArn;
            return this;
        }

        public final String getGapHandling() {
            return this.gapHandling;
        }

        public final void setGapHandling(String gapHandling) {
            this.gapHandling = gapHandling;
        }

        @Override
        public final Builder gapHandling(String gapHandling) {
            this.gapHandling = gapHandling;
            return this;
        }

        @Override
        public final Builder gapHandling(TamsGapHandling gapHandling) {
            this.gapHandling(gapHandling == null ? null : gapHandling.toString());
            return this;
        }

        public final String getSourceId() {
            return this.sourceId;
        }

        public final void setSourceId(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public final Builder sourceId(String sourceId) {
            this.sourceId = sourceId;
            return this;
        }

        public final String getTimerange() {
            return this.timerange;
        }

        public final void setTimerange(String timerange) {
            this.timerange = timerange;
        }

        @Override
        public final Builder timerange(String timerange) {
            this.timerange = timerange;
            return this;
        }

        public InputTamsSettings build() {
            return new InputTamsSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputTamsSettings> {
        public Builder authConnectionArn(String var1);

        public Builder gapHandling(String var1);

        public Builder gapHandling(TamsGapHandling var1);

        public Builder sourceId(String var1);

        public Builder timerange(String var1);
    }
}

