/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AudioLanguageCodeControl {
    FOLLOW_INPUT("FOLLOW_INPUT"),
    USE_CONFIGURED("USE_CONFIGURED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AudioLanguageCodeControl> VALUE_MAP;
    private final String value;

    private AudioLanguageCodeControl(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AudioLanguageCodeControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AudioLanguageCodeControl> knownValues() {
        EnumSet<AudioLanguageCodeControl> knownValues = EnumSet.allOf(AudioLanguageCodeControl.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AudioLanguageCodeControl.class, AudioLanguageCodeControl::toString);
    }
}

