/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrackType {
    VIDEO("video"),
    AUDIO("audio"),
    DATA("data"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrackType> VALUE_MAP;
    private final String value;

    private TrackType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrackType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrackType> knownValues() {
        EnumSet<TrackType> knownValues = EnumSet.allOf(TrackType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrackType.class, TrackType::toString);
    }
}

