/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MatrixCoefficients {
    RGB("RGB"),
    ITU_709("ITU_709"),
    UNSPECIFIED("UNSPECIFIED"),
    RESERVED("RESERVED"),
    FCC("FCC"),
    ITU_470_BG("ITU_470BG"),
    SMPTE_170_M("SMPTE_170M"),
    SMPTE_240_M("SMPTE_240M"),
    Y_CG_CO("YCgCo"),
    ITU_2020_NCL("ITU_2020_NCL"),
    ITU_2020_CL("ITU_2020_CL"),
    SMPTE_2085("SMPTE_2085"),
    CD_NCL("CD_NCL"),
    CD_CL("CD_CL"),
    ITU_2100_I_CT_CP("ITU_2100ICtCp"),
    IPT("IPT"),
    EBU3213("EBU3213"),
    LAST("LAST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MatrixCoefficients> VALUE_MAP;
    private final String value;

    private MatrixCoefficients(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MatrixCoefficients fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MatrixCoefficients> knownValues() {
        EnumSet<MatrixCoefficients> knownValues = EnumSet.allOf(MatrixCoefficients.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MatrixCoefficients.class, MatrixCoefficients::toString);
    }
}

