/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.AudioDurationCorrection;
import software.amazon.awssdk.services.mediaconvert.model.DynamicAudioSelectorType;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamicAudioSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DynamicAudioSelector> {
    private static final SdkField<String> AUDIO_DURATION_CORRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioDurationCorrection").getter(DynamicAudioSelector.getter(DynamicAudioSelector::audioDurationCorrectionAsString)).setter(DynamicAudioSelector.setter(Builder::audioDurationCorrection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDurationCorrection").build()}).build();
    private static final SdkField<String> EXTERNAL_AUDIO_FILE_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExternalAudioFileInput").getter(DynamicAudioSelector.getter(DynamicAudioSelector::externalAudioFileInput)).setter(DynamicAudioSelector.setter(Builder::externalAudioFileInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalAudioFileInput").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(DynamicAudioSelector.getter(DynamicAudioSelector::languageCodeAsString)).setter(DynamicAudioSelector.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()}).build();
    private static final SdkField<Integer> OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Offset").getter(DynamicAudioSelector.getter(DynamicAudioSelector::offset)).setter(DynamicAudioSelector.setter(Builder::offset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offset").build()}).build();
    private static final SdkField<String> SELECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SelectorType").getter(DynamicAudioSelector.getter(DynamicAudioSelector::selectorTypeAsString)).setter(DynamicAudioSelector.setter(Builder::selectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectorType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_DURATION_CORRECTION_FIELD, EXTERNAL_AUDIO_FILE_INPUT_FIELD, LANGUAGE_CODE_FIELD, OFFSET_FIELD, SELECTOR_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DynamicAudioSelector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String audioDurationCorrection;
    private final String externalAudioFileInput;
    private final String languageCode;
    private final Integer offset;
    private final String selectorType;

    private DynamicAudioSelector(BuilderImpl builder) {
        this.audioDurationCorrection = builder.audioDurationCorrection;
        this.externalAudioFileInput = builder.externalAudioFileInput;
        this.languageCode = builder.languageCode;
        this.offset = builder.offset;
        this.selectorType = builder.selectorType;
    }

    public final AudioDurationCorrection audioDurationCorrection() {
        return AudioDurationCorrection.fromValue(this.audioDurationCorrection);
    }

    public final String audioDurationCorrectionAsString() {
        return this.audioDurationCorrection;
    }

    public final String externalAudioFileInput() {
        return this.externalAudioFileInput;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final Integer offset() {
        return this.offset;
    }

    public final DynamicAudioSelectorType selectorType() {
        return DynamicAudioSelectorType.fromValue(this.selectorType);
    }

    public final String selectorTypeAsString() {
        return this.selectorType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDurationCorrectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalAudioFileInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offset());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectorTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicAudioSelector)) {
            return false;
        }
        DynamicAudioSelector other = (DynamicAudioSelector)obj;
        return Objects.equals(this.audioDurationCorrectionAsString(), other.audioDurationCorrectionAsString()) && Objects.equals(this.externalAudioFileInput(), other.externalAudioFileInput()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.offset(), other.offset()) && Objects.equals(this.selectorTypeAsString(), other.selectorTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DynamicAudioSelector").add("AudioDurationCorrection", (Object)this.audioDurationCorrectionAsString()).add("ExternalAudioFileInput", (Object)this.externalAudioFileInput()).add("LanguageCode", (Object)this.languageCodeAsString()).add("Offset", (Object)this.offset()).add("SelectorType", (Object)this.selectorTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioDurationCorrection": {
                return Optional.ofNullable(clazz.cast(this.audioDurationCorrectionAsString()));
            }
            case "ExternalAudioFileInput": {
                return Optional.ofNullable(clazz.cast(this.externalAudioFileInput()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "Offset": {
                return Optional.ofNullable(clazz.cast(this.offset()));
            }
            case "SelectorType": {
                return Optional.ofNullable(clazz.cast(this.selectorTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("audioDurationCorrection", AUDIO_DURATION_CORRECTION_FIELD);
        map.put("externalAudioFileInput", EXTERNAL_AUDIO_FILE_INPUT_FIELD);
        map.put("languageCode", LANGUAGE_CODE_FIELD);
        map.put("offset", OFFSET_FIELD);
        map.put("selectorType", SELECTOR_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DynamicAudioSelector, T> g) {
        return obj -> g.apply((DynamicAudioSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioDurationCorrection;
        private String externalAudioFileInput;
        private String languageCode;
        private Integer offset;
        private String selectorType;

        private BuilderImpl() {
        }

        private BuilderImpl(DynamicAudioSelector model) {
            this.audioDurationCorrection(model.audioDurationCorrection);
            this.externalAudioFileInput(model.externalAudioFileInput);
            this.languageCode(model.languageCode);
            this.offset(model.offset);
            this.selectorType(model.selectorType);
        }

        public final String getAudioDurationCorrection() {
            return this.audioDurationCorrection;
        }

        public final void setAudioDurationCorrection(String audioDurationCorrection) {
            this.audioDurationCorrection = audioDurationCorrection;
        }

        @Override
        public final Builder audioDurationCorrection(String audioDurationCorrection) {
            this.audioDurationCorrection = audioDurationCorrection;
            return this;
        }

        @Override
        public final Builder audioDurationCorrection(AudioDurationCorrection audioDurationCorrection) {
            this.audioDurationCorrection(audioDurationCorrection == null ? null : audioDurationCorrection.toString());
            return this;
        }

        public final String getExternalAudioFileInput() {
            return this.externalAudioFileInput;
        }

        public final void setExternalAudioFileInput(String externalAudioFileInput) {
            this.externalAudioFileInput = externalAudioFileInput;
        }

        @Override
        public final Builder externalAudioFileInput(String externalAudioFileInput) {
            this.externalAudioFileInput = externalAudioFileInput;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final Integer getOffset() {
            return this.offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final String getSelectorType() {
            return this.selectorType;
        }

        public final void setSelectorType(String selectorType) {
            this.selectorType = selectorType;
        }

        @Override
        public final Builder selectorType(String selectorType) {
            this.selectorType = selectorType;
            return this;
        }

        @Override
        public final Builder selectorType(DynamicAudioSelectorType selectorType) {
            this.selectorType(selectorType == null ? null : selectorType.toString());
            return this;
        }

        public DynamicAudioSelector build() {
            return new DynamicAudioSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DynamicAudioSelector> {
        public Builder audioDurationCorrection(String var1);

        public Builder audioDurationCorrection(AudioDurationCorrection var1);

        public Builder externalAudioFileInput(String var1);

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder offset(Integer var1);

        public Builder selectorType(String var1);

        public Builder selectorType(DynamicAudioSelectorType var1);
    }
}

