/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.AvailBlanking;
import software.amazon.awssdk.services.mediaconvert.model.ColorConversion3DLUTSetting;
import software.amazon.awssdk.services.mediaconvert.model.EsamSettings;
import software.amazon.awssdk.services.mediaconvert.model.ExtendedDataServices;
import software.amazon.awssdk.services.mediaconvert.model.Input;
import software.amazon.awssdk.services.mediaconvert.model.KantarWatermarkSettings;
import software.amazon.awssdk.services.mediaconvert.model.MotionImageInserter;
import software.amazon.awssdk.services.mediaconvert.model.NielsenConfiguration;
import software.amazon.awssdk.services.mediaconvert.model.NielsenNonLinearWatermarkSettings;
import software.amazon.awssdk.services.mediaconvert.model.OutputGroup;
import software.amazon.awssdk.services.mediaconvert.model.TimecodeConfig;
import software.amazon.awssdk.services.mediaconvert.model.TimedMetadataInsertion;
import software.amazon.awssdk.services.mediaconvert.model.___listOfColorConversion3DLUTSettingCopier;
import software.amazon.awssdk.services.mediaconvert.model.___listOfInputCopier;
import software.amazon.awssdk.services.mediaconvert.model.___listOfOutputGroupCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobSettings> {
    private static final SdkField<Integer> AD_AVAIL_OFFSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AdAvailOffset").getter(JobSettings.getter(JobSettings::adAvailOffset)).setter(JobSettings.setter(Builder::adAvailOffset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adAvailOffset").build()}).build();
    private static final SdkField<AvailBlanking> AVAIL_BLANKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AvailBlanking").getter(JobSettings.getter(JobSettings::availBlanking)).setter(JobSettings.setter(Builder::availBlanking)).constructor(AvailBlanking::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availBlanking").build()}).build();
    private static final SdkField<List<ColorConversion3DLUTSetting>> COLOR_CONVERSION3_DLUT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColorConversion3DLUTSettings").getter(JobSettings.getter(JobSettings::colorConversion3DLUTSettings)).setter(JobSettings.setter(Builder::colorConversion3DLUTSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("colorConversion3DLUTSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColorConversion3DLUTSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EsamSettings> ESAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Esam").getter(JobSettings.getter(JobSettings::esam)).setter(JobSettings.setter(Builder::esam)).constructor(EsamSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("esam").build()}).build();
    private static final SdkField<ExtendedDataServices> EXTENDED_DATA_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExtendedDataServices").getter(JobSettings.getter(JobSettings::extendedDataServices)).setter(JobSettings.setter(Builder::extendedDataServices)).constructor(ExtendedDataServices::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendedDataServices").build()}).build();
    private static final SdkField<Integer> FOLLOW_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FollowSource").getter(JobSettings.getter(JobSettings::followSource)).setter(JobSettings.setter(Builder::followSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("followSource").build()}).build();
    private static final SdkField<List<Input>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(JobSettings.getter(JobSettings::inputs)).setter(JobSettings.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Input::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<KantarWatermarkSettings> KANTAR_WATERMARK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KantarWatermark").getter(JobSettings.getter(JobSettings::kantarWatermark)).setter(JobSettings.setter(Builder::kantarWatermark)).constructor(KantarWatermarkSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kantarWatermark").build()}).build();
    private static final SdkField<MotionImageInserter> MOTION_IMAGE_INSERTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MotionImageInserter").getter(JobSettings.getter(JobSettings::motionImageInserter)).setter(JobSettings.setter(Builder::motionImageInserter)).constructor(MotionImageInserter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("motionImageInserter").build()}).build();
    private static final SdkField<NielsenConfiguration> NIELSEN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NielsenConfiguration").getter(JobSettings.getter(JobSettings::nielsenConfiguration)).setter(JobSettings.setter(Builder::nielsenConfiguration)).constructor(NielsenConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenConfiguration").build()}).build();
    private static final SdkField<NielsenNonLinearWatermarkSettings> NIELSEN_NON_LINEAR_WATERMARK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NielsenNonLinearWatermark").getter(JobSettings.getter(JobSettings::nielsenNonLinearWatermark)).setter(JobSettings.setter(Builder::nielsenNonLinearWatermark)).constructor(NielsenNonLinearWatermarkSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nielsenNonLinearWatermark").build()}).build();
    private static final SdkField<List<OutputGroup>> OUTPUT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OutputGroups").getter(JobSettings.getter(JobSettings::outputGroups)).setter(JobSettings.setter(Builder::outputGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TimecodeConfig> TIMECODE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimecodeConfig").getter(JobSettings.getter(JobSettings::timecodeConfig)).setter(JobSettings.setter(Builder::timecodeConfig)).constructor(TimecodeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeConfig").build()}).build();
    private static final SdkField<TimedMetadataInsertion> TIMED_METADATA_INSERTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimedMetadataInsertion").getter(JobSettings.getter(JobSettings::timedMetadataInsertion)).setter(JobSettings.setter(Builder::timedMetadataInsertion)).constructor(TimedMetadataInsertion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataInsertion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_AVAIL_OFFSET_FIELD, AVAIL_BLANKING_FIELD, COLOR_CONVERSION3_DLUT_SETTINGS_FIELD, ESAM_FIELD, EXTENDED_DATA_SERVICES_FIELD, FOLLOW_SOURCE_FIELD, INPUTS_FIELD, KANTAR_WATERMARK_FIELD, MOTION_IMAGE_INSERTER_FIELD, NIELSEN_CONFIGURATION_FIELD, NIELSEN_NON_LINEAR_WATERMARK_FIELD, OUTPUT_GROUPS_FIELD, TIMECODE_CONFIG_FIELD, TIMED_METADATA_INSERTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = JobSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer adAvailOffset;
    private final AvailBlanking availBlanking;
    private final List<ColorConversion3DLUTSetting> colorConversion3DLUTSettings;
    private final EsamSettings esam;
    private final ExtendedDataServices extendedDataServices;
    private final Integer followSource;
    private final List<Input> inputs;
    private final KantarWatermarkSettings kantarWatermark;
    private final MotionImageInserter motionImageInserter;
    private final NielsenConfiguration nielsenConfiguration;
    private final NielsenNonLinearWatermarkSettings nielsenNonLinearWatermark;
    private final List<OutputGroup> outputGroups;
    private final TimecodeConfig timecodeConfig;
    private final TimedMetadataInsertion timedMetadataInsertion;

    private JobSettings(BuilderImpl builder) {
        this.adAvailOffset = builder.adAvailOffset;
        this.availBlanking = builder.availBlanking;
        this.colorConversion3DLUTSettings = builder.colorConversion3DLUTSettings;
        this.esam = builder.esam;
        this.extendedDataServices = builder.extendedDataServices;
        this.followSource = builder.followSource;
        this.inputs = builder.inputs;
        this.kantarWatermark = builder.kantarWatermark;
        this.motionImageInserter = builder.motionImageInserter;
        this.nielsenConfiguration = builder.nielsenConfiguration;
        this.nielsenNonLinearWatermark = builder.nielsenNonLinearWatermark;
        this.outputGroups = builder.outputGroups;
        this.timecodeConfig = builder.timecodeConfig;
        this.timedMetadataInsertion = builder.timedMetadataInsertion;
    }

    public final Integer adAvailOffset() {
        return this.adAvailOffset;
    }

    public final AvailBlanking availBlanking() {
        return this.availBlanking;
    }

    public final boolean hasColorConversion3DLUTSettings() {
        return this.colorConversion3DLUTSettings != null && !(this.colorConversion3DLUTSettings instanceof SdkAutoConstructList);
    }

    public final List<ColorConversion3DLUTSetting> colorConversion3DLUTSettings() {
        return this.colorConversion3DLUTSettings;
    }

    public final EsamSettings esam() {
        return this.esam;
    }

    public final ExtendedDataServices extendedDataServices() {
        return this.extendedDataServices;
    }

    public final Integer followSource() {
        return this.followSource;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<Input> inputs() {
        return this.inputs;
    }

    public final KantarWatermarkSettings kantarWatermark() {
        return this.kantarWatermark;
    }

    public final MotionImageInserter motionImageInserter() {
        return this.motionImageInserter;
    }

    public final NielsenConfiguration nielsenConfiguration() {
        return this.nielsenConfiguration;
    }

    public final NielsenNonLinearWatermarkSettings nielsenNonLinearWatermark() {
        return this.nielsenNonLinearWatermark;
    }

    public final boolean hasOutputGroups() {
        return this.outputGroups != null && !(this.outputGroups instanceof SdkAutoConstructList);
    }

    public final List<OutputGroup> outputGroups() {
        return this.outputGroups;
    }

    public final TimecodeConfig timecodeConfig() {
        return this.timecodeConfig;
    }

    public final TimedMetadataInsertion timedMetadataInsertion() {
        return this.timedMetadataInsertion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adAvailOffset());
        hashCode = 31 * hashCode + Objects.hashCode(this.availBlanking());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColorConversion3DLUTSettings() ? this.colorConversion3DLUTSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.esam());
        hashCode = 31 * hashCode + Objects.hashCode(this.extendedDataServices());
        hashCode = 31 * hashCode + Objects.hashCode(this.followSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kantarWatermark());
        hashCode = 31 * hashCode + Objects.hashCode(this.motionImageInserter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nielsenConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.nielsenNonLinearWatermark());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputGroups() ? this.outputGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataInsertion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSettings)) {
            return false;
        }
        JobSettings other = (JobSettings)obj;
        return Objects.equals(this.adAvailOffset(), other.adAvailOffset()) && Objects.equals(this.availBlanking(), other.availBlanking()) && this.hasColorConversion3DLUTSettings() == other.hasColorConversion3DLUTSettings() && Objects.equals(this.colorConversion3DLUTSettings(), other.colorConversion3DLUTSettings()) && Objects.equals(this.esam(), other.esam()) && Objects.equals(this.extendedDataServices(), other.extendedDataServices()) && Objects.equals(this.followSource(), other.followSource()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.kantarWatermark(), other.kantarWatermark()) && Objects.equals(this.motionImageInserter(), other.motionImageInserter()) && Objects.equals(this.nielsenConfiguration(), other.nielsenConfiguration()) && Objects.equals(this.nielsenNonLinearWatermark(), other.nielsenNonLinearWatermark()) && this.hasOutputGroups() == other.hasOutputGroups() && Objects.equals(this.outputGroups(), other.outputGroups()) && Objects.equals(this.timecodeConfig(), other.timecodeConfig()) && Objects.equals(this.timedMetadataInsertion(), other.timedMetadataInsertion());
    }

    public final String toString() {
        return ToString.builder((String)"JobSettings").add("AdAvailOffset", (Object)this.adAvailOffset()).add("AvailBlanking", (Object)this.availBlanking()).add("ColorConversion3DLUTSettings", this.hasColorConversion3DLUTSettings() ? this.colorConversion3DLUTSettings() : null).add("Esam", (Object)this.esam()).add("ExtendedDataServices", (Object)this.extendedDataServices()).add("FollowSource", (Object)this.followSource()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("KantarWatermark", (Object)this.kantarWatermark()).add("MotionImageInserter", (Object)this.motionImageInserter()).add("NielsenConfiguration", (Object)this.nielsenConfiguration()).add("NielsenNonLinearWatermark", (Object)this.nielsenNonLinearWatermark()).add("OutputGroups", this.hasOutputGroups() ? this.outputGroups() : null).add("TimecodeConfig", (Object)this.timecodeConfig()).add("TimedMetadataInsertion", (Object)this.timedMetadataInsertion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdAvailOffset": {
                return Optional.ofNullable(clazz.cast(this.adAvailOffset()));
            }
            case "AvailBlanking": {
                return Optional.ofNullable(clazz.cast(this.availBlanking()));
            }
            case "ColorConversion3DLUTSettings": {
                return Optional.ofNullable(clazz.cast(this.colorConversion3DLUTSettings()));
            }
            case "Esam": {
                return Optional.ofNullable(clazz.cast(this.esam()));
            }
            case "ExtendedDataServices": {
                return Optional.ofNullable(clazz.cast(this.extendedDataServices()));
            }
            case "FollowSource": {
                return Optional.ofNullable(clazz.cast(this.followSource()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "KantarWatermark": {
                return Optional.ofNullable(clazz.cast(this.kantarWatermark()));
            }
            case "MotionImageInserter": {
                return Optional.ofNullable(clazz.cast(this.motionImageInserter()));
            }
            case "NielsenConfiguration": {
                return Optional.ofNullable(clazz.cast(this.nielsenConfiguration()));
            }
            case "NielsenNonLinearWatermark": {
                return Optional.ofNullable(clazz.cast(this.nielsenNonLinearWatermark()));
            }
            case "OutputGroups": {
                return Optional.ofNullable(clazz.cast(this.outputGroups()));
            }
            case "TimecodeConfig": {
                return Optional.ofNullable(clazz.cast(this.timecodeConfig()));
            }
            case "TimedMetadataInsertion": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataInsertion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("adAvailOffset", AD_AVAIL_OFFSET_FIELD);
        map.put("availBlanking", AVAIL_BLANKING_FIELD);
        map.put("colorConversion3DLUTSettings", COLOR_CONVERSION3_DLUT_SETTINGS_FIELD);
        map.put("esam", ESAM_FIELD);
        map.put("extendedDataServices", EXTENDED_DATA_SERVICES_FIELD);
        map.put("followSource", FOLLOW_SOURCE_FIELD);
        map.put("inputs", INPUTS_FIELD);
        map.put("kantarWatermark", KANTAR_WATERMARK_FIELD);
        map.put("motionImageInserter", MOTION_IMAGE_INSERTER_FIELD);
        map.put("nielsenConfiguration", NIELSEN_CONFIGURATION_FIELD);
        map.put("nielsenNonLinearWatermark", NIELSEN_NON_LINEAR_WATERMARK_FIELD);
        map.put("outputGroups", OUTPUT_GROUPS_FIELD);
        map.put("timecodeConfig", TIMECODE_CONFIG_FIELD);
        map.put("timedMetadataInsertion", TIMED_METADATA_INSERTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobSettings, T> g) {
        return obj -> g.apply((JobSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer adAvailOffset;
        private AvailBlanking availBlanking;
        private List<ColorConversion3DLUTSetting> colorConversion3DLUTSettings = DefaultSdkAutoConstructList.getInstance();
        private EsamSettings esam;
        private ExtendedDataServices extendedDataServices;
        private Integer followSource;
        private List<Input> inputs = DefaultSdkAutoConstructList.getInstance();
        private KantarWatermarkSettings kantarWatermark;
        private MotionImageInserter motionImageInserter;
        private NielsenConfiguration nielsenConfiguration;
        private NielsenNonLinearWatermarkSettings nielsenNonLinearWatermark;
        private List<OutputGroup> outputGroups = DefaultSdkAutoConstructList.getInstance();
        private TimecodeConfig timecodeConfig;
        private TimedMetadataInsertion timedMetadataInsertion;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSettings model) {
            this.adAvailOffset(model.adAvailOffset);
            this.availBlanking(model.availBlanking);
            this.colorConversion3DLUTSettings(model.colorConversion3DLUTSettings);
            this.esam(model.esam);
            this.extendedDataServices(model.extendedDataServices);
            this.followSource(model.followSource);
            this.inputs(model.inputs);
            this.kantarWatermark(model.kantarWatermark);
            this.motionImageInserter(model.motionImageInserter);
            this.nielsenConfiguration(model.nielsenConfiguration);
            this.nielsenNonLinearWatermark(model.nielsenNonLinearWatermark);
            this.outputGroups(model.outputGroups);
            this.timecodeConfig(model.timecodeConfig);
            this.timedMetadataInsertion(model.timedMetadataInsertion);
        }

        public final Integer getAdAvailOffset() {
            return this.adAvailOffset;
        }

        public final void setAdAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
        }

        @Override
        public final Builder adAvailOffset(Integer adAvailOffset) {
            this.adAvailOffset = adAvailOffset;
            return this;
        }

        public final AvailBlanking.Builder getAvailBlanking() {
            return this.availBlanking != null ? this.availBlanking.toBuilder() : null;
        }

        public final void setAvailBlanking(AvailBlanking.BuilderImpl availBlanking) {
            this.availBlanking = availBlanking != null ? availBlanking.build() : null;
        }

        @Override
        public final Builder availBlanking(AvailBlanking availBlanking) {
            this.availBlanking = availBlanking;
            return this;
        }

        public final List<ColorConversion3DLUTSetting.Builder> getColorConversion3DLUTSettings() {
            List<ColorConversion3DLUTSetting.Builder> result = ___listOfColorConversion3DLUTSettingCopier.copyToBuilder(this.colorConversion3DLUTSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColorConversion3DLUTSettings(Collection<ColorConversion3DLUTSetting.BuilderImpl> colorConversion3DLUTSettings) {
            this.colorConversion3DLUTSettings = ___listOfColorConversion3DLUTSettingCopier.copyFromBuilder(colorConversion3DLUTSettings);
        }

        @Override
        public final Builder colorConversion3DLUTSettings(Collection<ColorConversion3DLUTSetting> colorConversion3DLUTSettings) {
            this.colorConversion3DLUTSettings = ___listOfColorConversion3DLUTSettingCopier.copy(colorConversion3DLUTSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colorConversion3DLUTSettings(ColorConversion3DLUTSetting ... colorConversion3DLUTSettings) {
            this.colorConversion3DLUTSettings(Arrays.asList(colorConversion3DLUTSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colorConversion3DLUTSettings(Consumer<ColorConversion3DLUTSetting.Builder> ... colorConversion3DLUTSettings) {
            this.colorConversion3DLUTSettings(Stream.of(colorConversion3DLUTSettings).map(c -> (ColorConversion3DLUTSetting)((ColorConversion3DLUTSetting.Builder)ColorConversion3DLUTSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EsamSettings.Builder getEsam() {
            return this.esam != null ? this.esam.toBuilder() : null;
        }

        public final void setEsam(EsamSettings.BuilderImpl esam) {
            this.esam = esam != null ? esam.build() : null;
        }

        @Override
        public final Builder esam(EsamSettings esam) {
            this.esam = esam;
            return this;
        }

        public final ExtendedDataServices.Builder getExtendedDataServices() {
            return this.extendedDataServices != null ? this.extendedDataServices.toBuilder() : null;
        }

        public final void setExtendedDataServices(ExtendedDataServices.BuilderImpl extendedDataServices) {
            this.extendedDataServices = extendedDataServices != null ? extendedDataServices.build() : null;
        }

        @Override
        public final Builder extendedDataServices(ExtendedDataServices extendedDataServices) {
            this.extendedDataServices = extendedDataServices;
            return this;
        }

        public final Integer getFollowSource() {
            return this.followSource;
        }

        public final void setFollowSource(Integer followSource) {
            this.followSource = followSource;
        }

        @Override
        public final Builder followSource(Integer followSource) {
            this.followSource = followSource;
            return this;
        }

        public final List<Input.Builder> getInputs() {
            List<Input.Builder> result = ___listOfInputCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<Input.BuilderImpl> inputs) {
            this.inputs = ___listOfInputCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<Input> inputs) {
            this.inputs = ___listOfInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Input ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<Input.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (Input)((Input.Builder)Input.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final KantarWatermarkSettings.Builder getKantarWatermark() {
            return this.kantarWatermark != null ? this.kantarWatermark.toBuilder() : null;
        }

        public final void setKantarWatermark(KantarWatermarkSettings.BuilderImpl kantarWatermark) {
            this.kantarWatermark = kantarWatermark != null ? kantarWatermark.build() : null;
        }

        @Override
        public final Builder kantarWatermark(KantarWatermarkSettings kantarWatermark) {
            this.kantarWatermark = kantarWatermark;
            return this;
        }

        public final MotionImageInserter.Builder getMotionImageInserter() {
            return this.motionImageInserter != null ? this.motionImageInserter.toBuilder() : null;
        }

        public final void setMotionImageInserter(MotionImageInserter.BuilderImpl motionImageInserter) {
            this.motionImageInserter = motionImageInserter != null ? motionImageInserter.build() : null;
        }

        @Override
        public final Builder motionImageInserter(MotionImageInserter motionImageInserter) {
            this.motionImageInserter = motionImageInserter;
            return this;
        }

        public final NielsenConfiguration.Builder getNielsenConfiguration() {
            return this.nielsenConfiguration != null ? this.nielsenConfiguration.toBuilder() : null;
        }

        public final void setNielsenConfiguration(NielsenConfiguration.BuilderImpl nielsenConfiguration) {
            this.nielsenConfiguration = nielsenConfiguration != null ? nielsenConfiguration.build() : null;
        }

        @Override
        public final Builder nielsenConfiguration(NielsenConfiguration nielsenConfiguration) {
            this.nielsenConfiguration = nielsenConfiguration;
            return this;
        }

        public final NielsenNonLinearWatermarkSettings.Builder getNielsenNonLinearWatermark() {
            return this.nielsenNonLinearWatermark != null ? this.nielsenNonLinearWatermark.toBuilder() : null;
        }

        public final void setNielsenNonLinearWatermark(NielsenNonLinearWatermarkSettings.BuilderImpl nielsenNonLinearWatermark) {
            this.nielsenNonLinearWatermark = nielsenNonLinearWatermark != null ? nielsenNonLinearWatermark.build() : null;
        }

        @Override
        public final Builder nielsenNonLinearWatermark(NielsenNonLinearWatermarkSettings nielsenNonLinearWatermark) {
            this.nielsenNonLinearWatermark = nielsenNonLinearWatermark;
            return this;
        }

        public final List<OutputGroup.Builder> getOutputGroups() {
            List<OutputGroup.Builder> result = ___listOfOutputGroupCopier.copyToBuilder(this.outputGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputGroups(Collection<OutputGroup.BuilderImpl> outputGroups) {
            this.outputGroups = ___listOfOutputGroupCopier.copyFromBuilder(outputGroups);
        }

        @Override
        public final Builder outputGroups(Collection<OutputGroup> outputGroups) {
            this.outputGroups = ___listOfOutputGroupCopier.copy(outputGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(OutputGroup ... outputGroups) {
            this.outputGroups(Arrays.asList(outputGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputGroups(Consumer<OutputGroup.Builder> ... outputGroups) {
            this.outputGroups(Stream.of(outputGroups).map(c -> (OutputGroup)((OutputGroup.Builder)OutputGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TimecodeConfig.Builder getTimecodeConfig() {
            return this.timecodeConfig != null ? this.timecodeConfig.toBuilder() : null;
        }

        public final void setTimecodeConfig(TimecodeConfig.BuilderImpl timecodeConfig) {
            this.timecodeConfig = timecodeConfig != null ? timecodeConfig.build() : null;
        }

        @Override
        public final Builder timecodeConfig(TimecodeConfig timecodeConfig) {
            this.timecodeConfig = timecodeConfig;
            return this;
        }

        public final TimedMetadataInsertion.Builder getTimedMetadataInsertion() {
            return this.timedMetadataInsertion != null ? this.timedMetadataInsertion.toBuilder() : null;
        }

        public final void setTimedMetadataInsertion(TimedMetadataInsertion.BuilderImpl timedMetadataInsertion) {
            this.timedMetadataInsertion = timedMetadataInsertion != null ? timedMetadataInsertion.build() : null;
        }

        @Override
        public final Builder timedMetadataInsertion(TimedMetadataInsertion timedMetadataInsertion) {
            this.timedMetadataInsertion = timedMetadataInsertion;
            return this;
        }

        public JobSettings build() {
            return new JobSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobSettings> {
        public Builder adAvailOffset(Integer var1);

        public Builder availBlanking(AvailBlanking var1);

        default public Builder availBlanking(Consumer<AvailBlanking.Builder> availBlanking) {
            return this.availBlanking((AvailBlanking)((AvailBlanking.Builder)AvailBlanking.builder().applyMutation(availBlanking)).build());
        }

        public Builder colorConversion3DLUTSettings(Collection<ColorConversion3DLUTSetting> var1);

        public Builder colorConversion3DLUTSettings(ColorConversion3DLUTSetting ... var1);

        public Builder colorConversion3DLUTSettings(Consumer<ColorConversion3DLUTSetting.Builder> ... var1);

        public Builder esam(EsamSettings var1);

        default public Builder esam(Consumer<EsamSettings.Builder> esam) {
            return this.esam((EsamSettings)((EsamSettings.Builder)EsamSettings.builder().applyMutation(esam)).build());
        }

        public Builder extendedDataServices(ExtendedDataServices var1);

        default public Builder extendedDataServices(Consumer<ExtendedDataServices.Builder> extendedDataServices) {
            return this.extendedDataServices((ExtendedDataServices)((ExtendedDataServices.Builder)ExtendedDataServices.builder().applyMutation(extendedDataServices)).build());
        }

        public Builder followSource(Integer var1);

        public Builder inputs(Collection<Input> var1);

        public Builder inputs(Input ... var1);

        public Builder inputs(Consumer<Input.Builder> ... var1);

        public Builder kantarWatermark(KantarWatermarkSettings var1);

        default public Builder kantarWatermark(Consumer<KantarWatermarkSettings.Builder> kantarWatermark) {
            return this.kantarWatermark((KantarWatermarkSettings)((KantarWatermarkSettings.Builder)KantarWatermarkSettings.builder().applyMutation(kantarWatermark)).build());
        }

        public Builder motionImageInserter(MotionImageInserter var1);

        default public Builder motionImageInserter(Consumer<MotionImageInserter.Builder> motionImageInserter) {
            return this.motionImageInserter((MotionImageInserter)((MotionImageInserter.Builder)MotionImageInserter.builder().applyMutation(motionImageInserter)).build());
        }

        public Builder nielsenConfiguration(NielsenConfiguration var1);

        default public Builder nielsenConfiguration(Consumer<NielsenConfiguration.Builder> nielsenConfiguration) {
            return this.nielsenConfiguration((NielsenConfiguration)((NielsenConfiguration.Builder)NielsenConfiguration.builder().applyMutation(nielsenConfiguration)).build());
        }

        public Builder nielsenNonLinearWatermark(NielsenNonLinearWatermarkSettings var1);

        default public Builder nielsenNonLinearWatermark(Consumer<NielsenNonLinearWatermarkSettings.Builder> nielsenNonLinearWatermark) {
            return this.nielsenNonLinearWatermark((NielsenNonLinearWatermarkSettings)((NielsenNonLinearWatermarkSettings.Builder)NielsenNonLinearWatermarkSettings.builder().applyMutation(nielsenNonLinearWatermark)).build());
        }

        public Builder outputGroups(Collection<OutputGroup> var1);

        public Builder outputGroups(OutputGroup ... var1);

        public Builder outputGroups(Consumer<OutputGroup.Builder> ... var1);

        public Builder timecodeConfig(TimecodeConfig var1);

        default public Builder timecodeConfig(Consumer<TimecodeConfig.Builder> timecodeConfig) {
            return this.timecodeConfig((TimecodeConfig)((TimecodeConfig.Builder)TimecodeConfig.builder().applyMutation(timecodeConfig)).build());
        }

        public Builder timedMetadataInsertion(TimedMetadataInsertion var1);

        default public Builder timedMetadataInsertion(Consumer<TimedMetadataInsertion.Builder> timedMetadataInsertion) {
            return this.timedMetadataInsertion((TimedMetadataInsertion)((TimedMetadataInsertion.Builder)TimedMetadataInsertion.builder().applyMutation(timedMetadataInsertion)).build());
        }
    }
}

