/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerType {
    F4_V("F4V"),
    GIF("GIF"),
    ISMV("ISMV"),
    M2_TS("M2TS"),
    M3_U8("M3U8"),
    CMFC("CMFC"),
    MOV("MOV"),
    MP4("MP4"),
    MPD("MPD"),
    MXF("MXF"),
    OGG("OGG"),
    WEBM("WEBM"),
    RAW("RAW"),
    Y4_M("Y4M"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerType> VALUE_MAP;
    private final String value;

    private ContainerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerType> knownValues() {
        EnumSet<ContainerType> knownValues = EnumSet.allOf(ContainerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerType.class, ContainerType::toString);
    }
}

