/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.CaptionDestinationSettings;
import software.amazon.awssdk.services.mediaconvert.model.LanguageCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaptionDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaptionDescription> {
    private static final SdkField<String> CAPTION_SELECTOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaptionSelectorName").getter(CaptionDescription.getter(CaptionDescription::captionSelectorName)).setter(CaptionDescription.setter(Builder::captionSelectorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionSelectorName").build()}).build();
    private static final SdkField<String> CUSTOM_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomLanguageCode").getter(CaptionDescription.getter(CaptionDescription::customLanguageCode)).setter(CaptionDescription.setter(Builder::customLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customLanguageCode").build()}).build();
    private static final SdkField<CaptionDestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DestinationSettings").getter(CaptionDescription.getter(CaptionDescription::destinationSettings)).setter(CaptionDescription.setter(Builder::destinationSettings)).constructor(CaptionDestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build()}).build();
    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageCode").getter(CaptionDescription.getter(CaptionDescription::languageCodeAsString)).setter(CaptionDescription.setter(Builder::languageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageCode").build()}).build();
    private static final SdkField<String> LANGUAGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LanguageDescription").getter(CaptionDescription.getter(CaptionDescription::languageDescription)).setter(CaptionDescription.setter(Builder::languageDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("languageDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPTION_SELECTOR_NAME_FIELD, CUSTOM_LANGUAGE_CODE_FIELD, DESTINATION_SETTINGS_FIELD, LANGUAGE_CODE_FIELD, LANGUAGE_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CaptionDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String captionSelectorName;
    private final String customLanguageCode;
    private final CaptionDestinationSettings destinationSettings;
    private final String languageCode;
    private final String languageDescription;

    private CaptionDescription(BuilderImpl builder) {
        this.captionSelectorName = builder.captionSelectorName;
        this.customLanguageCode = builder.customLanguageCode;
        this.destinationSettings = builder.destinationSettings;
        this.languageCode = builder.languageCode;
        this.languageDescription = builder.languageDescription;
    }

    public final String captionSelectorName() {
        return this.captionSelectorName;
    }

    public final String customLanguageCode() {
        return this.customLanguageCode;
    }

    public final CaptionDestinationSettings destinationSettings() {
        return this.destinationSettings;
    }

    public final LanguageCode languageCode() {
        return LanguageCode.fromValue(this.languageCode);
    }

    public final String languageCodeAsString() {
        return this.languageCode;
    }

    public final String languageDescription() {
        return this.languageDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.captionSelectorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.languageDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionDescription)) {
            return false;
        }
        CaptionDescription other = (CaptionDescription)obj;
        return Objects.equals(this.captionSelectorName(), other.captionSelectorName()) && Objects.equals(this.customLanguageCode(), other.customLanguageCode()) && Objects.equals(this.destinationSettings(), other.destinationSettings()) && Objects.equals(this.languageCodeAsString(), other.languageCodeAsString()) && Objects.equals(this.languageDescription(), other.languageDescription());
    }

    public final String toString() {
        return ToString.builder((String)"CaptionDescription").add("CaptionSelectorName", (Object)this.captionSelectorName()).add("CustomLanguageCode", (Object)this.customLanguageCode()).add("DestinationSettings", (Object)this.destinationSettings()).add("LanguageCode", (Object)this.languageCodeAsString()).add("LanguageDescription", (Object)this.languageDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CaptionSelectorName": {
                return Optional.ofNullable(clazz.cast(this.captionSelectorName()));
            }
            case "CustomLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.customLanguageCode()));
            }
            case "DestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.destinationSettings()));
            }
            case "LanguageCode": {
                return Optional.ofNullable(clazz.cast(this.languageCodeAsString()));
            }
            case "LanguageDescription": {
                return Optional.ofNullable(clazz.cast(this.languageDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("captionSelectorName", CAPTION_SELECTOR_NAME_FIELD);
        map.put("customLanguageCode", CUSTOM_LANGUAGE_CODE_FIELD);
        map.put("destinationSettings", DESTINATION_SETTINGS_FIELD);
        map.put("languageCode", LANGUAGE_CODE_FIELD);
        map.put("languageDescription", LANGUAGE_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaptionDescription, T> g) {
        return obj -> g.apply((CaptionDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String captionSelectorName;
        private String customLanguageCode;
        private CaptionDestinationSettings destinationSettings;
        private String languageCode;
        private String languageDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionDescription model) {
            this.captionSelectorName(model.captionSelectorName);
            this.customLanguageCode(model.customLanguageCode);
            this.destinationSettings(model.destinationSettings);
            this.languageCode(model.languageCode);
            this.languageDescription(model.languageDescription);
        }

        public final String getCaptionSelectorName() {
            return this.captionSelectorName;
        }

        public final void setCaptionSelectorName(String captionSelectorName) {
            this.captionSelectorName = captionSelectorName;
        }

        @Override
        public final Builder captionSelectorName(String captionSelectorName) {
            this.captionSelectorName = captionSelectorName;
            return this;
        }

        public final String getCustomLanguageCode() {
            return this.customLanguageCode;
        }

        public final void setCustomLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
        }

        @Override
        public final Builder customLanguageCode(String customLanguageCode) {
            this.customLanguageCode = customLanguageCode;
            return this;
        }

        public final CaptionDestinationSettings.Builder getDestinationSettings() {
            return this.destinationSettings != null ? this.destinationSettings.toBuilder() : null;
        }

        public final void setDestinationSettings(CaptionDestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        @Override
        public final Builder destinationSettings(CaptionDestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public final Builder languageCode(LanguageCode languageCode) {
            this.languageCode(languageCode == null ? null : languageCode.toString());
            return this;
        }

        public final String getLanguageDescription() {
            return this.languageDescription;
        }

        public final void setLanguageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
        }

        @Override
        public final Builder languageDescription(String languageDescription) {
            this.languageDescription = languageDescription;
            return this;
        }

        public CaptionDescription build() {
            return new CaptionDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaptionDescription> {
        public Builder captionSelectorName(String var1);

        public Builder customLanguageCode(String var1);

        public Builder destinationSettings(CaptionDestinationSettings var1);

        default public Builder destinationSettings(Consumer<CaptionDestinationSettings.Builder> destinationSettings) {
            return this.destinationSettings((CaptionDestinationSettings)((CaptionDestinationSettings.Builder)CaptionDestinationSettings.builder().applyMutation(destinationSettings)).build());
        }

        public Builder languageCode(String var1);

        public Builder languageCode(LanguageCode var1);

        public Builder languageDescription(String var1);
    }
}

