/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectClient;
import software.amazon.awssdk.services.mediaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedRouterOutput;

public class ListRouterOutputsIterable
implements SdkIterable<ListRouterOutputsResponse> {
    private final MediaConnectClient client;
    private final ListRouterOutputsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRouterOutputsIterable(MediaConnectClient client, ListRouterOutputsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRouterOutputsResponseFetcher();
    }

    public Iterator<ListRouterOutputsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListedRouterOutput> routerOutputs() {
        Function<ListRouterOutputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.routerOutputs() != null) {
                return response.routerOutputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRouterOutputsResponseFetcher
    implements SyncPageFetcher<ListRouterOutputsResponse> {
        private ListRouterOutputsResponseFetcher() {
        }

        public boolean hasNextPage(ListRouterOutputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRouterOutputsResponse nextPage(ListRouterOutputsResponse previousPage) {
            if (previousPage == null) {
                return ListRouterOutputsIterable.this.client.listRouterOutputs(ListRouterOutputsIterable.this.firstRequest);
            }
            return ListRouterOutputsIterable.this.client.listRouterOutputs((ListRouterOutputsRequest)((Object)ListRouterOutputsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

