/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.SrtDecryptionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SrtCallerRouterInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SrtCallerRouterInputConfiguration> {
    private static final SdkField<String> SOURCE_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceAddress").getter(SrtCallerRouterInputConfiguration.getter(SrtCallerRouterInputConfiguration::sourceAddress)).setter(SrtCallerRouterInputConfiguration.setter(Builder::sourceAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAddress").build()}).build();
    private static final SdkField<Integer> SOURCE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SourcePort").getter(SrtCallerRouterInputConfiguration.getter(SrtCallerRouterInputConfiguration::sourcePort)).setter(SrtCallerRouterInputConfiguration.setter(Builder::sourcePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePort").build()}).build();
    private static final SdkField<Long> MINIMUM_LATENCY_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinimumLatencyMilliseconds").getter(SrtCallerRouterInputConfiguration.getter(SrtCallerRouterInputConfiguration::minimumLatencyMilliseconds)).setter(SrtCallerRouterInputConfiguration.setter(Builder::minimumLatencyMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumLatencyMilliseconds").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamId").getter(SrtCallerRouterInputConfiguration.getter(SrtCallerRouterInputConfiguration::streamId)).setter(SrtCallerRouterInputConfiguration.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final SdkField<SrtDecryptionConfiguration> DECRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DecryptionConfiguration").getter(SrtCallerRouterInputConfiguration.getter(SrtCallerRouterInputConfiguration::decryptionConfiguration)).setter(SrtCallerRouterInputConfiguration.setter(Builder::decryptionConfiguration)).constructor(SrtDecryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ADDRESS_FIELD, SOURCE_PORT_FIELD, MINIMUM_LATENCY_MILLISECONDS_FIELD, STREAM_ID_FIELD, DECRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SrtCallerRouterInputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceAddress;
    private final Integer sourcePort;
    private final Long minimumLatencyMilliseconds;
    private final String streamId;
    private final SrtDecryptionConfiguration decryptionConfiguration;

    private SrtCallerRouterInputConfiguration(BuilderImpl builder) {
        this.sourceAddress = builder.sourceAddress;
        this.sourcePort = builder.sourcePort;
        this.minimumLatencyMilliseconds = builder.minimumLatencyMilliseconds;
        this.streamId = builder.streamId;
        this.decryptionConfiguration = builder.decryptionConfiguration;
    }

    public final String sourceAddress() {
        return this.sourceAddress;
    }

    public final Integer sourcePort() {
        return this.sourcePort;
    }

    public final Long minimumLatencyMilliseconds() {
        return this.minimumLatencyMilliseconds;
    }

    public final String streamId() {
        return this.streamId;
    }

    public final SrtDecryptionConfiguration decryptionConfiguration() {
        return this.decryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumLatencyMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.decryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SrtCallerRouterInputConfiguration)) {
            return false;
        }
        SrtCallerRouterInputConfiguration other = (SrtCallerRouterInputConfiguration)obj;
        return Objects.equals(this.sourceAddress(), other.sourceAddress()) && Objects.equals(this.sourcePort(), other.sourcePort()) && Objects.equals(this.minimumLatencyMilliseconds(), other.minimumLatencyMilliseconds()) && Objects.equals(this.streamId(), other.streamId()) && Objects.equals(this.decryptionConfiguration(), other.decryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SrtCallerRouterInputConfiguration").add("SourceAddress", (Object)this.sourceAddress()).add("SourcePort", (Object)this.sourcePort()).add("MinimumLatencyMilliseconds", (Object)this.minimumLatencyMilliseconds()).add("StreamId", (Object)this.streamId()).add("DecryptionConfiguration", (Object)this.decryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceAddress": {
                return Optional.ofNullable(clazz.cast(this.sourceAddress()));
            }
            case "SourcePort": {
                return Optional.ofNullable(clazz.cast(this.sourcePort()));
            }
            case "MinimumLatencyMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.minimumLatencyMilliseconds()));
            }
            case "StreamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
            case "DecryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.decryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceAddress", SOURCE_ADDRESS_FIELD);
        map.put("sourcePort", SOURCE_PORT_FIELD);
        map.put("minimumLatencyMilliseconds", MINIMUM_LATENCY_MILLISECONDS_FIELD);
        map.put("streamId", STREAM_ID_FIELD);
        map.put("decryptionConfiguration", DECRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SrtCallerRouterInputConfiguration, T> g) {
        return obj -> g.apply((SrtCallerRouterInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceAddress;
        private Integer sourcePort;
        private Long minimumLatencyMilliseconds;
        private String streamId;
        private SrtDecryptionConfiguration decryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SrtCallerRouterInputConfiguration model) {
            this.sourceAddress(model.sourceAddress);
            this.sourcePort(model.sourcePort);
            this.minimumLatencyMilliseconds(model.minimumLatencyMilliseconds);
            this.streamId(model.streamId);
            this.decryptionConfiguration(model.decryptionConfiguration);
        }

        public final String getSourceAddress() {
            return this.sourceAddress;
        }

        public final void setSourceAddress(String sourceAddress) {
            this.sourceAddress = sourceAddress;
        }

        @Override
        public final Builder sourceAddress(String sourceAddress) {
            this.sourceAddress = sourceAddress;
            return this;
        }

        public final Integer getSourcePort() {
            return this.sourcePort;
        }

        public final void setSourcePort(Integer sourcePort) {
            this.sourcePort = sourcePort;
        }

        @Override
        public final Builder sourcePort(Integer sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        public final Long getMinimumLatencyMilliseconds() {
            return this.minimumLatencyMilliseconds;
        }

        public final void setMinimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
        }

        @Override
        public final Builder minimumLatencyMilliseconds(Long minimumLatencyMilliseconds) {
            this.minimumLatencyMilliseconds = minimumLatencyMilliseconds;
            return this;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final SrtDecryptionConfiguration.Builder getDecryptionConfiguration() {
            return this.decryptionConfiguration != null ? this.decryptionConfiguration.toBuilder() : null;
        }

        public final void setDecryptionConfiguration(SrtDecryptionConfiguration.BuilderImpl decryptionConfiguration) {
            this.decryptionConfiguration = decryptionConfiguration != null ? decryptionConfiguration.build() : null;
        }

        @Override
        public final Builder decryptionConfiguration(SrtDecryptionConfiguration decryptionConfiguration) {
            this.decryptionConfiguration = decryptionConfiguration;
            return this;
        }

        public SrtCallerRouterInputConfiguration build() {
            return new SrtCallerRouterInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SrtCallerRouterInputConfiguration> {
        public Builder sourceAddress(String var1);

        public Builder sourcePort(Integer var1);

        public Builder minimumLatencyMilliseconds(Long var1);

        public Builder streamId(String var1);

        public Builder decryptionConfiguration(SrtDecryptionConfiguration var1);

        default public Builder decryptionConfiguration(Consumer<SrtDecryptionConfiguration.Builder> decryptionConfiguration) {
            return this.decryptionConfiguration((SrtDecryptionConfiguration)((SrtDecryptionConfiguration.Builder)SrtDecryptionConfiguration.builder().applyMutation(decryptionConfiguration)).build());
        }
    }
}

