/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceState;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceType;
import software.amazon.awssdk.services.mediaconnect.model.___mapOfStringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterNetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterNetworkInterface> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RouterNetworkInterface.getter(RouterNetworkInterface::name)).setter(RouterNetworkInterface.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(RouterNetworkInterface.getter(RouterNetworkInterface::arn)).setter(RouterNetworkInterface.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(RouterNetworkInterface.getter(RouterNetworkInterface::id)).setter(RouterNetworkInterface.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(RouterNetworkInterface.getter(RouterNetworkInterface::stateAsString)).setter(RouterNetworkInterface.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceType").getter(RouterNetworkInterface.getter(RouterNetworkInterface::networkInterfaceTypeAsString)).setter(RouterNetworkInterface.setter(Builder::networkInterfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceType").build()}).build();
    private static final SdkField<RouterNetworkInterfaceConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(RouterNetworkInterface.getter(RouterNetworkInterface::configuration)).setter(RouterNetworkInterface.setter(Builder::configuration)).constructor(RouterNetworkInterfaceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<Integer> ASSOCIATED_OUTPUT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AssociatedOutputCount").getter(RouterNetworkInterface.getter(RouterNetworkInterface::associatedOutputCount)).setter(RouterNetworkInterface.setter(Builder::associatedOutputCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedOutputCount").build()}).build();
    private static final SdkField<Integer> ASSOCIATED_INPUT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AssociatedInputCount").getter(RouterNetworkInterface.getter(RouterNetworkInterface::associatedInputCount)).setter(RouterNetworkInterface.setter(Builder::associatedInputCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedInputCount").build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(RouterNetworkInterface.getter(RouterNetworkInterface::regionName)).setter(RouterNetworkInterface.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(RouterNetworkInterface.getter(RouterNetworkInterface::createdAt)).setter(RouterNetworkInterface.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(RouterNetworkInterface.getter(RouterNetworkInterface::updatedAt)).setter(RouterNetworkInterface.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(RouterNetworkInterface.getter(RouterNetworkInterface::tags)).setter(RouterNetworkInterface.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, ID_FIELD, STATE_FIELD, NETWORK_INTERFACE_TYPE_FIELD, CONFIGURATION_FIELD, ASSOCIATED_OUTPUT_COUNT_FIELD, ASSOCIATED_INPUT_COUNT_FIELD, REGION_NAME_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterNetworkInterface.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String id;
    private final String state;
    private final String networkInterfaceType;
    private final RouterNetworkInterfaceConfiguration configuration;
    private final Integer associatedOutputCount;
    private final Integer associatedInputCount;
    private final String regionName;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final Map<String, String> tags;

    private RouterNetworkInterface(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.id = builder.id;
        this.state = builder.state;
        this.networkInterfaceType = builder.networkInterfaceType;
        this.configuration = builder.configuration;
        this.associatedOutputCount = builder.associatedOutputCount;
        this.associatedInputCount = builder.associatedInputCount;
        this.regionName = builder.regionName;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final RouterNetworkInterfaceState state() {
        return RouterNetworkInterfaceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final RouterNetworkInterfaceType networkInterfaceType() {
        return RouterNetworkInterfaceType.fromValue(this.networkInterfaceType);
    }

    public final String networkInterfaceTypeAsString() {
        return this.networkInterfaceType;
    }

    public final RouterNetworkInterfaceConfiguration configuration() {
        return this.configuration;
    }

    public final Integer associatedOutputCount() {
        return this.associatedOutputCount;
    }

    public final Integer associatedInputCount() {
        return this.associatedInputCount;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedOutputCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedInputCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterNetworkInterface)) {
            return false;
        }
        RouterNetworkInterface other = (RouterNetworkInterface)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.networkInterfaceTypeAsString(), other.networkInterfaceTypeAsString()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.associatedOutputCount(), other.associatedOutputCount()) && Objects.equals(this.associatedInputCount(), other.associatedInputCount()) && Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RouterNetworkInterface").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("State", (Object)this.stateAsString()).add("NetworkInterfaceType", (Object)this.networkInterfaceTypeAsString()).add("Configuration", (Object)this.configuration()).add("AssociatedOutputCount", (Object)this.associatedOutputCount()).add("AssociatedInputCount", (Object)this.associatedInputCount()).add("RegionName", (Object)this.regionName()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "NetworkInterfaceType": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceTypeAsString()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "AssociatedOutputCount": {
                return Optional.ofNullable(clazz.cast(this.associatedOutputCount()));
            }
            case "AssociatedInputCount": {
                return Optional.ofNullable(clazz.cast(this.associatedInputCount()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("state", STATE_FIELD);
        map.put("networkInterfaceType", NETWORK_INTERFACE_TYPE_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("associatedOutputCount", ASSOCIATED_OUTPUT_COUNT_FIELD);
        map.put("associatedInputCount", ASSOCIATED_INPUT_COUNT_FIELD);
        map.put("regionName", REGION_NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterNetworkInterface, T> g) {
        return obj -> g.apply((RouterNetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String id;
        private String state;
        private String networkInterfaceType;
        private RouterNetworkInterfaceConfiguration configuration;
        private Integer associatedOutputCount;
        private Integer associatedInputCount;
        private String regionName;
        private Instant createdAt;
        private Instant updatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouterNetworkInterface model) {
            this.name(model.name);
            this.arn(model.arn);
            this.id(model.id);
            this.state(model.state);
            this.networkInterfaceType(model.networkInterfaceType);
            this.configuration(model.configuration);
            this.associatedOutputCount(model.associatedOutputCount);
            this.associatedInputCount(model.associatedInputCount);
            this.regionName(model.regionName);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouterNetworkInterfaceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getNetworkInterfaceType() {
            return this.networkInterfaceType;
        }

        public final void setNetworkInterfaceType(String networkInterfaceType) {
            this.networkInterfaceType = networkInterfaceType;
        }

        @Override
        public final Builder networkInterfaceType(String networkInterfaceType) {
            this.networkInterfaceType = networkInterfaceType;
            return this;
        }

        @Override
        public final Builder networkInterfaceType(RouterNetworkInterfaceType networkInterfaceType) {
            this.networkInterfaceType(networkInterfaceType == null ? null : networkInterfaceType.toString());
            return this;
        }

        public final RouterNetworkInterfaceConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(RouterNetworkInterfaceConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(RouterNetworkInterfaceConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final Integer getAssociatedOutputCount() {
            return this.associatedOutputCount;
        }

        public final void setAssociatedOutputCount(Integer associatedOutputCount) {
            this.associatedOutputCount = associatedOutputCount;
        }

        @Override
        public final Builder associatedOutputCount(Integer associatedOutputCount) {
            this.associatedOutputCount = associatedOutputCount;
            return this;
        }

        public final Integer getAssociatedInputCount() {
            return this.associatedInputCount;
        }

        public final void setAssociatedInputCount(Integer associatedInputCount) {
            this.associatedInputCount = associatedInputCount;
        }

        @Override
        public final Builder associatedInputCount(Integer associatedInputCount) {
            this.associatedInputCount = associatedInputCount;
            return this;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOfStringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOfStringCopier.copy(tags);
            return this;
        }

        public RouterNetworkInterface build() {
            return new RouterNetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterNetworkInterface> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder state(String var1);

        public Builder state(RouterNetworkInterfaceState var1);

        public Builder networkInterfaceType(String var1);

        public Builder networkInterfaceType(RouterNetworkInterfaceType var1);

        public Builder configuration(RouterNetworkInterfaceConfiguration var1);

        default public Builder configuration(Consumer<RouterNetworkInterfaceConfiguration.Builder> configuration) {
            return this.configuration((RouterNetworkInterfaceConfiguration)((RouterNetworkInterfaceConfiguration.Builder)RouterNetworkInterfaceConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder associatedOutputCount(Integer var1);

        public Builder associatedInputCount(Integer var1);

        public Builder regionName(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

