/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputMessage;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputMessagesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterInputThumbnailDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterInputThumbnailDetails> {
    private static final SdkField<List<RouterInputMessage>> THUMBNAIL_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThumbnailMessages").getter(RouterInputThumbnailDetails.getter(RouterInputThumbnailDetails::thumbnailMessages)).setter(RouterInputThumbnailDetails.setter(Builder::thumbnailMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RouterInputMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SdkBytes> THUMBNAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("Thumbnail").getter(RouterInputThumbnailDetails.getter(RouterInputThumbnailDetails::thumbnail)).setter(RouterInputThumbnailDetails.setter(Builder::thumbnail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnail").build()}).build();
    private static final SdkField<String> TIMECODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timecode").getter(RouterInputThumbnailDetails.getter(RouterInputThumbnailDetails::timecode)).setter(RouterInputThumbnailDetails.setter(Builder::timecode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecode").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(RouterInputThumbnailDetails.getter(RouterInputThumbnailDetails::timestamp)).setter(RouterInputThumbnailDetails.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THUMBNAIL_MESSAGES_FIELD, THUMBNAIL_FIELD, TIMECODE_FIELD, TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterInputThumbnailDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RouterInputMessage> thumbnailMessages;
    private final SdkBytes thumbnail;
    private final String timecode;
    private final Instant timestamp;

    private RouterInputThumbnailDetails(BuilderImpl builder) {
        this.thumbnailMessages = builder.thumbnailMessages;
        this.thumbnail = builder.thumbnail;
        this.timecode = builder.timecode;
        this.timestamp = builder.timestamp;
    }

    public final boolean hasThumbnailMessages() {
        return this.thumbnailMessages != null && !(this.thumbnailMessages instanceof SdkAutoConstructList);
    }

    public final List<RouterInputMessage> thumbnailMessages() {
        return this.thumbnailMessages;
    }

    public final SdkBytes thumbnail() {
        return this.thumbnail;
    }

    public final String timecode() {
        return this.timecode;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThumbnailMessages() ? this.thumbnailMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnail());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecode());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterInputThumbnailDetails)) {
            return false;
        }
        RouterInputThumbnailDetails other = (RouterInputThumbnailDetails)obj;
        return this.hasThumbnailMessages() == other.hasThumbnailMessages() && Objects.equals(this.thumbnailMessages(), other.thumbnailMessages()) && Objects.equals(this.thumbnail(), other.thumbnail()) && Objects.equals(this.timecode(), other.timecode()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"RouterInputThumbnailDetails").add("ThumbnailMessages", this.hasThumbnailMessages() ? this.thumbnailMessages() : null).add("Thumbnail", (Object)this.thumbnail()).add("Timecode", (Object)this.timecode()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThumbnailMessages": {
                return Optional.ofNullable(clazz.cast(this.thumbnailMessages()));
            }
            case "Thumbnail": {
                return Optional.ofNullable(clazz.cast(this.thumbnail()));
            }
            case "Timecode": {
                return Optional.ofNullable(clazz.cast(this.timecode()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("thumbnailMessages", THUMBNAIL_MESSAGES_FIELD);
        map.put("thumbnail", THUMBNAIL_FIELD);
        map.put("timecode", TIMECODE_FIELD);
        map.put("timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterInputThumbnailDetails, T> g) {
        return obj -> g.apply((RouterInputThumbnailDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RouterInputMessage> thumbnailMessages = DefaultSdkAutoConstructList.getInstance();
        private SdkBytes thumbnail;
        private String timecode;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RouterInputThumbnailDetails model) {
            this.thumbnailMessages(model.thumbnailMessages);
            this.thumbnail(model.thumbnail);
            this.timecode(model.timecode);
            this.timestamp(model.timestamp);
        }

        public final List<RouterInputMessage.Builder> getThumbnailMessages() {
            List<RouterInputMessage.Builder> result = RouterInputMessagesCopier.copyToBuilder(this.thumbnailMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThumbnailMessages(Collection<RouterInputMessage.BuilderImpl> thumbnailMessages) {
            this.thumbnailMessages = RouterInputMessagesCopier.copyFromBuilder(thumbnailMessages);
        }

        @Override
        public final Builder thumbnailMessages(Collection<RouterInputMessage> thumbnailMessages) {
            this.thumbnailMessages = RouterInputMessagesCopier.copy(thumbnailMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnailMessages(RouterInputMessage ... thumbnailMessages) {
            this.thumbnailMessages(Arrays.asList(thumbnailMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbnailMessages(Consumer<RouterInputMessage.Builder> ... thumbnailMessages) {
            this.thumbnailMessages(Stream.of(thumbnailMessages).map(c -> (RouterInputMessage)((RouterInputMessage.Builder)RouterInputMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ByteBuffer getThumbnail() {
            return this.thumbnail == null ? null : this.thumbnail.asByteBuffer();
        }

        public final void setThumbnail(ByteBuffer thumbnail) {
            this.thumbnail(thumbnail == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)thumbnail));
        }

        @Override
        public final Builder thumbnail(SdkBytes thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public final String getTimecode() {
            return this.timecode;
        }

        public final void setTimecode(String timecode) {
            this.timecode = timecode;
        }

        @Override
        public final Builder timecode(String timecode) {
            this.timecode = timecode;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public RouterInputThumbnailDetails build() {
            return new RouterInputThumbnailDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterInputThumbnailDetails> {
        public Builder thumbnailMessages(Collection<RouterInputMessage> var1);

        public Builder thumbnailMessages(RouterInputMessage ... var1);

        public Builder thumbnailMessages(Consumer<RouterInputMessage.Builder> ... var1);

        public Builder thumbnail(SdkBytes var1);

        public Builder timecode(String var1);

        public Builder timestamp(Instant var1);
    }
}

