/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceState;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListedRouterNetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListedRouterNetworkInterface> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ListedRouterNetworkInterface.getter(ListedRouterNetworkInterface::name)).setter(ListedRouterNetworkInterface.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListedRouterNetworkInterface.getter(ListedRouterNetworkInterface::arn)).setter(ListedRouterNetworkInterface.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(ListedRouterNetworkInterface.getter(ListedRouterNetworkInterface::id)).setter(ListedRouterNetworkInterface.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceType").getter(ListedRouterNetworkInterface.getter(ListedRouterNetworkInterface::networkInterfaceTypeAsString)).setter(ListedRouterNetworkInterface.setter(Builder::networkInterfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceType").build()}).build();
    private static final SdkField<Integer> ASSOCIATED_OUTPUT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AssociatedOutputCount").getter(ListedRouterNetworkInterface.getter(ListedRouterNetworkInterface::associatedOutputCount)).setter(ListedRouterNetworkInterface.setter(Builder::associatedOutputCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedOutputCount").build()}).build();
    private static final SdkField<Integer> ASSOCIATED_INPUT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AssociatedInputCount").getter(ListedRouterNetworkInterface.getter(ListedRouterNetworkInterface::associatedInputCount)).setter(ListedRouterNetworkInterface.setter(Builder::associatedInputCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedInputCount").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ListedRouterNetworkInterface.getter(ListedRouterNetworkInterface::stateAsString)).setter(ListedRouterNetworkInterface.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> REGION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegionName").getter(ListedRouterNetworkInterface.getter(ListedRouterNetworkInterface::regionName)).setter(ListedRouterNetworkInterface.setter(Builder::regionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ListedRouterNetworkInterface.getter(ListedRouterNetworkInterface::createdAt)).setter(ListedRouterNetworkInterface.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ListedRouterNetworkInterface.getter(ListedRouterNetworkInterface::updatedAt)).setter(ListedRouterNetworkInterface.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, ID_FIELD, NETWORK_INTERFACE_TYPE_FIELD, ASSOCIATED_OUTPUT_COUNT_FIELD, ASSOCIATED_INPUT_COUNT_FIELD, STATE_FIELD, REGION_NAME_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListedRouterNetworkInterface.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final String id;
    private final String networkInterfaceType;
    private final Integer associatedOutputCount;
    private final Integer associatedInputCount;
    private final String state;
    private final String regionName;
    private final Instant createdAt;
    private final Instant updatedAt;

    private ListedRouterNetworkInterface(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.id = builder.id;
        this.networkInterfaceType = builder.networkInterfaceType;
        this.associatedOutputCount = builder.associatedOutputCount;
        this.associatedInputCount = builder.associatedInputCount;
        this.state = builder.state;
        this.regionName = builder.regionName;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final RouterNetworkInterfaceType networkInterfaceType() {
        return RouterNetworkInterfaceType.fromValue(this.networkInterfaceType);
    }

    public final String networkInterfaceTypeAsString() {
        return this.networkInterfaceType;
    }

    public final Integer associatedOutputCount() {
        return this.associatedOutputCount;
    }

    public final Integer associatedInputCount() {
        return this.associatedInputCount;
    }

    public final RouterNetworkInterfaceState state() {
        return RouterNetworkInterfaceState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String regionName() {
        return this.regionName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedOutputCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.associatedInputCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedRouterNetworkInterface)) {
            return false;
        }
        ListedRouterNetworkInterface other = (ListedRouterNetworkInterface)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.networkInterfaceTypeAsString(), other.networkInterfaceTypeAsString()) && Objects.equals(this.associatedOutputCount(), other.associatedOutputCount()) && Objects.equals(this.associatedInputCount(), other.associatedInputCount()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.regionName(), other.regionName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ListedRouterNetworkInterface").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("NetworkInterfaceType", (Object)this.networkInterfaceTypeAsString()).add("AssociatedOutputCount", (Object)this.associatedOutputCount()).add("AssociatedInputCount", (Object)this.associatedInputCount()).add("State", (Object)this.stateAsString()).add("RegionName", (Object)this.regionName()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "NetworkInterfaceType": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceTypeAsString()));
            }
            case "AssociatedOutputCount": {
                return Optional.ofNullable(clazz.cast(this.associatedOutputCount()));
            }
            case "AssociatedInputCount": {
                return Optional.ofNullable(clazz.cast(this.associatedInputCount()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "RegionName": {
                return Optional.ofNullable(clazz.cast(this.regionName()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("networkInterfaceType", NETWORK_INTERFACE_TYPE_FIELD);
        map.put("associatedOutputCount", ASSOCIATED_OUTPUT_COUNT_FIELD);
        map.put("associatedInputCount", ASSOCIATED_INPUT_COUNT_FIELD);
        map.put("state", STATE_FIELD);
        map.put("regionName", REGION_NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedRouterNetworkInterface, T> g) {
        return obj -> g.apply((ListedRouterNetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String id;
        private String networkInterfaceType;
        private Integer associatedOutputCount;
        private Integer associatedInputCount;
        private String state;
        private String regionName;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedRouterNetworkInterface model) {
            this.name(model.name);
            this.arn(model.arn);
            this.id(model.id);
            this.networkInterfaceType(model.networkInterfaceType);
            this.associatedOutputCount(model.associatedOutputCount);
            this.associatedInputCount(model.associatedInputCount);
            this.state(model.state);
            this.regionName(model.regionName);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getNetworkInterfaceType() {
            return this.networkInterfaceType;
        }

        public final void setNetworkInterfaceType(String networkInterfaceType) {
            this.networkInterfaceType = networkInterfaceType;
        }

        @Override
        public final Builder networkInterfaceType(String networkInterfaceType) {
            this.networkInterfaceType = networkInterfaceType;
            return this;
        }

        @Override
        public final Builder networkInterfaceType(RouterNetworkInterfaceType networkInterfaceType) {
            this.networkInterfaceType(networkInterfaceType == null ? null : networkInterfaceType.toString());
            return this;
        }

        public final Integer getAssociatedOutputCount() {
            return this.associatedOutputCount;
        }

        public final void setAssociatedOutputCount(Integer associatedOutputCount) {
            this.associatedOutputCount = associatedOutputCount;
        }

        @Override
        public final Builder associatedOutputCount(Integer associatedOutputCount) {
            this.associatedOutputCount = associatedOutputCount;
            return this;
        }

        public final Integer getAssociatedInputCount() {
            return this.associatedInputCount;
        }

        public final void setAssociatedInputCount(Integer associatedInputCount) {
            this.associatedInputCount = associatedInputCount;
        }

        @Override
        public final Builder associatedInputCount(Integer associatedInputCount) {
            this.associatedInputCount = associatedInputCount;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RouterNetworkInterfaceState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getRegionName() {
            return this.regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ListedRouterNetworkInterface build() {
            return new ListedRouterNetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListedRouterNetworkInterface> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder networkInterfaceType(String var1);

        public Builder networkInterfaceType(RouterNetworkInterfaceType var1);

        public Builder associatedOutputCount(Integer var1);

        public Builder associatedInputCount(Integer var1);

        public Builder state(String var1);

        public Builder state(RouterNetworkInterfaceState var1);

        public Builder regionName(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

