/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.ListedRouterOutput;
import software.amazon.awssdk.services.mediaconnect.model.ListedRouterOutputListCopier;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRouterOutputsResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, ListRouterOutputsResponse> {
    private static final SdkField<List<ListedRouterOutput>> ROUTER_OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouterOutputs").getter(ListRouterOutputsResponse.getter(ListRouterOutputsResponse::routerOutputs)).setter(ListRouterOutputsResponse.setter(Builder::routerOutputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerOutputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedRouterOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRouterOutputsResponse.getter(ListRouterOutputsResponse::nextToken)).setter(ListRouterOutputsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTER_OUTPUTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRouterOutputsResponse.memberNameToFieldInitializer();
    private final List<ListedRouterOutput> routerOutputs;
    private final String nextToken;

    private ListRouterOutputsResponse(BuilderImpl builder) {
        super(builder);
        this.routerOutputs = builder.routerOutputs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRouterOutputs() {
        return this.routerOutputs != null && !(this.routerOutputs instanceof SdkAutoConstructList);
    }

    public final List<ListedRouterOutput> routerOutputs() {
        return this.routerOutputs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouterOutputs() ? this.routerOutputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRouterOutputsResponse)) {
            return false;
        }
        ListRouterOutputsResponse other = (ListRouterOutputsResponse)((Object)obj);
        return this.hasRouterOutputs() == other.hasRouterOutputs() && Objects.equals(this.routerOutputs(), other.routerOutputs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRouterOutputsResponse").add("RouterOutputs", this.hasRouterOutputs() ? this.routerOutputs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouterOutputs": {
                return Optional.ofNullable(clazz.cast(this.routerOutputs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("routerOutputs", ROUTER_OUTPUTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRouterOutputsResponse, T> g) {
        return obj -> g.apply((ListRouterOutputsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private List<ListedRouterOutput> routerOutputs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRouterOutputsResponse model) {
            super(model);
            this.routerOutputs(model.routerOutputs);
            this.nextToken(model.nextToken);
        }

        public final List<ListedRouterOutput.Builder> getRouterOutputs() {
            List<ListedRouterOutput.Builder> result = ListedRouterOutputListCopier.copyToBuilder(this.routerOutputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouterOutputs(Collection<ListedRouterOutput.BuilderImpl> routerOutputs) {
            this.routerOutputs = ListedRouterOutputListCopier.copyFromBuilder(routerOutputs);
        }

        @Override
        public final Builder routerOutputs(Collection<ListedRouterOutput> routerOutputs) {
            this.routerOutputs = ListedRouterOutputListCopier.copy(routerOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerOutputs(ListedRouterOutput ... routerOutputs) {
            this.routerOutputs(Arrays.asList(routerOutputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerOutputs(Consumer<ListedRouterOutput.Builder> ... routerOutputs) {
            this.routerOutputs(Stream.of(routerOutputs).map(c -> (ListedRouterOutput)((ListedRouterOutput.Builder)ListedRouterOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRouterOutputsResponse build() {
            return new ListRouterOutputsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRouterOutputsResponse> {
        public Builder routerOutputs(Collection<ListedRouterOutput> var1);

        public Builder routerOutputs(ListedRouterOutput ... var1);

        public Builder routerOutputs(Consumer<ListedRouterOutput.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

