/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.ListedRouterNetworkInterface;
import software.amazon.awssdk.services.mediaconnect.model.ListedRouterNetworkInterfaceListCopier;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRouterNetworkInterfacesResponse
extends MediaConnectResponse
implements ToCopyableBuilder<Builder, ListRouterNetworkInterfacesResponse> {
    private static final SdkField<List<ListedRouterNetworkInterface>> ROUTER_NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RouterNetworkInterfaces").getter(ListRouterNetworkInterfacesResponse.getter(ListRouterNetworkInterfacesResponse::routerNetworkInterfaces)).setter(ListRouterNetworkInterfacesResponse.setter(Builder::routerNetworkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerNetworkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ListedRouterNetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRouterNetworkInterfacesResponse.getter(ListRouterNetworkInterfacesResponse::nextToken)).setter(ListRouterNetworkInterfacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTER_NETWORK_INTERFACES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRouterNetworkInterfacesResponse.memberNameToFieldInitializer();
    private final List<ListedRouterNetworkInterface> routerNetworkInterfaces;
    private final String nextToken;

    private ListRouterNetworkInterfacesResponse(BuilderImpl builder) {
        super(builder);
        this.routerNetworkInterfaces = builder.routerNetworkInterfaces;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRouterNetworkInterfaces() {
        return this.routerNetworkInterfaces != null && !(this.routerNetworkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<ListedRouterNetworkInterface> routerNetworkInterfaces() {
        return this.routerNetworkInterfaces;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRouterNetworkInterfaces() ? this.routerNetworkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRouterNetworkInterfacesResponse)) {
            return false;
        }
        ListRouterNetworkInterfacesResponse other = (ListRouterNetworkInterfacesResponse)((Object)obj);
        return this.hasRouterNetworkInterfaces() == other.hasRouterNetworkInterfaces() && Objects.equals(this.routerNetworkInterfaces(), other.routerNetworkInterfaces()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRouterNetworkInterfacesResponse").add("RouterNetworkInterfaces", this.hasRouterNetworkInterfaces() ? this.routerNetworkInterfaces() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouterNetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.routerNetworkInterfaces()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("routerNetworkInterfaces", ROUTER_NETWORK_INTERFACES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRouterNetworkInterfacesResponse, T> g) {
        return obj -> g.apply((ListRouterNetworkInterfacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaConnectResponse.BuilderImpl
    implements Builder {
        private List<ListedRouterNetworkInterface> routerNetworkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRouterNetworkInterfacesResponse model) {
            super(model);
            this.routerNetworkInterfaces(model.routerNetworkInterfaces);
            this.nextToken(model.nextToken);
        }

        public final List<ListedRouterNetworkInterface.Builder> getRouterNetworkInterfaces() {
            List<ListedRouterNetworkInterface.Builder> result = ListedRouterNetworkInterfaceListCopier.copyToBuilder(this.routerNetworkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouterNetworkInterfaces(Collection<ListedRouterNetworkInterface.BuilderImpl> routerNetworkInterfaces) {
            this.routerNetworkInterfaces = ListedRouterNetworkInterfaceListCopier.copyFromBuilder(routerNetworkInterfaces);
        }

        @Override
        public final Builder routerNetworkInterfaces(Collection<ListedRouterNetworkInterface> routerNetworkInterfaces) {
            this.routerNetworkInterfaces = ListedRouterNetworkInterfaceListCopier.copy(routerNetworkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerNetworkInterfaces(ListedRouterNetworkInterface ... routerNetworkInterfaces) {
            this.routerNetworkInterfaces(Arrays.asList(routerNetworkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routerNetworkInterfaces(Consumer<ListedRouterNetworkInterface.Builder> ... routerNetworkInterfaces) {
            this.routerNetworkInterfaces(Stream.of(routerNetworkInterfaces).map(c -> (ListedRouterNetworkInterface)((ListedRouterNetworkInterface.Builder)ListedRouterNetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRouterNetworkInterfacesResponse build() {
            return new ListRouterNetworkInterfacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MediaConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRouterNetworkInterfacesResponse> {
        public Builder routerNetworkInterfaces(Collection<ListedRouterNetworkInterface> var1);

        public Builder routerNetworkInterfaces(ListedRouterNetworkInterface ... var1);

        public Builder routerNetworkInterfaces(Consumer<ListedRouterNetworkInterface.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

