/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.AutomaticEncryptionKeyConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.SecretsManagerEncryptionKeyConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowTransitEncryptionKeyConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowTransitEncryptionKeyConfiguration> {
    private static final SdkField<SecretsManagerEncryptionKeyConfiguration> SECRETS_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecretsManager").getter(FlowTransitEncryptionKeyConfiguration.getter(FlowTransitEncryptionKeyConfiguration::secretsManager)).setter(FlowTransitEncryptionKeyConfiguration.setter(Builder::secretsManager)).constructor(SecretsManagerEncryptionKeyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsManager").build()}).build();
    private static final SdkField<AutomaticEncryptionKeyConfiguration> AUTOMATIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Automatic").getter(FlowTransitEncryptionKeyConfiguration.getter(FlowTransitEncryptionKeyConfiguration::automatic)).setter(FlowTransitEncryptionKeyConfiguration.setter(Builder::automatic)).constructor(AutomaticEncryptionKeyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automatic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECRETS_MANAGER_FIELD, AUTOMATIC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FlowTransitEncryptionKeyConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SecretsManagerEncryptionKeyConfiguration secretsManager;
    private final AutomaticEncryptionKeyConfiguration automatic;
    private final Type type;

    private FlowTransitEncryptionKeyConfiguration(BuilderImpl builder) {
        this.secretsManager = builder.secretsManager;
        this.automatic = builder.automatic;
        this.type = builder.type;
    }

    public final SecretsManagerEncryptionKeyConfiguration secretsManager() {
        return this.secretsManager;
    }

    public final AutomaticEncryptionKeyConfiguration automatic() {
        return this.automatic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManager());
        hashCode = 31 * hashCode + Objects.hashCode(this.automatic());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTransitEncryptionKeyConfiguration)) {
            return false;
        }
        FlowTransitEncryptionKeyConfiguration other = (FlowTransitEncryptionKeyConfiguration)obj;
        return Objects.equals(this.secretsManager(), other.secretsManager()) && Objects.equals(this.automatic(), other.automatic());
    }

    public final String toString() {
        return ToString.builder((String)"FlowTransitEncryptionKeyConfiguration").add("SecretsManager", (Object)this.secretsManager()).add("Automatic", (Object)this.automatic()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecretsManager": {
                return Optional.ofNullable(clazz.cast(this.secretsManager()));
            }
            case "Automatic": {
                return Optional.ofNullable(clazz.cast(this.automatic()));
            }
        }
        return Optional.empty();
    }

    public static FlowTransitEncryptionKeyConfiguration fromSecretsManager(SecretsManagerEncryptionKeyConfiguration secretsManager) {
        return (FlowTransitEncryptionKeyConfiguration)FlowTransitEncryptionKeyConfiguration.builder().secretsManager(secretsManager).build();
    }

    public static FlowTransitEncryptionKeyConfiguration fromSecretsManager(Consumer<SecretsManagerEncryptionKeyConfiguration.Builder> secretsManager) {
        SecretsManagerEncryptionKeyConfiguration.Builder builder = SecretsManagerEncryptionKeyConfiguration.builder();
        secretsManager.accept(builder);
        return FlowTransitEncryptionKeyConfiguration.fromSecretsManager((SecretsManagerEncryptionKeyConfiguration)builder.build());
    }

    public static FlowTransitEncryptionKeyConfiguration fromAutomatic(AutomaticEncryptionKeyConfiguration automatic) {
        return (FlowTransitEncryptionKeyConfiguration)FlowTransitEncryptionKeyConfiguration.builder().automatic(automatic).build();
    }

    public static FlowTransitEncryptionKeyConfiguration fromAutomatic(Consumer<AutomaticEncryptionKeyConfiguration.Builder> automatic) {
        AutomaticEncryptionKeyConfiguration.Builder builder = AutomaticEncryptionKeyConfiguration.builder();
        automatic.accept(builder);
        return FlowTransitEncryptionKeyConfiguration.fromAutomatic((AutomaticEncryptionKeyConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("secretsManager", SECRETS_MANAGER_FIELD);
        map.put("automatic", AUTOMATIC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTransitEncryptionKeyConfiguration, T> g) {
        return obj -> g.apply((FlowTransitEncryptionKeyConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        SECRETS_MANAGER,
        AUTOMATIC,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SecretsManagerEncryptionKeyConfiguration secretsManager;
        private AutomaticEncryptionKeyConfiguration automatic;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTransitEncryptionKeyConfiguration model) {
            this.secretsManager(model.secretsManager);
            this.automatic(model.automatic);
        }

        public final SecretsManagerEncryptionKeyConfiguration.Builder getSecretsManager() {
            return this.secretsManager != null ? this.secretsManager.toBuilder() : null;
        }

        public final void setSecretsManager(SecretsManagerEncryptionKeyConfiguration.BuilderImpl secretsManager) {
            SecretsManagerEncryptionKeyConfiguration oldValue = this.secretsManager;
            this.secretsManager = secretsManager != null ? secretsManager.build() : null;
            this.handleUnionValueChange(Type.SECRETS_MANAGER, oldValue, this.secretsManager);
        }

        @Override
        public final Builder secretsManager(SecretsManagerEncryptionKeyConfiguration secretsManager) {
            SecretsManagerEncryptionKeyConfiguration oldValue = this.secretsManager;
            this.secretsManager = secretsManager;
            this.handleUnionValueChange(Type.SECRETS_MANAGER, oldValue, this.secretsManager);
            return this;
        }

        public final AutomaticEncryptionKeyConfiguration.Builder getAutomatic() {
            return this.automatic != null ? this.automatic.toBuilder() : null;
        }

        public final void setAutomatic(AutomaticEncryptionKeyConfiguration.BuilderImpl automatic) {
            AutomaticEncryptionKeyConfiguration oldValue = this.automatic;
            this.automatic = automatic != null ? automatic.build() : null;
            this.handleUnionValueChange(Type.AUTOMATIC, oldValue, this.automatic);
        }

        @Override
        public final Builder automatic(AutomaticEncryptionKeyConfiguration automatic) {
            AutomaticEncryptionKeyConfiguration oldValue = this.automatic;
            this.automatic = automatic;
            this.handleUnionValueChange(Type.AUTOMATIC, oldValue, this.automatic);
            return this;
        }

        public FlowTransitEncryptionKeyConfiguration build() {
            return new FlowTransitEncryptionKeyConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowTransitEncryptionKeyConfiguration> {
        public Builder secretsManager(SecretsManagerEncryptionKeyConfiguration var1);

        default public Builder secretsManager(Consumer<SecretsManagerEncryptionKeyConfiguration.Builder> secretsManager) {
            return this.secretsManager((SecretsManagerEncryptionKeyConfiguration)((SecretsManagerEncryptionKeyConfiguration.Builder)SecretsManagerEncryptionKeyConfiguration.builder().applyMutation(secretsManager)).build());
        }

        public Builder automatic(AutomaticEncryptionKeyConfiguration var1);

        default public Builder automatic(Consumer<AutomaticEncryptionKeyConfiguration.Builder> automatic) {
            return this.automatic((AutomaticEncryptionKeyConfiguration)((AutomaticEncryptionKeyConfiguration.Builder)AutomaticEncryptionKeyConfiguration.builder().applyMutation(automatic)).build());
        }
    }
}

