/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.MediaConnectServiceClientConfiguration;
import software.amazon.awssdk.services.mediaconnect.internal.MediaConnectServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddBridgeSourcesResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowMediaStreamsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputs420Exception;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowSourcesResponse;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.AddFlowVpcInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.BadRequestException;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.BatchGetRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.ConflictException;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridge420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlow420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateGateway420Exception;
import software.amazon.awssdk.services.mediaconnect.model.CreateGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.CreateRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeleteRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DeregisterGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceMetadataRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceMetadataResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceThumbnailRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeFlowSourceThumbnailResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeGatewayResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeOfferingResponse;
import software.amazon.awssdk.services.mediaconnect.model.DescribeReservationRequest;
import software.amazon.awssdk.services.mediaconnect.model.DescribeReservationResponse;
import software.amazon.awssdk.services.mediaconnect.model.ForbiddenException;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputSourceMetadataRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputSourceMetadataResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputThumbnailRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterInputThumbnailResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.GetRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlements420Exception;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.GrantFlowEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.InternalServerErrorException;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListBridgesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListEntitlementsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListFlowsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewayInstancesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListGatewaysResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListOfferingsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListReservationsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterInputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterOutputsResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.MediaConnectException;
import software.amazon.awssdk.services.mediaconnect.model.NotFoundException;
import software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingRequest;
import software.amazon.awssdk.services.mediaconnect.model.PurchaseOfferingResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveBridgeSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowMediaStreamResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.RemoveFlowVpcInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.RestartRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.RevokeFlowEntitlementResponse;
import software.amazon.awssdk.services.mediaconnect.model.RouterInputServiceQuotaExceededException;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceServiceQuotaExceededException;
import software.amazon.awssdk.services.mediaconnect.model.RouterOutputServiceQuotaExceededException;
import software.amazon.awssdk.services.mediaconnect.model.ServiceUnavailableException;
import software.amazon.awssdk.services.mediaconnect.model.StartFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StartRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.StopRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.TagGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.TagGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.TagResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.TagResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.TakeRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.TakeRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.TooManyRequestsException;
import software.amazon.awssdk.services.mediaconnect.model.UntagGlobalResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UntagGlobalResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UntagResourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UntagResourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateBridgeStateResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowEntitlementResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowMediaStreamResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowOutputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateFlowSourceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateGatewayInstanceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterInputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterInputResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterNetworkInterfaceRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterNetworkInterfaceResponse;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterOutputRequest;
import software.amazon.awssdk.services.mediaconnect.model.UpdateRouterOutputResponse;
import software.amazon.awssdk.services.mediaconnect.transform.AddBridgeOutputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddBridgeSourcesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowMediaStreamsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowOutputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowSourcesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.AddFlowVpcInterfacesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.BatchGetRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.BatchGetRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.BatchGetRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateGatewayRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.CreateRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteGatewayRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeleteRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DeregisterGatewayInstanceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeFlowSourceMetadataRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeFlowSourceThumbnailRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeGatewayInstanceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeGatewayRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeOfferingRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.DescribeReservationRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterInputSourceMetadataRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterInputThumbnailRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GetRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.GrantFlowEntitlementsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListBridgesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListEntitlementsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListFlowsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListGatewayInstancesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListOfferingsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListReservationsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListRouterInputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListRouterNetworkInterfacesRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListRouterOutputsRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListTagsForGlobalResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.PurchaseOfferingRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveBridgeOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveBridgeSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowMediaStreamRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RemoveFlowVpcInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RestartRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RestartRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.RevokeFlowEntitlementRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StartFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StartRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StartRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StopFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StopRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.StopRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.TagGlobalResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.TakeRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UntagGlobalResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateBridgeStateRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowEntitlementRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowMediaStreamRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateFlowSourceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateGatewayInstanceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateRouterInputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateRouterNetworkInterfaceRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.transform.UpdateRouterOutputRequestMarshaller;
import software.amazon.awssdk.services.mediaconnect.waiters.MediaConnectAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultMediaConnectAsyncClient
implements MediaConnectAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultMediaConnectAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultMediaConnectAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"MediaConnect#2.41.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<AddBridgeOutputsResponse> addBridgeOutputs(AddBridgeOutputsRequest addBridgeOutputsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addBridgeOutputsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, addBridgeOutputsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddBridgeOutputs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddBridgeOutputsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddBridgeOutputs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddBridgeOutputsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addBridgeOutputsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$addBridgeOutputs$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$addBridgeOutputs$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddBridgeSourcesResponse> addBridgeSources(AddBridgeSourcesRequest addBridgeSourcesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addBridgeSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, addBridgeSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddBridgeSources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddBridgeSourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddBridgeSources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddBridgeSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addBridgeSourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$addBridgeSources$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$addBridgeSources$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddFlowMediaStreamsResponse> addFlowMediaStreams(AddFlowMediaStreamsRequest addFlowMediaStreamsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addFlowMediaStreamsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, addFlowMediaStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddFlowMediaStreams");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddFlowMediaStreamsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddFlowMediaStreams").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddFlowMediaStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addFlowMediaStreamsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$addFlowMediaStreams$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$addFlowMediaStreams$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddFlowOutputsResponse> addFlowOutputs(AddFlowOutputsRequest addFlowOutputsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addFlowOutputsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, addFlowOutputsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddFlowOutputs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddFlowOutputsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddFlowOutputs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddFlowOutputsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addFlowOutputsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$addFlowOutputs$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$addFlowOutputs$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddFlowSourcesResponse> addFlowSources(AddFlowSourcesRequest addFlowSourcesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addFlowSourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, addFlowSourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddFlowSources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddFlowSourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddFlowSources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddFlowSourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addFlowSourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$addFlowSources$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$addFlowSources$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<AddFlowVpcInterfacesResponse> addFlowVpcInterfaces(AddFlowVpcInterfacesRequest addFlowVpcInterfacesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addFlowVpcInterfacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, addFlowVpcInterfacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddFlowVpcInterfaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddFlowVpcInterfacesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddFlowVpcInterfaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new AddFlowVpcInterfacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)addFlowVpcInterfacesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$addFlowVpcInterfaces$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$addFlowVpcInterfaces$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetRouterInputResponse> batchGetRouterInput(BatchGetRouterInputRequest batchGetRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetRouterInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, batchGetRouterInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetRouterInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchGetRouterInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetRouterInputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$batchGetRouterInput$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$batchGetRouterInput$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetRouterNetworkInterfaceResponse> batchGetRouterNetworkInterface(BatchGetRouterNetworkInterfaceRequest batchGetRouterNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetRouterNetworkInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, batchGetRouterNetworkInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetRouterNetworkInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetRouterNetworkInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetRouterNetworkInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchGetRouterNetworkInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetRouterNetworkInterfaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$batchGetRouterNetworkInterface$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$batchGetRouterNetworkInterface$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetRouterOutputResponse> batchGetRouterOutput(BatchGetRouterOutputRequest batchGetRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchGetRouterOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, batchGetRouterOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetRouterOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new BatchGetRouterOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchGetRouterOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$batchGetRouterOutput$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$batchGetRouterOutput$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBridgeResponse> createBridge(CreateBridgeRequest createBridgeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, createBridgeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBridge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBridgeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBridge").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateBridgeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createBridgeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$createBridge$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$createBridge$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateFlowResponse> createFlow(CreateFlowRequest createFlowRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, createFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateFlow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateFlowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateFlow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createFlowRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$createFlow$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$createFlow$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateGatewayResponse> createGateway(CreateGatewayRequest createGatewayRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, createGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createGatewayRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$createGateway$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$createGateway$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRouterInputResponse> createRouterInput(CreateRouterInputRequest createRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRouterInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, createRouterInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRouterInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRouterInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRouterInputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$createRouterInput$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$createRouterInput$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRouterNetworkInterfaceResponse> createRouterNetworkInterface(CreateRouterNetworkInterfaceRequest createRouterNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRouterNetworkInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, createRouterNetworkInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRouterNetworkInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRouterNetworkInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRouterNetworkInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRouterNetworkInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRouterNetworkInterfaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$createRouterNetworkInterface$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$createRouterNetworkInterface$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRouterOutputResponse> createRouterOutput(CreateRouterOutputRequest createRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRouterOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, createRouterOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRouterOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRouterOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRouterOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$createRouterOutput$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$createRouterOutput$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBridgeResponse> deleteBridge(DeleteBridgeRequest deleteBridgeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, deleteBridgeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBridge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBridgeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBridge").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteBridgeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteBridgeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$deleteBridge$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$deleteBridge$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteFlowResponse> deleteFlow(DeleteFlowRequest deleteFlowRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, deleteFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteFlow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteFlowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteFlow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteFlowRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$deleteFlow$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$deleteFlow$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteGatewayResponse> deleteGateway(DeleteGatewayRequest deleteGatewayRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, deleteGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteGatewayRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$deleteGateway$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$deleteGateway$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRouterInputResponse> deleteRouterInput(DeleteRouterInputRequest deleteRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRouterInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRouterInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRouterInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRouterInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRouterInputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$deleteRouterInput$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$deleteRouterInput$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRouterNetworkInterfaceResponse> deleteRouterNetworkInterface(DeleteRouterNetworkInterfaceRequest deleteRouterNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRouterNetworkInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRouterNetworkInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRouterNetworkInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRouterNetworkInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRouterNetworkInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRouterNetworkInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRouterNetworkInterfaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$deleteRouterNetworkInterface$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$deleteRouterNetworkInterface$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRouterOutputResponse> deleteRouterOutput(DeleteRouterOutputRequest deleteRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRouterOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRouterOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRouterOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRouterOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRouterOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$deleteRouterOutput$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$deleteRouterOutput$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeregisterGatewayInstanceResponse> deregisterGatewayInstance(DeregisterGatewayInstanceRequest deregisterGatewayInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterGatewayInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, deregisterGatewayInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterGatewayInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterGatewayInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterGatewayInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeregisterGatewayInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deregisterGatewayInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$deregisterGatewayInstance$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$deregisterGatewayInstance$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeBridgeResponse> describeBridge(DescribeBridgeRequest describeBridgeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, describeBridgeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBridge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBridgeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBridge").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeBridgeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeBridgeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$describeBridge$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$describeBridge$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFlowResponse> describeFlow(DescribeFlowRequest describeFlowRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, describeFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFlow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFlowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFlow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFlowRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$describeFlow$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$describeFlow$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFlowSourceMetadataResponse> describeFlowSourceMetadata(DescribeFlowSourceMetadataRequest describeFlowSourceMetadataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFlowSourceMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, describeFlowSourceMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFlowSourceMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFlowSourceMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFlowSourceMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeFlowSourceMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFlowSourceMetadataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$describeFlowSourceMetadata$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$describeFlowSourceMetadata$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeFlowSourceThumbnailResponse> describeFlowSourceThumbnail(DescribeFlowSourceThumbnailRequest describeFlowSourceThumbnailRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeFlowSourceThumbnailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, describeFlowSourceThumbnailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeFlowSourceThumbnail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeFlowSourceThumbnailResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeFlowSourceThumbnail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeFlowSourceThumbnailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeFlowSourceThumbnailRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$describeFlowSourceThumbnail$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$describeFlowSourceThumbnail$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeGatewayResponse> describeGateway(DescribeGatewayRequest describeGatewayRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeGatewayRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, describeGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGateway");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGatewayResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGateway").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeGatewayRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$describeGateway$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$describeGateway$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeGatewayInstanceResponse> describeGatewayInstance(DescribeGatewayInstanceRequest describeGatewayInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeGatewayInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, describeGatewayInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGatewayInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGatewayInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGatewayInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeGatewayInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeGatewayInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$describeGatewayInstance$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$describeGatewayInstance$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeOfferingResponse> describeOffering(DescribeOfferingRequest describeOfferingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeOfferingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, describeOfferingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeOffering");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeOfferingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeOffering").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeOfferingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeOfferingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$describeOffering$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$describeOffering$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeReservationResponse> describeReservation(DescribeReservationRequest describeReservationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeReservationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, describeReservationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeReservation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeReservationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeReservation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeReservationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeReservationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$describeReservation$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$describeReservation$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRouterInputResponse> getRouterInput(GetRouterInputRequest getRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRouterInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, getRouterInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRouterInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRouterInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRouterInputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$getRouterInput$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$getRouterInput$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRouterInputSourceMetadataResponse> getRouterInputSourceMetadata(GetRouterInputSourceMetadataRequest getRouterInputSourceMetadataRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRouterInputSourceMetadataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, getRouterInputSourceMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRouterInputSourceMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRouterInputSourceMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRouterInputSourceMetadata").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRouterInputSourceMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRouterInputSourceMetadataRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$getRouterInputSourceMetadata$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$getRouterInputSourceMetadata$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRouterInputThumbnailResponse> getRouterInputThumbnail(GetRouterInputThumbnailRequest getRouterInputThumbnailRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRouterInputThumbnailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, getRouterInputThumbnailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRouterInputThumbnail");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRouterInputThumbnailResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRouterInputThumbnail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRouterInputThumbnailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRouterInputThumbnailRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$getRouterInputThumbnail$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$getRouterInputThumbnail$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRouterNetworkInterfaceResponse> getRouterNetworkInterface(GetRouterNetworkInterfaceRequest getRouterNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRouterNetworkInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, getRouterNetworkInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRouterNetworkInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRouterNetworkInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRouterNetworkInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRouterNetworkInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRouterNetworkInterfaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$getRouterNetworkInterface$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$getRouterNetworkInterface$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRouterOutputResponse> getRouterOutput(GetRouterOutputRequest getRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRouterOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, getRouterOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRouterOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRouterOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRouterOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$getRouterOutput$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$getRouterOutput$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GrantFlowEntitlementsResponse> grantFlowEntitlements(GrantFlowEntitlementsRequest grantFlowEntitlementsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)grantFlowEntitlementsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, grantFlowEntitlementsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GrantFlowEntitlements");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GrantFlowEntitlementsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GrantFlowEntitlements").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GrantFlowEntitlementsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)grantFlowEntitlementsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$grantFlowEntitlements$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$grantFlowEntitlements$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListBridgesResponse> listBridges(ListBridgesRequest listBridgesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listBridgesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listBridgesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBridges");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBridgesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBridges").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListBridgesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listBridgesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$listBridges$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$listBridges$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEntitlementsResponse> listEntitlements(ListEntitlementsRequest listEntitlementsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEntitlementsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listEntitlementsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEntitlements");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEntitlementsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEntitlements").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEntitlementsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listEntitlementsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$listEntitlements$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$listEntitlements$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListFlowsResponse> listFlows(ListFlowsRequest listFlowsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFlowsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listFlowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFlows");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFlowsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFlows").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListFlowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listFlowsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$listFlows$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$listFlows$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListGatewayInstancesResponse> listGatewayInstances(ListGatewayInstancesRequest listGatewayInstancesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGatewayInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listGatewayInstancesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGatewayInstances");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGatewayInstancesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGatewayInstances").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListGatewayInstancesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listGatewayInstancesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$listGatewayInstances$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$listGatewayInstances$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListGatewaysResponse> listGateways(ListGatewaysRequest listGatewaysRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listGatewaysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listGatewaysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGateways");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGatewaysResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGateways").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListGatewaysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listGatewaysRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$listGateways$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$listGateways$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListOfferingsResponse> listOfferings(ListOfferingsRequest listOfferingsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOfferingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listOfferingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOfferings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOfferingsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOfferings").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListOfferingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listOfferingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$listOfferings$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$listOfferings$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListReservationsResponse> listReservations(ListReservationsRequest listReservationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listReservationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listReservationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReservations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReservationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReservations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListReservationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listReservationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$listReservations$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$listReservations$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRouterInputsResponse> listRouterInputs(ListRouterInputsRequest listRouterInputsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRouterInputsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listRouterInputsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRouterInputs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRouterInputsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRouterInputs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRouterInputsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRouterInputsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$listRouterInputs$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$listRouterInputs$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRouterNetworkInterfacesResponse> listRouterNetworkInterfaces(ListRouterNetworkInterfacesRequest listRouterNetworkInterfacesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRouterNetworkInterfacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listRouterNetworkInterfacesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRouterNetworkInterfaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRouterNetworkInterfacesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRouterNetworkInterfaces").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRouterNetworkInterfacesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRouterNetworkInterfacesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$listRouterNetworkInterfaces$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$listRouterNetworkInterfaces$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRouterOutputsResponse> listRouterOutputs(ListRouterOutputsRequest listRouterOutputsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRouterOutputsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listRouterOutputsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRouterOutputs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRouterOutputsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRouterOutputs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRouterOutputsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRouterOutputsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$listRouterOutputs$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$listRouterOutputs$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForGlobalResourceResponse> listTagsForGlobalResource(ListTagsForGlobalResourceRequest listTagsForGlobalResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForGlobalResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForGlobalResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForGlobalResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForGlobalResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForGlobalResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForGlobalResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForGlobalResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$listTagsForGlobalResource$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$listTagsForGlobalResource$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$listTagsForResource$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$listTagsForResource$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PurchaseOfferingResponse> purchaseOffering(PurchaseOfferingRequest purchaseOfferingRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)purchaseOfferingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, purchaseOfferingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PurchaseOffering");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PurchaseOfferingResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PurchaseOffering").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PurchaseOfferingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)purchaseOfferingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$purchaseOffering$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$purchaseOffering$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveBridgeOutputResponse> removeBridgeOutput(RemoveBridgeOutputRequest removeBridgeOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeBridgeOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, removeBridgeOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveBridgeOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveBridgeOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveBridgeOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveBridgeOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeBridgeOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$removeBridgeOutput$198(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$removeBridgeOutput$199((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveBridgeSourceResponse> removeBridgeSource(RemoveBridgeSourceRequest removeBridgeSourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeBridgeSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, removeBridgeSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveBridgeSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveBridgeSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveBridgeSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveBridgeSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeBridgeSourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$removeBridgeSource$202(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$removeBridgeSource$203((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveFlowMediaStreamResponse> removeFlowMediaStream(RemoveFlowMediaStreamRequest removeFlowMediaStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeFlowMediaStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, removeFlowMediaStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveFlowMediaStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveFlowMediaStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveFlowMediaStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveFlowMediaStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeFlowMediaStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$removeFlowMediaStream$206(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$removeFlowMediaStream$207((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveFlowOutputResponse> removeFlowOutput(RemoveFlowOutputRequest removeFlowOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeFlowOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, removeFlowOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveFlowOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveFlowOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveFlowOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveFlowOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeFlowOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$removeFlowOutput$210(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$removeFlowOutput$211((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveFlowSourceResponse> removeFlowSource(RemoveFlowSourceRequest removeFlowSourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeFlowSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, removeFlowSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveFlowSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveFlowSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveFlowSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveFlowSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeFlowSourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$removeFlowSource$214(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$removeFlowSource$215((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RemoveFlowVpcInterfaceResponse> removeFlowVpcInterface(RemoveFlowVpcInterfaceRequest removeFlowVpcInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)removeFlowVpcInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, removeFlowVpcInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveFlowVpcInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RemoveFlowVpcInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveFlowVpcInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RemoveFlowVpcInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)removeFlowVpcInterfaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$removeFlowVpcInterface$218(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$removeFlowVpcInterface$219((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestartRouterInputResponse> restartRouterInput(RestartRouterInputRequest restartRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restartRouterInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, restartRouterInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestartRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestartRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestartRouterInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RestartRouterInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)restartRouterInputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$restartRouterInput$222(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$restartRouterInput$223((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestartRouterOutputResponse> restartRouterOutput(RestartRouterOutputRequest restartRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)restartRouterOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, restartRouterOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestartRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestartRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestartRouterOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RestartRouterOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)restartRouterOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$restartRouterOutput$226(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$restartRouterOutput$227((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RevokeFlowEntitlementResponse> revokeFlowEntitlement(RevokeFlowEntitlementRequest revokeFlowEntitlementRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)revokeFlowEntitlementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, revokeFlowEntitlementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RevokeFlowEntitlement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RevokeFlowEntitlementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RevokeFlowEntitlement").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new RevokeFlowEntitlementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)revokeFlowEntitlementRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$revokeFlowEntitlement$230(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$revokeFlowEntitlement$231((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartFlowResponse> startFlow(StartFlowRequest startFlowRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, startFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartFlow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartFlowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartFlow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startFlowRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$startFlow$234(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$startFlow$235((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartRouterInputResponse> startRouterInput(StartRouterInputRequest startRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startRouterInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, startRouterInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartRouterInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartRouterInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startRouterInputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$startRouterInput$238(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$startRouterInput$239((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartRouterOutputResponse> startRouterOutput(StartRouterOutputRequest startRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startRouterOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, startRouterOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartRouterOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartRouterOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startRouterOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$startRouterOutput$242(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$startRouterOutput$243((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopFlowResponse> stopFlow(StopFlowRequest stopFlowRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, stopFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopFlow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopFlowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopFlow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopFlowRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$stopFlow$246(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$stopFlow$247((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopRouterInputResponse> stopRouterInput(StopRouterInputRequest stopRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopRouterInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, stopRouterInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopRouterInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopRouterInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopRouterInputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$stopRouterInput$250(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$stopRouterInput$251((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopRouterOutputResponse> stopRouterOutput(StopRouterOutputRequest stopRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopRouterOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, stopRouterOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopRouterOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopRouterOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopRouterOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$stopRouterOutput$254(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$stopRouterOutput$255((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagGlobalResourceResponse> tagGlobalResource(TagGlobalResourceRequest tagGlobalResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagGlobalResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, tagGlobalResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagGlobalResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagGlobalResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagGlobalResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagGlobalResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagGlobalResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$tagGlobalResource$258(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$tagGlobalResource$259((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$tagResource$262(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$tagResource$263((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TakeRouterInputResponse> takeRouterInput(TakeRouterInputRequest takeRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)takeRouterInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, takeRouterInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TakeRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TakeRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TakeRouterInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TakeRouterInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)takeRouterInputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$takeRouterInput$266(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$takeRouterInput$267((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagGlobalResourceResponse> untagGlobalResource(UntagGlobalResourceRequest untagGlobalResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagGlobalResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, untagGlobalResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagGlobalResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagGlobalResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagGlobalResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagGlobalResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagGlobalResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$untagGlobalResource$270(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$untagGlobalResource$271((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$untagResource$274(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$untagResource$275((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBridgeResponse> updateBridge(UpdateBridgeRequest updateBridgeRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBridgeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateBridgeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBridge");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBridgeResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBridge").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateBridgeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBridgeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateBridge$278(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateBridge$279((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBridgeOutputResponse> updateBridgeOutput(UpdateBridgeOutputRequest updateBridgeOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBridgeOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateBridgeOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBridgeOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBridgeOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBridgeOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateBridgeOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBridgeOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateBridgeOutput$282(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateBridgeOutput$283((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBridgeSourceResponse> updateBridgeSource(UpdateBridgeSourceRequest updateBridgeSourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBridgeSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateBridgeSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBridgeSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBridgeSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBridgeSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateBridgeSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBridgeSourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateBridgeSource$286(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateBridgeSource$287((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateBridgeStateResponse> updateBridgeState(UpdateBridgeStateRequest updateBridgeStateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateBridgeStateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateBridgeStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateBridgeState");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateBridgeStateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateBridgeState").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateBridgeStateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateBridgeStateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateBridgeState$290(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateBridgeState$291((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFlowResponse> updateFlow(UpdateFlowRequest updateFlowRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateFlowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlow").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateFlowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFlowRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateFlow$294(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateFlow$295((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFlowEntitlementResponse> updateFlowEntitlement(UpdateFlowEntitlementRequest updateFlowEntitlementRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlowEntitlementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateFlowEntitlementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlowEntitlement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowEntitlementResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlowEntitlement").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateFlowEntitlementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFlowEntitlementRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateFlowEntitlement$298(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateFlowEntitlement$299((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFlowMediaStreamResponse> updateFlowMediaStream(UpdateFlowMediaStreamRequest updateFlowMediaStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlowMediaStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateFlowMediaStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlowMediaStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowMediaStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlowMediaStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateFlowMediaStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFlowMediaStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateFlowMediaStream$302(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateFlowMediaStream$303((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFlowOutputResponse> updateFlowOutput(UpdateFlowOutputRequest updateFlowOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlowOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateFlowOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlowOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlowOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateFlowOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFlowOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateFlowOutput$306(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateFlowOutput$307((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateFlowSourceResponse> updateFlowSource(UpdateFlowSourceRequest updateFlowSourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateFlowSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateFlowSourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFlowSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFlowSourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFlowSource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateFlowSourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateFlowSourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateFlowSource$310(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateFlowSource$311((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateGatewayInstanceResponse> updateGatewayInstance(UpdateGatewayInstanceRequest updateGatewayInstanceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateGatewayInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateGatewayInstanceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGatewayInstance");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGatewayInstanceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGatewayInstance").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateGatewayInstanceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateGatewayInstanceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateGatewayInstance$314(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateGatewayInstance$315((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRouterInputResponse> updateRouterInput(UpdateRouterInputRequest updateRouterInputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRouterInputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateRouterInputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRouterInput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRouterInputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRouterInput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateRouterInputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRouterInputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateRouterInput$318(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateRouterInput$319((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRouterNetworkInterfaceResponse> updateRouterNetworkInterface(UpdateRouterNetworkInterfaceRequest updateRouterNetworkInterfaceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRouterNetworkInterfaceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateRouterNetworkInterfaceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRouterNetworkInterface");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRouterNetworkInterfaceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRouterNetworkInterface").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateRouterNetworkInterfaceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRouterNetworkInterfaceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateRouterNetworkInterface$322(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateRouterNetworkInterface$323((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRouterOutputResponse> updateRouterOutput(UpdateRouterOutputRequest updateRouterOutputRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRouterOutputRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMediaConnectAsyncClient.resolveMetricPublishers(clientConfiguration, updateRouterOutputRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MediaConnect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRouterOutput");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRouterOutputResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "RouterInputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterInputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterInputServiceQuotaExceededException::builder).build());
                    }
                    case "ForbiddenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ForbiddenException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(ForbiddenException::builder).build());
                    }
                    case "CreateFlow420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateFlow420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateFlow420Exception::builder).build());
                    }
                    case "NotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(NotFoundException::builder).build());
                    }
                    case "RouterNetworkInterfaceServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterNetworkInterfaceServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterNetworkInterfaceServiceQuotaExceededException::builder).build());
                    }
                    case "CreateGateway420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateGateway420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateGateway420Exception::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "GrantFlowEntitlements420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GrantFlowEntitlements420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(GrantFlowEntitlements420Exception::builder).build());
                    }
                    case "AddFlowOutputs420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AddFlowOutputs420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(AddFlowOutputs420Exception::builder).build());
                    }
                    case "TooManyRequestsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyRequestsException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(TooManyRequestsException::builder).build());
                    }
                    case "BadRequestException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BadRequestException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BadRequestException::builder).build());
                    }
                    case "RouterOutputServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RouterOutputServiceQuotaExceededException").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(RouterOutputServiceQuotaExceededException::builder).build());
                    }
                    case "CreateBridge420Exception": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("CreateBridge420Exception").httpStatusCode(Integer.valueOf(420)).exceptionBuilderSupplier(CreateBridge420Exception::builder).build());
                    }
                    case "ServiceUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceUnavailableException").httpStatusCode(Integer.valueOf(503)).exceptionBuilderSupplier(ServiceUnavailableException::builder).build());
                    }
                    case "InternalServerErrorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerErrorException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerErrorException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRouterOutput").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateRouterOutputRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRouterOutputRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultMediaConnectAsyncClient.lambda$updateRouterOutput$326(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultMediaConnectAsyncClient.lambda$updateRouterOutput$327((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public MediaConnectAsyncWaiter waiter() {
        return MediaConnectAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    @Override
    public final MediaConnectServiceClientConfiguration serviceClientConfiguration() {
        return new MediaConnectServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "mediaconnect";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MediaConnectException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        MediaConnectServiceClientConfigurationBuilder serviceConfigBuilder = new MediaConnectServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateRouterOutput$327(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRouterOutput$326(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRouterOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRouterNetworkInterface$323(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRouterNetworkInterface$322(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRouterNetworkInterfaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateRouterInput$319(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRouterInput$318(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRouterInputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateGatewayInstance$315(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGatewayInstance$314(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateGatewayInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFlowSource$311(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlowSource$310(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFlowSourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFlowOutput$307(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlowOutput$306(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFlowOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFlowMediaStream$303(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlowMediaStream$302(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFlowMediaStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFlowEntitlement$299(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlowEntitlement$298(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFlowEntitlementResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateFlow$295(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateFlow$294(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateFlowResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBridgeState$291(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBridgeState$290(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBridgeStateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBridgeSource$287(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBridgeSource$286(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBridgeSourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBridgeOutput$283(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBridgeOutput$282(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBridgeOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateBridge$279(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateBridge$278(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateBridgeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$275(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$274(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagGlobalResource$271(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagGlobalResource$270(List metricPublishers, MetricCollector apiCallMetricCollector, UntagGlobalResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$takeRouterInput$267(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$takeRouterInput$266(List metricPublishers, MetricCollector apiCallMetricCollector, TakeRouterInputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$263(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$262(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagGlobalResource$259(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagGlobalResource$258(List metricPublishers, MetricCollector apiCallMetricCollector, TagGlobalResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopRouterOutput$255(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopRouterOutput$254(List metricPublishers, MetricCollector apiCallMetricCollector, StopRouterOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopRouterInput$251(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopRouterInput$250(List metricPublishers, MetricCollector apiCallMetricCollector, StopRouterInputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopFlow$247(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopFlow$246(List metricPublishers, MetricCollector apiCallMetricCollector, StopFlowResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startRouterOutput$243(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startRouterOutput$242(List metricPublishers, MetricCollector apiCallMetricCollector, StartRouterOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startRouterInput$239(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startRouterInput$238(List metricPublishers, MetricCollector apiCallMetricCollector, StartRouterInputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startFlow$235(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startFlow$234(List metricPublishers, MetricCollector apiCallMetricCollector, StartFlowResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$revokeFlowEntitlement$231(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$revokeFlowEntitlement$230(List metricPublishers, MetricCollector apiCallMetricCollector, RevokeFlowEntitlementResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$restartRouterOutput$227(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restartRouterOutput$226(List metricPublishers, MetricCollector apiCallMetricCollector, RestartRouterOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$restartRouterInput$223(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restartRouterInput$222(List metricPublishers, MetricCollector apiCallMetricCollector, RestartRouterInputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeFlowVpcInterface$219(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeFlowVpcInterface$218(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveFlowVpcInterfaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeFlowSource$215(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeFlowSource$214(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveFlowSourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeFlowOutput$211(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeFlowOutput$210(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveFlowOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeFlowMediaStream$207(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeFlowMediaStream$206(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveFlowMediaStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeBridgeSource$203(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeBridgeSource$202(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveBridgeSourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$removeBridgeOutput$199(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeBridgeOutput$198(List metricPublishers, MetricCollector apiCallMetricCollector, RemoveBridgeOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$purchaseOffering$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$purchaseOffering$194(List metricPublishers, MetricCollector apiCallMetricCollector, PurchaseOfferingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$190(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForGlobalResource$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForGlobalResource$186(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForGlobalResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRouterOutputs$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRouterOutputs$182(List metricPublishers, MetricCollector apiCallMetricCollector, ListRouterOutputsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRouterNetworkInterfaces$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRouterNetworkInterfaces$178(List metricPublishers, MetricCollector apiCallMetricCollector, ListRouterNetworkInterfacesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRouterInputs$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRouterInputs$174(List metricPublishers, MetricCollector apiCallMetricCollector, ListRouterInputsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listReservations$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReservations$170(List metricPublishers, MetricCollector apiCallMetricCollector, ListReservationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listOfferings$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOfferings$166(List metricPublishers, MetricCollector apiCallMetricCollector, ListOfferingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listGateways$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGateways$162(List metricPublishers, MetricCollector apiCallMetricCollector, ListGatewaysResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listGatewayInstances$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGatewayInstances$158(List metricPublishers, MetricCollector apiCallMetricCollector, ListGatewayInstancesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listFlows$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listFlows$154(List metricPublishers, MetricCollector apiCallMetricCollector, ListFlowsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listEntitlements$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEntitlements$150(List metricPublishers, MetricCollector apiCallMetricCollector, ListEntitlementsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listBridges$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBridges$146(List metricPublishers, MetricCollector apiCallMetricCollector, ListBridgesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$grantFlowEntitlements$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$grantFlowEntitlements$142(List metricPublishers, MetricCollector apiCallMetricCollector, GrantFlowEntitlementsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRouterOutput$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRouterOutput$138(List metricPublishers, MetricCollector apiCallMetricCollector, GetRouterOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRouterNetworkInterface$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRouterNetworkInterface$134(List metricPublishers, MetricCollector apiCallMetricCollector, GetRouterNetworkInterfaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRouterInputThumbnail$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRouterInputThumbnail$130(List metricPublishers, MetricCollector apiCallMetricCollector, GetRouterInputThumbnailResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRouterInputSourceMetadata$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRouterInputSourceMetadata$126(List metricPublishers, MetricCollector apiCallMetricCollector, GetRouterInputSourceMetadataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRouterInput$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRouterInput$122(List metricPublishers, MetricCollector apiCallMetricCollector, GetRouterInputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeReservation$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeReservation$118(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeReservationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeOffering$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeOffering$114(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeOfferingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeGatewayInstance$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGatewayInstance$110(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeGatewayInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeGateway$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGateway$106(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeGatewayResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFlowSourceThumbnail$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFlowSourceThumbnail$102(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFlowSourceThumbnailResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFlowSourceMetadata$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFlowSourceMetadata$98(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFlowSourceMetadataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeFlow$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeFlow$94(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeFlowResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeBridge$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBridge$90(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeBridgeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deregisterGatewayInstance$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterGatewayInstance$86(List metricPublishers, MetricCollector apiCallMetricCollector, DeregisterGatewayInstanceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRouterOutput$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRouterOutput$82(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRouterOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRouterNetworkInterface$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRouterNetworkInterface$78(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRouterNetworkInterfaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRouterInput$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRouterInput$74(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRouterInputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteGateway$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGateway$70(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteGatewayResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteFlow$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteFlow$66(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteFlowResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBridge$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBridge$62(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBridgeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRouterOutput$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRouterOutput$58(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRouterOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRouterNetworkInterface$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRouterNetworkInterface$54(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRouterNetworkInterfaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRouterInput$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRouterInput$50(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRouterInputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createGateway$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGateway$46(List metricPublishers, MetricCollector apiCallMetricCollector, CreateGatewayResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createFlow$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createFlow$42(List metricPublishers, MetricCollector apiCallMetricCollector, CreateFlowResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createBridge$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBridge$38(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBridgeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetRouterOutput$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetRouterOutput$34(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetRouterOutputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetRouterNetworkInterface$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetRouterNetworkInterface$30(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetRouterNetworkInterfaceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetRouterInput$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetRouterInput$26(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetRouterInputResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addFlowVpcInterfaces$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addFlowVpcInterfaces$22(List metricPublishers, MetricCollector apiCallMetricCollector, AddFlowVpcInterfacesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addFlowSources$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addFlowSources$18(List metricPublishers, MetricCollector apiCallMetricCollector, AddFlowSourcesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addFlowOutputs$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addFlowOutputs$14(List metricPublishers, MetricCollector apiCallMetricCollector, AddFlowOutputsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addFlowMediaStreams$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addFlowMediaStreams$10(List metricPublishers, MetricCollector apiCallMetricCollector, AddFlowMediaStreamsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addBridgeSources$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addBridgeSources$6(List metricPublishers, MetricCollector apiCallMetricCollector, AddBridgeSourcesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$addBridgeOutputs$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addBridgeOutputs$2(List metricPublishers, MetricCollector apiCallMetricCollector, AddBridgeOutputsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

