/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconnect.MediaConnectAsyncClient;
import software.amazon.awssdk.services.mediaconnect.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesRequest;
import software.amazon.awssdk.services.mediaconnect.model.ListRouterNetworkInterfacesResponse;
import software.amazon.awssdk.services.mediaconnect.model.ListedRouterNetworkInterface;

public class ListRouterNetworkInterfacesPublisher
implements SdkPublisher<ListRouterNetworkInterfacesResponse> {
    private final MediaConnectAsyncClient client;
    private final ListRouterNetworkInterfacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRouterNetworkInterfacesPublisher(MediaConnectAsyncClient client, ListRouterNetworkInterfacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRouterNetworkInterfacesPublisher(MediaConnectAsyncClient client, ListRouterNetworkInterfacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRouterNetworkInterfacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRouterNetworkInterfacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ListedRouterNetworkInterface> routerNetworkInterfaces() {
        Function<ListRouterNetworkInterfacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routerNetworkInterfaces() != null) {
                return response.routerNetworkInterfaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRouterNetworkInterfacesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRouterNetworkInterfacesResponseFetcher
    implements AsyncPageFetcher<ListRouterNetworkInterfacesResponse> {
        private ListRouterNetworkInterfacesResponseFetcher() {
        }

        public boolean hasNextPage(ListRouterNetworkInterfacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRouterNetworkInterfacesResponse> nextPage(ListRouterNetworkInterfacesResponse previousPage) {
            if (previousPage == null) {
                return ListRouterNetworkInterfacesPublisher.this.client.listRouterNetworkInterfaces(ListRouterNetworkInterfacesPublisher.this.firstRequest);
            }
            return ListRouterNetworkInterfacesPublisher.this.client.listRouterNetworkInterfaces((ListRouterNetworkInterfacesRequest)((Object)ListRouterNetworkInterfacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

