/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceType;
import software.amazon.awssdk.services.mediaconnect.model.RouterNetworkInterfaceTypeListCopier;
import software.amazon.awssdk.services.mediaconnect.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouterNetworkInterfaceFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouterNetworkInterfaceFilter> {
    private static final SdkField<List<String>> REGION_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RegionNames").getter(RouterNetworkInterfaceFilter.getter(RouterNetworkInterfaceFilter::regionNames)).setter(RouterNetworkInterfaceFilter.setter(Builder::regionNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NETWORK_INTERFACE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaceTypes").getter(RouterNetworkInterfaceFilter.getter(RouterNetworkInterfaceFilter::networkInterfaceTypesAsStrings)).setter(RouterNetworkInterfaceFilter.setter(Builder::networkInterfaceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NameContains").getter(RouterNetworkInterfaceFilter.getter(RouterNetworkInterfaceFilter::nameContains)).setter(RouterNetworkInterfaceFilter.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameContains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_NAMES_FIELD, NETWORK_INTERFACE_TYPES_FIELD, NAME_CONTAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouterNetworkInterfaceFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> regionNames;
    private final List<String> networkInterfaceTypes;
    private final List<String> nameContains;
    private final Type type;

    private RouterNetworkInterfaceFilter(BuilderImpl builder) {
        this.regionNames = builder.regionNames;
        this.networkInterfaceTypes = builder.networkInterfaceTypes;
        this.nameContains = builder.nameContains;
        this.type = builder.type;
    }

    public final boolean hasRegionNames() {
        return this.regionNames != null && !(this.regionNames instanceof SdkAutoConstructList);
    }

    public final List<String> regionNames() {
        return this.regionNames;
    }

    public final List<RouterNetworkInterfaceType> networkInterfaceTypes() {
        return RouterNetworkInterfaceTypeListCopier.copyStringToEnum(this.networkInterfaceTypes);
    }

    public final boolean hasNetworkInterfaceTypes() {
        return this.networkInterfaceTypes != null && !(this.networkInterfaceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> networkInterfaceTypesAsStrings() {
        return this.networkInterfaceTypes;
    }

    public final boolean hasNameContains() {
        return this.nameContains != null && !(this.nameContains instanceof SdkAutoConstructList);
    }

    public final List<String> nameContains() {
        return this.nameContains;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionNames() ? this.regionNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaceTypes() ? this.networkInterfaceTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNameContains() ? this.nameContains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouterNetworkInterfaceFilter)) {
            return false;
        }
        RouterNetworkInterfaceFilter other = (RouterNetworkInterfaceFilter)obj;
        return this.hasRegionNames() == other.hasRegionNames() && Objects.equals(this.regionNames(), other.regionNames()) && this.hasNetworkInterfaceTypes() == other.hasNetworkInterfaceTypes() && Objects.equals(this.networkInterfaceTypesAsStrings(), other.networkInterfaceTypesAsStrings()) && this.hasNameContains() == other.hasNameContains() && Objects.equals(this.nameContains(), other.nameContains());
    }

    public final String toString() {
        return ToString.builder((String)"RouterNetworkInterfaceFilter").add("RegionNames", this.hasRegionNames() ? this.regionNames() : null).add("NetworkInterfaceTypes", this.hasNetworkInterfaceTypes() ? this.networkInterfaceTypesAsStrings() : null).add("NameContains", this.hasNameContains() ? this.nameContains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RegionNames": {
                return Optional.ofNullable(clazz.cast(this.regionNames()));
            }
            case "NetworkInterfaceTypes": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceTypesAsStrings()));
            }
            case "NameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
        }
        return Optional.empty();
    }

    public static RouterNetworkInterfaceFilter fromRegionNames(List<String> regionNames) {
        return (RouterNetworkInterfaceFilter)RouterNetworkInterfaceFilter.builder().regionNames(regionNames).build();
    }

    public static RouterNetworkInterfaceFilter fromNetworkInterfaceTypesWithStrings(List<String> networkInterfaceTypesWithStrings) {
        return (RouterNetworkInterfaceFilter)RouterNetworkInterfaceFilter.builder().networkInterfaceTypesWithStrings(networkInterfaceTypesWithStrings).build();
    }

    public static RouterNetworkInterfaceFilter fromNetworkInterfaceTypes(List<RouterNetworkInterfaceType> networkInterfaceTypesWithStrings) {
        return (RouterNetworkInterfaceFilter)RouterNetworkInterfaceFilter.builder().networkInterfaceTypes(networkInterfaceTypesWithStrings).build();
    }

    public static RouterNetworkInterfaceFilter fromNameContains(List<String> nameContains) {
        return (RouterNetworkInterfaceFilter)RouterNetworkInterfaceFilter.builder().nameContains(nameContains).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("regionNames", REGION_NAMES_FIELD);
        map.put("networkInterfaceTypes", NETWORK_INTERFACE_TYPES_FIELD);
        map.put("nameContains", NAME_CONTAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouterNetworkInterfaceFilter, T> g) {
        return obj -> g.apply((RouterNetworkInterfaceFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        REGION_NAMES,
        NETWORK_INTERFACE_TYPES,
        NAME_CONTAINS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<String> regionNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> networkInterfaceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> nameContains = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RouterNetworkInterfaceFilter model) {
            this.regionNames(model.regionNames);
            this.networkInterfaceTypesWithStrings(model.networkInterfaceTypes);
            this.nameContains(model.nameContains);
        }

        public final Collection<String> getRegionNames() {
            if (this.regionNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regionNames;
        }

        public final void setRegionNames(Collection<String> regionNames) {
            List<String> oldValue = this.regionNames;
            this.regionNames = StringListCopier.copy(regionNames);
            this.handleUnionValueChange(Type.REGION_NAMES, oldValue, this.regionNames);
        }

        @Override
        public final Builder regionNames(Collection<String> regionNames) {
            List<String> oldValue = this.regionNames;
            this.regionNames = StringListCopier.copy(regionNames);
            this.handleUnionValueChange(Type.REGION_NAMES, oldValue, this.regionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionNames(String ... regionNames) {
            this.regionNames(Arrays.asList(regionNames));
            return this;
        }

        public final Collection<String> getNetworkInterfaceTypes() {
            if (this.networkInterfaceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInterfaceTypes;
        }

        public final void setNetworkInterfaceTypes(Collection<String> networkInterfaceTypes) {
            List<String> oldValue = this.networkInterfaceTypes;
            this.networkInterfaceTypes = RouterNetworkInterfaceTypeListCopier.copy(networkInterfaceTypes);
            this.handleUnionValueChange(Type.NETWORK_INTERFACE_TYPES, oldValue, this.networkInterfaceTypes);
        }

        @Override
        public final Builder networkInterfaceTypesWithStrings(Collection<String> networkInterfaceTypes) {
            List<String> oldValue = this.networkInterfaceTypes;
            this.networkInterfaceTypes = RouterNetworkInterfaceTypeListCopier.copy(networkInterfaceTypes);
            this.handleUnionValueChange(Type.NETWORK_INTERFACE_TYPES, oldValue, this.networkInterfaceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceTypesWithStrings(String ... networkInterfaceTypes) {
            this.networkInterfaceTypesWithStrings(Arrays.asList(networkInterfaceTypes));
            return this;
        }

        @Override
        public final Builder networkInterfaceTypes(Collection<RouterNetworkInterfaceType> networkInterfaceTypes) {
            List<String> oldValue = this.networkInterfaceTypes;
            this.networkInterfaceTypes = RouterNetworkInterfaceTypeListCopier.copyEnumToString(networkInterfaceTypes);
            this.handleUnionValueChange(Type.NETWORK_INTERFACE_TYPES, oldValue, this.networkInterfaceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceTypes(RouterNetworkInterfaceType ... networkInterfaceTypes) {
            this.networkInterfaceTypes(Arrays.asList(networkInterfaceTypes));
            return this;
        }

        public final Collection<String> getNameContains() {
            if (this.nameContains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nameContains;
        }

        public final void setNameContains(Collection<String> nameContains) {
            List<String> oldValue = this.nameContains;
            this.nameContains = StringListCopier.copy(nameContains);
            this.handleUnionValueChange(Type.NAME_CONTAINS, oldValue, this.nameContains);
        }

        @Override
        public final Builder nameContains(Collection<String> nameContains) {
            List<String> oldValue = this.nameContains;
            this.nameContains = StringListCopier.copy(nameContains);
            this.handleUnionValueChange(Type.NAME_CONTAINS, oldValue, this.nameContains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameContains(String ... nameContains) {
            this.nameContains(Arrays.asList(nameContains));
            return this;
        }

        public RouterNetworkInterfaceFilter build() {
            return new RouterNetworkInterfaceFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouterNetworkInterfaceFilter> {
        public Builder regionNames(Collection<String> var1);

        public Builder regionNames(String ... var1);

        public Builder networkInterfaceTypesWithStrings(Collection<String> var1);

        public Builder networkInterfaceTypesWithStrings(String ... var1);

        public Builder networkInterfaceTypes(Collection<RouterNetworkInterfaceType> var1);

        public Builder networkInterfaceTypes(RouterNetworkInterfaceType ... var1);

        public Builder nameContains(Collection<String> var1);

        public Builder nameContains(String ... var1);
    }
}

