/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.MergeRouterInputProtocolConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.MergeRouterInputProtocolConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MergeRouterInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MergeRouterInputConfiguration> {
    private static final SdkField<String> NETWORK_INTERFACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceArn").getter(MergeRouterInputConfiguration.getter(MergeRouterInputConfiguration::networkInterfaceArn)).setter(MergeRouterInputConfiguration.setter(Builder::networkInterfaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceArn").build()}).build();
    private static final SdkField<List<MergeRouterInputProtocolConfiguration>> PROTOCOL_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProtocolConfigurations").getter(MergeRouterInputConfiguration.getter(MergeRouterInputConfiguration::protocolConfigurations)).setter(MergeRouterInputConfiguration.setter(Builder::protocolConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MergeRouterInputProtocolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> MERGE_RECOVERY_WINDOW_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MergeRecoveryWindowMilliseconds").getter(MergeRouterInputConfiguration.getter(MergeRouterInputConfiguration::mergeRecoveryWindowMilliseconds)).setter(MergeRouterInputConfiguration.setter(Builder::mergeRecoveryWindowMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeRecoveryWindowMilliseconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ARN_FIELD, PROTOCOL_CONFIGURATIONS_FIELD, MERGE_RECOVERY_WINDOW_MILLISECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MergeRouterInputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String networkInterfaceArn;
    private final List<MergeRouterInputProtocolConfiguration> protocolConfigurations;
    private final Long mergeRecoveryWindowMilliseconds;

    private MergeRouterInputConfiguration(BuilderImpl builder) {
        this.networkInterfaceArn = builder.networkInterfaceArn;
        this.protocolConfigurations = builder.protocolConfigurations;
        this.mergeRecoveryWindowMilliseconds = builder.mergeRecoveryWindowMilliseconds;
    }

    public final String networkInterfaceArn() {
        return this.networkInterfaceArn;
    }

    public final boolean hasProtocolConfigurations() {
        return this.protocolConfigurations != null && !(this.protocolConfigurations instanceof SdkAutoConstructList);
    }

    public final List<MergeRouterInputProtocolConfiguration> protocolConfigurations() {
        return this.protocolConfigurations;
    }

    public final Long mergeRecoveryWindowMilliseconds() {
        return this.mergeRecoveryWindowMilliseconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProtocolConfigurations() ? this.protocolConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeRecoveryWindowMilliseconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MergeRouterInputConfiguration)) {
            return false;
        }
        MergeRouterInputConfiguration other = (MergeRouterInputConfiguration)obj;
        return Objects.equals(this.networkInterfaceArn(), other.networkInterfaceArn()) && this.hasProtocolConfigurations() == other.hasProtocolConfigurations() && Objects.equals(this.protocolConfigurations(), other.protocolConfigurations()) && Objects.equals(this.mergeRecoveryWindowMilliseconds(), other.mergeRecoveryWindowMilliseconds());
    }

    public final String toString() {
        return ToString.builder((String)"MergeRouterInputConfiguration").add("NetworkInterfaceArn", (Object)this.networkInterfaceArn()).add("ProtocolConfigurations", this.hasProtocolConfigurations() ? this.protocolConfigurations() : null).add("MergeRecoveryWindowMilliseconds", (Object)this.mergeRecoveryWindowMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceArn": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceArn()));
            }
            case "ProtocolConfigurations": {
                return Optional.ofNullable(clazz.cast(this.protocolConfigurations()));
            }
            case "MergeRecoveryWindowMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.mergeRecoveryWindowMilliseconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkInterfaceArn", NETWORK_INTERFACE_ARN_FIELD);
        map.put("protocolConfigurations", PROTOCOL_CONFIGURATIONS_FIELD);
        map.put("mergeRecoveryWindowMilliseconds", MERGE_RECOVERY_WINDOW_MILLISECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MergeRouterInputConfiguration, T> g) {
        return obj -> g.apply((MergeRouterInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkInterfaceArn;
        private List<MergeRouterInputProtocolConfiguration> protocolConfigurations = DefaultSdkAutoConstructList.getInstance();
        private Long mergeRecoveryWindowMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(MergeRouterInputConfiguration model) {
            this.networkInterfaceArn(model.networkInterfaceArn);
            this.protocolConfigurations(model.protocolConfigurations);
            this.mergeRecoveryWindowMilliseconds(model.mergeRecoveryWindowMilliseconds);
        }

        public final String getNetworkInterfaceArn() {
            return this.networkInterfaceArn;
        }

        public final void setNetworkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
        }

        @Override
        public final Builder networkInterfaceArn(String networkInterfaceArn) {
            this.networkInterfaceArn = networkInterfaceArn;
            return this;
        }

        public final List<MergeRouterInputProtocolConfiguration.Builder> getProtocolConfigurations() {
            List<MergeRouterInputProtocolConfiguration.Builder> result = MergeRouterInputProtocolConfigurationListCopier.copyToBuilder(this.protocolConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProtocolConfigurations(Collection<MergeRouterInputProtocolConfiguration.BuilderImpl> protocolConfigurations) {
            this.protocolConfigurations = MergeRouterInputProtocolConfigurationListCopier.copyFromBuilder(protocolConfigurations);
        }

        @Override
        public final Builder protocolConfigurations(Collection<MergeRouterInputProtocolConfiguration> protocolConfigurations) {
            this.protocolConfigurations = MergeRouterInputProtocolConfigurationListCopier.copy(protocolConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolConfigurations(MergeRouterInputProtocolConfiguration ... protocolConfigurations) {
            this.protocolConfigurations(Arrays.asList(protocolConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder protocolConfigurations(Consumer<MergeRouterInputProtocolConfiguration.Builder> ... protocolConfigurations) {
            this.protocolConfigurations(Stream.of(protocolConfigurations).map(c -> (MergeRouterInputProtocolConfiguration)((MergeRouterInputProtocolConfiguration.Builder)MergeRouterInputProtocolConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getMergeRecoveryWindowMilliseconds() {
            return this.mergeRecoveryWindowMilliseconds;
        }

        public final void setMergeRecoveryWindowMilliseconds(Long mergeRecoveryWindowMilliseconds) {
            this.mergeRecoveryWindowMilliseconds = mergeRecoveryWindowMilliseconds;
        }

        @Override
        public final Builder mergeRecoveryWindowMilliseconds(Long mergeRecoveryWindowMilliseconds) {
            this.mergeRecoveryWindowMilliseconds = mergeRecoveryWindowMilliseconds;
            return this;
        }

        public MergeRouterInputConfiguration build() {
            return new MergeRouterInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MergeRouterInputConfiguration> {
        public Builder networkInterfaceArn(String var1);

        public Builder protocolConfigurations(Collection<MergeRouterInputProtocolConfiguration> var1);

        public Builder protocolConfigurations(MergeRouterInputProtocolConfiguration ... var1);

        public Builder protocolConfigurations(Consumer<MergeRouterInputProtocolConfiguration.Builder> ... var1);

        public Builder mergeRecoveryWindowMilliseconds(Long var1);
    }
}

