/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BridgeState {
    CREATING("CREATING"),
    STANDBY("STANDBY"),
    STARTING("STARTING"),
    DEPLOYING("DEPLOYING"),
    ACTIVE("ACTIVE"),
    STOPPING("STOPPING"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    START_FAILED("START_FAILED"),
    START_PENDING("START_PENDING"),
    STOP_FAILED("STOP_FAILED"),
    UPDATING("UPDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BridgeState> VALUE_MAP;
    private final String value;

    private BridgeState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BridgeState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BridgeState> knownValues() {
        EnumSet<BridgeState> knownValues = EnumSet.allOf(BridgeState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BridgeState.class, BridgeState::toString);
    }
}

