/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.BridgeFlowOutput;
import software.amazon.awssdk.services.mediaconnect.model.BridgeNetworkOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BridgeOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BridgeOutput> {
    private static final SdkField<BridgeFlowOutput> FLOW_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlowOutput").getter(BridgeOutput.getter(BridgeOutput::flowOutput)).setter(BridgeOutput.setter(Builder::flowOutput)).constructor(BridgeFlowOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowOutput").build()}).build();
    private static final SdkField<BridgeNetworkOutput> NETWORK_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkOutput").getter(BridgeOutput.getter(BridgeOutput::networkOutput)).setter(BridgeOutput.setter(Builder::networkOutput)).constructor(BridgeNetworkOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_OUTPUT_FIELD, NETWORK_OUTPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BridgeOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BridgeFlowOutput flowOutput;
    private final BridgeNetworkOutput networkOutput;

    private BridgeOutput(BuilderImpl builder) {
        this.flowOutput = builder.flowOutput;
        this.networkOutput = builder.networkOutput;
    }

    public final BridgeFlowOutput flowOutput() {
        return this.flowOutput;
    }

    public final BridgeNetworkOutput networkOutput() {
        return this.networkOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkOutput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BridgeOutput)) {
            return false;
        }
        BridgeOutput other = (BridgeOutput)obj;
        return Objects.equals(this.flowOutput(), other.flowOutput()) && Objects.equals(this.networkOutput(), other.networkOutput());
    }

    public final String toString() {
        return ToString.builder((String)"BridgeOutput").add("FlowOutput", (Object)this.flowOutput()).add("NetworkOutput", (Object)this.networkOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowOutput": {
                return Optional.ofNullable(clazz.cast(this.flowOutput()));
            }
            case "NetworkOutput": {
                return Optional.ofNullable(clazz.cast(this.networkOutput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowOutput", FLOW_OUTPUT_FIELD);
        map.put("networkOutput", NETWORK_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BridgeOutput, T> g) {
        return obj -> g.apply((BridgeOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BridgeFlowOutput flowOutput;
        private BridgeNetworkOutput networkOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(BridgeOutput model) {
            this.flowOutput(model.flowOutput);
            this.networkOutput(model.networkOutput);
        }

        public final BridgeFlowOutput.Builder getFlowOutput() {
            return this.flowOutput != null ? this.flowOutput.toBuilder() : null;
        }

        public final void setFlowOutput(BridgeFlowOutput.BuilderImpl flowOutput) {
            this.flowOutput = flowOutput != null ? flowOutput.build() : null;
        }

        @Override
        public final Builder flowOutput(BridgeFlowOutput flowOutput) {
            this.flowOutput = flowOutput;
            return this;
        }

        public final BridgeNetworkOutput.Builder getNetworkOutput() {
            return this.networkOutput != null ? this.networkOutput.toBuilder() : null;
        }

        public final void setNetworkOutput(BridgeNetworkOutput.BuilderImpl networkOutput) {
            this.networkOutput = networkOutput != null ? networkOutput.build() : null;
        }

        @Override
        public final Builder networkOutput(BridgeNetworkOutput networkOutput) {
            this.networkOutput = networkOutput;
            return this;
        }

        public BridgeOutput build() {
            return new BridgeOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BridgeOutput> {
        public Builder flowOutput(BridgeFlowOutput var1);

        default public Builder flowOutput(Consumer<BridgeFlowOutput.Builder> flowOutput) {
            return this.flowOutput((BridgeFlowOutput)((BridgeFlowOutput.Builder)BridgeFlowOutput.builder().applyMutation(flowOutput)).build());
        }

        public Builder networkOutput(BridgeNetworkOutput var1);

        default public Builder networkOutput(Consumer<BridgeNetworkOutput.Builder> networkOutput) {
            return this.networkOutput((BridgeNetworkOutput)((BridgeNetworkOutput.Builder)BridgeNetworkOutput.builder().applyMutation(networkOutput)).build());
        }
    }
}

