/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconnect.model.Encryption;
import software.amazon.awssdk.services.mediaconnect.model.GatewayBridgeSource;
import software.amazon.awssdk.services.mediaconnect.model.MediaStreamSourceConfiguration;
import software.amazon.awssdk.services.mediaconnect.model.Transport;
import software.amazon.awssdk.services.mediaconnect.model.___listOfMediaStreamSourceConfigurationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Source
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Source> {
    private static final SdkField<Integer> DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DataTransferSubscriberFeePercent").getter(Source.getter(Source::dataTransferSubscriberFeePercent)).setter(Source.setter(Builder::dataTransferSubscriberFeePercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTransferSubscriberFeePercent").build()}).build();
    private static final SdkField<Encryption> DECRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Decryption").getter(Source.getter(Source::decryption)).setter(Source.setter(Builder::decryption)).constructor(Encryption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decryption").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Source.getter(Source::description)).setter(Source.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENTITLEMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntitlementArn").getter(Source.getter(Source::entitlementArn)).setter(Source.setter(Builder::entitlementArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementArn").build()}).build();
    private static final SdkField<String> INGEST_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestIp").getter(Source.getter(Source::ingestIp)).setter(Source.setter(Builder::ingestIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestIp").build()}).build();
    private static final SdkField<Integer> INGEST_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IngestPort").getter(Source.getter(Source::ingestPort)).setter(Source.setter(Builder::ingestPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ingestPort").build()}).build();
    private static final SdkField<List<MediaStreamSourceConfiguration>> MEDIA_STREAM_SOURCE_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MediaStreamSourceConfigurations").getter(Source.getter(Source::mediaStreamSourceConfigurations)).setter(Source.setter(Builder::mediaStreamSourceConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mediaStreamSourceConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MediaStreamSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Source.getter(Source::name)).setter(Source.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> SENDER_CONTROL_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SenderControlPort").getter(Source.getter(Source::senderControlPort)).setter(Source.setter(Builder::senderControlPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderControlPort").build()}).build();
    private static final SdkField<String> SENDER_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderIpAddress").getter(Source.getter(Source::senderIpAddress)).setter(Source.setter(Builder::senderIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("senderIpAddress").build()}).build();
    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceArn").getter(Source.getter(Source::sourceArn)).setter(Source.setter(Builder::sourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()}).build();
    private static final SdkField<Transport> TRANSPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Transport").getter(Source.getter(Source::transport)).setter(Source.setter(Builder::transport)).constructor(Transport::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transport").build()}).build();
    private static final SdkField<String> VPC_INTERFACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcInterfaceName").getter(Source.getter(Source::vpcInterfaceName)).setter(Source.setter(Builder::vpcInterfaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcInterfaceName").build()}).build();
    private static final SdkField<String> WHITELIST_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WhitelistCidr").getter(Source.getter(Source::whitelistCidr)).setter(Source.setter(Builder::whitelistCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("whitelistCidr").build()}).build();
    private static final SdkField<GatewayBridgeSource> GATEWAY_BRIDGE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GatewayBridgeSource").getter(Source.getter(Source::gatewayBridgeSource)).setter(Source.setter(Builder::gatewayBridgeSource)).constructor(GatewayBridgeSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayBridgeSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD, DECRYPTION_FIELD, DESCRIPTION_FIELD, ENTITLEMENT_ARN_FIELD, INGEST_IP_FIELD, INGEST_PORT_FIELD, MEDIA_STREAM_SOURCE_CONFIGURATIONS_FIELD, NAME_FIELD, SENDER_CONTROL_PORT_FIELD, SENDER_IP_ADDRESS_FIELD, SOURCE_ARN_FIELD, TRANSPORT_FIELD, VPC_INTERFACE_NAME_FIELD, WHITELIST_CIDR_FIELD, GATEWAY_BRIDGE_SOURCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Source.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer dataTransferSubscriberFeePercent;
    private final Encryption decryption;
    private final String description;
    private final String entitlementArn;
    private final String ingestIp;
    private final Integer ingestPort;
    private final List<MediaStreamSourceConfiguration> mediaStreamSourceConfigurations;
    private final String name;
    private final Integer senderControlPort;
    private final String senderIpAddress;
    private final String sourceArn;
    private final Transport transport;
    private final String vpcInterfaceName;
    private final String whitelistCidr;
    private final GatewayBridgeSource gatewayBridgeSource;

    private Source(BuilderImpl builder) {
        this.dataTransferSubscriberFeePercent = builder.dataTransferSubscriberFeePercent;
        this.decryption = builder.decryption;
        this.description = builder.description;
        this.entitlementArn = builder.entitlementArn;
        this.ingestIp = builder.ingestIp;
        this.ingestPort = builder.ingestPort;
        this.mediaStreamSourceConfigurations = builder.mediaStreamSourceConfigurations;
        this.name = builder.name;
        this.senderControlPort = builder.senderControlPort;
        this.senderIpAddress = builder.senderIpAddress;
        this.sourceArn = builder.sourceArn;
        this.transport = builder.transport;
        this.vpcInterfaceName = builder.vpcInterfaceName;
        this.whitelistCidr = builder.whitelistCidr;
        this.gatewayBridgeSource = builder.gatewayBridgeSource;
    }

    public final Integer dataTransferSubscriberFeePercent() {
        return this.dataTransferSubscriberFeePercent;
    }

    public final Encryption decryption() {
        return this.decryption;
    }

    public final String description() {
        return this.description;
    }

    public final String entitlementArn() {
        return this.entitlementArn;
    }

    public final String ingestIp() {
        return this.ingestIp;
    }

    public final Integer ingestPort() {
        return this.ingestPort;
    }

    public final boolean hasMediaStreamSourceConfigurations() {
        return this.mediaStreamSourceConfigurations != null && !(this.mediaStreamSourceConfigurations instanceof SdkAutoConstructList);
    }

    public final List<MediaStreamSourceConfiguration> mediaStreamSourceConfigurations() {
        return this.mediaStreamSourceConfigurations;
    }

    public final String name() {
        return this.name;
    }

    public final Integer senderControlPort() {
        return this.senderControlPort;
    }

    public final String senderIpAddress() {
        return this.senderIpAddress;
    }

    public final String sourceArn() {
        return this.sourceArn;
    }

    public final Transport transport() {
        return this.transport;
    }

    public final String vpcInterfaceName() {
        return this.vpcInterfaceName;
    }

    public final String whitelistCidr() {
        return this.whitelistCidr;
    }

    public final GatewayBridgeSource gatewayBridgeSource() {
        return this.gatewayBridgeSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTransferSubscriberFeePercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.decryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMediaStreamSourceConfigurations() ? this.mediaStreamSourceConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderControlPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.senderIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.transport());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcInterfaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.whitelistCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayBridgeSource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.dataTransferSubscriberFeePercent(), other.dataTransferSubscriberFeePercent()) && Objects.equals(this.decryption(), other.decryption()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.entitlementArn(), other.entitlementArn()) && Objects.equals(this.ingestIp(), other.ingestIp()) && Objects.equals(this.ingestPort(), other.ingestPort()) && this.hasMediaStreamSourceConfigurations() == other.hasMediaStreamSourceConfigurations() && Objects.equals(this.mediaStreamSourceConfigurations(), other.mediaStreamSourceConfigurations()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.senderControlPort(), other.senderControlPort()) && Objects.equals(this.senderIpAddress(), other.senderIpAddress()) && Objects.equals(this.sourceArn(), other.sourceArn()) && Objects.equals(this.transport(), other.transport()) && Objects.equals(this.vpcInterfaceName(), other.vpcInterfaceName()) && Objects.equals(this.whitelistCidr(), other.whitelistCidr()) && Objects.equals(this.gatewayBridgeSource(), other.gatewayBridgeSource());
    }

    public final String toString() {
        return ToString.builder((String)"Source").add("DataTransferSubscriberFeePercent", (Object)this.dataTransferSubscriberFeePercent()).add("Decryption", (Object)this.decryption()).add("Description", (Object)this.description()).add("EntitlementArn", (Object)this.entitlementArn()).add("IngestIp", (Object)this.ingestIp()).add("IngestPort", (Object)this.ingestPort()).add("MediaStreamSourceConfigurations", this.hasMediaStreamSourceConfigurations() ? this.mediaStreamSourceConfigurations() : null).add("Name", (Object)this.name()).add("SenderControlPort", (Object)this.senderControlPort()).add("SenderIpAddress", (Object)this.senderIpAddress()).add("SourceArn", (Object)this.sourceArn()).add("Transport", (Object)this.transport()).add("VpcInterfaceName", (Object)this.vpcInterfaceName()).add("WhitelistCidr", (Object)this.whitelistCidr()).add("GatewayBridgeSource", (Object)this.gatewayBridgeSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataTransferSubscriberFeePercent": {
                return Optional.ofNullable(clazz.cast(this.dataTransferSubscriberFeePercent()));
            }
            case "Decryption": {
                return Optional.ofNullable(clazz.cast(this.decryption()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EntitlementArn": {
                return Optional.ofNullable(clazz.cast(this.entitlementArn()));
            }
            case "IngestIp": {
                return Optional.ofNullable(clazz.cast(this.ingestIp()));
            }
            case "IngestPort": {
                return Optional.ofNullable(clazz.cast(this.ingestPort()));
            }
            case "MediaStreamSourceConfigurations": {
                return Optional.ofNullable(clazz.cast(this.mediaStreamSourceConfigurations()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "SenderControlPort": {
                return Optional.ofNullable(clazz.cast(this.senderControlPort()));
            }
            case "SenderIpAddress": {
                return Optional.ofNullable(clazz.cast(this.senderIpAddress()));
            }
            case "SourceArn": {
                return Optional.ofNullable(clazz.cast(this.sourceArn()));
            }
            case "Transport": {
                return Optional.ofNullable(clazz.cast(this.transport()));
            }
            case "VpcInterfaceName": {
                return Optional.ofNullable(clazz.cast(this.vpcInterfaceName()));
            }
            case "WhitelistCidr": {
                return Optional.ofNullable(clazz.cast(this.whitelistCidr()));
            }
            case "GatewayBridgeSource": {
                return Optional.ofNullable(clazz.cast(this.gatewayBridgeSource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataTransferSubscriberFeePercent", DATA_TRANSFER_SUBSCRIBER_FEE_PERCENT_FIELD);
        map.put("decryption", DECRYPTION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("entitlementArn", ENTITLEMENT_ARN_FIELD);
        map.put("ingestIp", INGEST_IP_FIELD);
        map.put("ingestPort", INGEST_PORT_FIELD);
        map.put("mediaStreamSourceConfigurations", MEDIA_STREAM_SOURCE_CONFIGURATIONS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("senderControlPort", SENDER_CONTROL_PORT_FIELD);
        map.put("senderIpAddress", SENDER_IP_ADDRESS_FIELD);
        map.put("sourceArn", SOURCE_ARN_FIELD);
        map.put("transport", TRANSPORT_FIELD);
        map.put("vpcInterfaceName", VPC_INTERFACE_NAME_FIELD);
        map.put("whitelistCidr", WHITELIST_CIDR_FIELD);
        map.put("gatewayBridgeSource", GATEWAY_BRIDGE_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Source, T> g) {
        return obj -> g.apply((Source)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer dataTransferSubscriberFeePercent;
        private Encryption decryption;
        private String description;
        private String entitlementArn;
        private String ingestIp;
        private Integer ingestPort;
        private List<MediaStreamSourceConfiguration> mediaStreamSourceConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private Integer senderControlPort;
        private String senderIpAddress;
        private String sourceArn;
        private Transport transport;
        private String vpcInterfaceName;
        private String whitelistCidr;
        private GatewayBridgeSource gatewayBridgeSource;

        private BuilderImpl() {
        }

        private BuilderImpl(Source model) {
            this.dataTransferSubscriberFeePercent(model.dataTransferSubscriberFeePercent);
            this.decryption(model.decryption);
            this.description(model.description);
            this.entitlementArn(model.entitlementArn);
            this.ingestIp(model.ingestIp);
            this.ingestPort(model.ingestPort);
            this.mediaStreamSourceConfigurations(model.mediaStreamSourceConfigurations);
            this.name(model.name);
            this.senderControlPort(model.senderControlPort);
            this.senderIpAddress(model.senderIpAddress);
            this.sourceArn(model.sourceArn);
            this.transport(model.transport);
            this.vpcInterfaceName(model.vpcInterfaceName);
            this.whitelistCidr(model.whitelistCidr);
            this.gatewayBridgeSource(model.gatewayBridgeSource);
        }

        public final Integer getDataTransferSubscriberFeePercent() {
            return this.dataTransferSubscriberFeePercent;
        }

        public final void setDataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
        }

        @Override
        public final Builder dataTransferSubscriberFeePercent(Integer dataTransferSubscriberFeePercent) {
            this.dataTransferSubscriberFeePercent = dataTransferSubscriberFeePercent;
            return this;
        }

        public final Encryption.Builder getDecryption() {
            return this.decryption != null ? this.decryption.toBuilder() : null;
        }

        public final void setDecryption(Encryption.BuilderImpl decryption) {
            this.decryption = decryption != null ? decryption.build() : null;
        }

        @Override
        public final Builder decryption(Encryption decryption) {
            this.decryption = decryption;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEntitlementArn() {
            return this.entitlementArn;
        }

        public final void setEntitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
        }

        @Override
        public final Builder entitlementArn(String entitlementArn) {
            this.entitlementArn = entitlementArn;
            return this;
        }

        public final String getIngestIp() {
            return this.ingestIp;
        }

        public final void setIngestIp(String ingestIp) {
            this.ingestIp = ingestIp;
        }

        @Override
        public final Builder ingestIp(String ingestIp) {
            this.ingestIp = ingestIp;
            return this;
        }

        public final Integer getIngestPort() {
            return this.ingestPort;
        }

        public final void setIngestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
        }

        @Override
        public final Builder ingestPort(Integer ingestPort) {
            this.ingestPort = ingestPort;
            return this;
        }

        public final List<MediaStreamSourceConfiguration.Builder> getMediaStreamSourceConfigurations() {
            List<MediaStreamSourceConfiguration.Builder> result = ___listOfMediaStreamSourceConfigurationCopier.copyToBuilder(this.mediaStreamSourceConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMediaStreamSourceConfigurations(Collection<MediaStreamSourceConfiguration.BuilderImpl> mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations = ___listOfMediaStreamSourceConfigurationCopier.copyFromBuilder(mediaStreamSourceConfigurations);
        }

        @Override
        public final Builder mediaStreamSourceConfigurations(Collection<MediaStreamSourceConfiguration> mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations = ___listOfMediaStreamSourceConfigurationCopier.copy(mediaStreamSourceConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreamSourceConfigurations(MediaStreamSourceConfiguration ... mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations(Arrays.asList(mediaStreamSourceConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mediaStreamSourceConfigurations(Consumer<MediaStreamSourceConfiguration.Builder> ... mediaStreamSourceConfigurations) {
            this.mediaStreamSourceConfigurations(Stream.of(mediaStreamSourceConfigurations).map(c -> (MediaStreamSourceConfiguration)((MediaStreamSourceConfiguration.Builder)MediaStreamSourceConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getSenderControlPort() {
            return this.senderControlPort;
        }

        public final void setSenderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
        }

        @Override
        public final Builder senderControlPort(Integer senderControlPort) {
            this.senderControlPort = senderControlPort;
            return this;
        }

        public final String getSenderIpAddress() {
            return this.senderIpAddress;
        }

        public final void setSenderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
        }

        @Override
        public final Builder senderIpAddress(String senderIpAddress) {
            this.senderIpAddress = senderIpAddress;
            return this;
        }

        public final String getSourceArn() {
            return this.sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final Transport.Builder getTransport() {
            return this.transport != null ? this.transport.toBuilder() : null;
        }

        public final void setTransport(Transport.BuilderImpl transport) {
            this.transport = transport != null ? transport.build() : null;
        }

        @Override
        public final Builder transport(Transport transport) {
            this.transport = transport;
            return this;
        }

        public final String getVpcInterfaceName() {
            return this.vpcInterfaceName;
        }

        public final void setVpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
        }

        @Override
        public final Builder vpcInterfaceName(String vpcInterfaceName) {
            this.vpcInterfaceName = vpcInterfaceName;
            return this;
        }

        public final String getWhitelistCidr() {
            return this.whitelistCidr;
        }

        public final void setWhitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
        }

        @Override
        public final Builder whitelistCidr(String whitelistCidr) {
            this.whitelistCidr = whitelistCidr;
            return this;
        }

        public final GatewayBridgeSource.Builder getGatewayBridgeSource() {
            return this.gatewayBridgeSource != null ? this.gatewayBridgeSource.toBuilder() : null;
        }

        public final void setGatewayBridgeSource(GatewayBridgeSource.BuilderImpl gatewayBridgeSource) {
            this.gatewayBridgeSource = gatewayBridgeSource != null ? gatewayBridgeSource.build() : null;
        }

        @Override
        public final Builder gatewayBridgeSource(GatewayBridgeSource gatewayBridgeSource) {
            this.gatewayBridgeSource = gatewayBridgeSource;
            return this;
        }

        public Source build() {
            return new Source(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Source> {
        public Builder dataTransferSubscriberFeePercent(Integer var1);

        public Builder decryption(Encryption var1);

        default public Builder decryption(Consumer<Encryption.Builder> decryption) {
            return this.decryption((Encryption)((Encryption.Builder)Encryption.builder().applyMutation(decryption)).build());
        }

        public Builder description(String var1);

        public Builder entitlementArn(String var1);

        public Builder ingestIp(String var1);

        public Builder ingestPort(Integer var1);

        public Builder mediaStreamSourceConfigurations(Collection<MediaStreamSourceConfiguration> var1);

        public Builder mediaStreamSourceConfigurations(MediaStreamSourceConfiguration ... var1);

        public Builder mediaStreamSourceConfigurations(Consumer<MediaStreamSourceConfiguration.Builder> ... var1);

        public Builder name(String var1);

        public Builder senderControlPort(Integer var1);

        public Builder senderIpAddress(String var1);

        public Builder sourceArn(String var1);

        public Builder transport(Transport var1);

        default public Builder transport(Consumer<Transport.Builder> transport) {
            return this.transport((Transport)((Transport.Builder)Transport.builder().applyMutation(transport)).build());
        }

        public Builder vpcInterfaceName(String var1);

        public Builder whitelistCidr(String var1);

        public Builder gatewayBridgeSource(GatewayBridgeSource var1);

        default public Builder gatewayBridgeSource(Consumer<GatewayBridgeSource.Builder> gatewayBridgeSource) {
            return this.gatewayBridgeSource((GatewayBridgeSource)((GatewayBridgeSource.Builder)GatewayBridgeSource.builder().applyMutation(gatewayBridgeSource)).build());
        }
    }
}

