/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconnect.model.VpcInterfaceAttachment;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BridgeFlowSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BridgeFlowSource> {
    private static final SdkField<String> FLOW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowArn").getter(BridgeFlowSource.getter(BridgeFlowSource::flowArn)).setter(BridgeFlowSource.setter(Builder::flowArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowArn").build()}).build();
    private static final SdkField<VpcInterfaceAttachment> FLOW_VPC_INTERFACE_ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlowVpcInterfaceAttachment").getter(BridgeFlowSource.getter(BridgeFlowSource::flowVpcInterfaceAttachment)).setter(BridgeFlowSource.setter(Builder::flowVpcInterfaceAttachment)).constructor(VpcInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowVpcInterfaceAttachment").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(BridgeFlowSource.getter(BridgeFlowSource::name)).setter(BridgeFlowSource.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OUTPUT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputArn").getter(BridgeFlowSource.getter(BridgeFlowSource::outputArn)).setter(BridgeFlowSource.setter(Builder::outputArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_ARN_FIELD, FLOW_VPC_INTERFACE_ATTACHMENT_FIELD, NAME_FIELD, OUTPUT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BridgeFlowSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String flowArn;
    private final VpcInterfaceAttachment flowVpcInterfaceAttachment;
    private final String name;
    private final String outputArn;

    private BridgeFlowSource(BuilderImpl builder) {
        this.flowArn = builder.flowArn;
        this.flowVpcInterfaceAttachment = builder.flowVpcInterfaceAttachment;
        this.name = builder.name;
        this.outputArn = builder.outputArn;
    }

    public final String flowArn() {
        return this.flowArn;
    }

    public final VpcInterfaceAttachment flowVpcInterfaceAttachment() {
        return this.flowVpcInterfaceAttachment;
    }

    public final String name() {
        return this.name;
    }

    public final String outputArn() {
        return this.outputArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowVpcInterfaceAttachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BridgeFlowSource)) {
            return false;
        }
        BridgeFlowSource other = (BridgeFlowSource)obj;
        return Objects.equals(this.flowArn(), other.flowArn()) && Objects.equals(this.flowVpcInterfaceAttachment(), other.flowVpcInterfaceAttachment()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.outputArn(), other.outputArn());
    }

    public final String toString() {
        return ToString.builder((String)"BridgeFlowSource").add("FlowArn", (Object)this.flowArn()).add("FlowVpcInterfaceAttachment", (Object)this.flowVpcInterfaceAttachment()).add("Name", (Object)this.name()).add("OutputArn", (Object)this.outputArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowArn": {
                return Optional.ofNullable(clazz.cast(this.flowArn()));
            }
            case "FlowVpcInterfaceAttachment": {
                return Optional.ofNullable(clazz.cast(this.flowVpcInterfaceAttachment()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "OutputArn": {
                return Optional.ofNullable(clazz.cast(this.outputArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flowArn", FLOW_ARN_FIELD);
        map.put("flowVpcInterfaceAttachment", FLOW_VPC_INTERFACE_ATTACHMENT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("outputArn", OUTPUT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BridgeFlowSource, T> g) {
        return obj -> g.apply((BridgeFlowSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flowArn;
        private VpcInterfaceAttachment flowVpcInterfaceAttachment;
        private String name;
        private String outputArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BridgeFlowSource model) {
            this.flowArn(model.flowArn);
            this.flowVpcInterfaceAttachment(model.flowVpcInterfaceAttachment);
            this.name(model.name);
            this.outputArn(model.outputArn);
        }

        public final String getFlowArn() {
            return this.flowArn;
        }

        public final void setFlowArn(String flowArn) {
            this.flowArn = flowArn;
        }

        @Override
        public final Builder flowArn(String flowArn) {
            this.flowArn = flowArn;
            return this;
        }

        public final VpcInterfaceAttachment.Builder getFlowVpcInterfaceAttachment() {
            return this.flowVpcInterfaceAttachment != null ? this.flowVpcInterfaceAttachment.toBuilder() : null;
        }

        public final void setFlowVpcInterfaceAttachment(VpcInterfaceAttachment.BuilderImpl flowVpcInterfaceAttachment) {
            this.flowVpcInterfaceAttachment = flowVpcInterfaceAttachment != null ? flowVpcInterfaceAttachment.build() : null;
        }

        @Override
        public final Builder flowVpcInterfaceAttachment(VpcInterfaceAttachment flowVpcInterfaceAttachment) {
            this.flowVpcInterfaceAttachment = flowVpcInterfaceAttachment;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOutputArn() {
            return this.outputArn;
        }

        public final void setOutputArn(String outputArn) {
            this.outputArn = outputArn;
        }

        @Override
        public final Builder outputArn(String outputArn) {
            this.outputArn = outputArn;
            return this;
        }

        public BridgeFlowSource build() {
            return new BridgeFlowSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BridgeFlowSource> {
        public Builder flowArn(String var1);

        public Builder flowVpcInterfaceAttachment(VpcInterfaceAttachment var1);

        default public Builder flowVpcInterfaceAttachment(Consumer<VpcInterfaceAttachment.Builder> flowVpcInterfaceAttachment) {
            return this.flowVpcInterfaceAttachment((VpcInterfaceAttachment)((VpcInterfaceAttachment.Builder)VpcInterfaceAttachment.builder().applyMutation(flowVpcInterfaceAttachment)).build());
        }

        public Builder name(String var1);

        public Builder outputArn(String var1);
    }
}

