/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceentitlement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EntitlementValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EntitlementValue> {
    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IntegerValue").getter(EntitlementValue.getter(EntitlementValue::integerValue)).setter(EntitlementValue.setter(Builder::integerValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerValue").build()}).build();
    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DoubleValue").getter(EntitlementValue.getter(EntitlementValue::doubleValue)).setter(EntitlementValue.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DoubleValue").build()}).build();
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("BooleanValue").getter(EntitlementValue.getter(EntitlementValue::booleanValue)).setter(EntitlementValue.setter(Builder::booleanValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanValue").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StringValue").getter(EntitlementValue.getter(EntitlementValue::stringValue)).setter(EntitlementValue.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTEGER_VALUE_FIELD, DOUBLE_VALUE_FIELD, BOOLEAN_VALUE_FIELD, STRING_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EntitlementValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer integerValue;
    private final Double doubleValue;
    private final Boolean booleanValue;
    private final String stringValue;
    private final Type type;

    private EntitlementValue(BuilderImpl builder) {
        this.integerValue = builder.integerValue;
        this.doubleValue = builder.doubleValue;
        this.booleanValue = builder.booleanValue;
        this.stringValue = builder.stringValue;
        this.type = builder.type;
    }

    public final Integer integerValue() {
        return this.integerValue;
    }

    public final Double doubleValue() {
        return this.doubleValue;
    }

    public final Boolean booleanValue() {
        return this.booleanValue;
    }

    public final String stringValue() {
        return this.stringValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntitlementValue)) {
            return false;
        }
        EntitlementValue other = (EntitlementValue)obj;
        return Objects.equals(this.integerValue(), other.integerValue()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.booleanValue(), other.booleanValue()) && Objects.equals(this.stringValue(), other.stringValue());
    }

    public final String toString() {
        return ToString.builder((String)"EntitlementValue").add("IntegerValue", (Object)this.integerValue()).add("DoubleValue", (Object)this.doubleValue()).add("BooleanValue", (Object)this.booleanValue()).add("StringValue", (Object)this.stringValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IntegerValue": {
                return Optional.ofNullable(clazz.cast(this.integerValue()));
            }
            case "DoubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "BooleanValue": {
                return Optional.ofNullable(clazz.cast(this.booleanValue()));
            }
            case "StringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
        }
        return Optional.empty();
    }

    public static EntitlementValue fromIntegerValue(Integer integerValue) {
        return (EntitlementValue)EntitlementValue.builder().integerValue(integerValue).build();
    }

    public static EntitlementValue fromDoubleValue(Double doubleValue) {
        return (EntitlementValue)EntitlementValue.builder().doubleValue(doubleValue).build();
    }

    public static EntitlementValue fromBooleanValue(Boolean booleanValue) {
        return (EntitlementValue)EntitlementValue.builder().booleanValue(booleanValue).build();
    }

    public static EntitlementValue fromStringValue(String stringValue) {
        return (EntitlementValue)EntitlementValue.builder().stringValue(stringValue).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IntegerValue", INTEGER_VALUE_FIELD);
        map.put("DoubleValue", DOUBLE_VALUE_FIELD);
        map.put("BooleanValue", BOOLEAN_VALUE_FIELD);
        map.put("StringValue", STRING_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EntitlementValue, T> g) {
        return obj -> g.apply((EntitlementValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INTEGER_VALUE,
        DOUBLE_VALUE,
        BOOLEAN_VALUE,
        STRING_VALUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Integer integerValue;
        private Double doubleValue;
        private Boolean booleanValue;
        private String stringValue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EntitlementValue model) {
            this.integerValue(model.integerValue);
            this.doubleValue(model.doubleValue);
            this.booleanValue(model.booleanValue);
            this.stringValue(model.stringValue);
        }

        public final Integer getIntegerValue() {
            return this.integerValue;
        }

        public final void setIntegerValue(Integer integerValue) {
            Integer oldValue = this.integerValue;
            this.integerValue = integerValue;
            this.handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            Integer oldValue = this.integerValue;
            this.integerValue = integerValue;
            this.handleUnionValueChange(Type.INTEGER_VALUE, oldValue, this.integerValue);
            return this;
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            Double oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            this.handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final Boolean getBooleanValue() {
            return this.booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Boolean oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            this.handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        public final void setStringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            String oldValue = this.stringValue;
            this.stringValue = stringValue;
            this.handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public EntitlementValue build() {
            return new EntitlementValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EntitlementValue> {
        public Builder integerValue(Integer var1);

        public Builder doubleValue(Double var1);

        public Builder booleanValue(Boolean var1);

        public Builder stringValue(String var1);
    }
}

