/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplaceagreement.model.ConfigurableUpfrontPricingTermConfiguration;
import software.amazon.awssdk.services.marketplaceagreement.model.ConfigurableUpfrontRateCardItem;
import software.amazon.awssdk.services.marketplaceagreement.model.ConfigurableUpfrontRateCardListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurableUpfrontPricingTerm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurableUpfrontPricingTerm> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ConfigurableUpfrontPricingTerm.getter(ConfigurableUpfrontPricingTerm::type)).setter(ConfigurableUpfrontPricingTerm.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currencyCode").getter(ConfigurableUpfrontPricingTerm.getter(ConfigurableUpfrontPricingTerm::currencyCode)).setter(ConfigurableUpfrontPricingTerm.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()}).build();
    private static final SdkField<List<ConfigurableUpfrontRateCardItem>> RATE_CARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rateCards").getter(ConfigurableUpfrontPricingTerm.getter(ConfigurableUpfrontPricingTerm::rateCards)).setter(ConfigurableUpfrontPricingTerm.setter(Builder::rateCards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateCards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigurableUpfrontRateCardItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConfigurableUpfrontPricingTermConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(ConfigurableUpfrontPricingTerm.getter(ConfigurableUpfrontPricingTerm::configuration)).setter(ConfigurableUpfrontPricingTerm.setter(Builder::configuration)).constructor(ConfigurableUpfrontPricingTermConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, CURRENCY_CODE_FIELD, RATE_CARDS_FIELD, CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfigurableUpfrontPricingTerm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String currencyCode;
    private final List<ConfigurableUpfrontRateCardItem> rateCards;
    private final ConfigurableUpfrontPricingTermConfiguration configuration;

    private ConfigurableUpfrontPricingTerm(BuilderImpl builder) {
        this.type = builder.type;
        this.currencyCode = builder.currencyCode;
        this.rateCards = builder.rateCards;
        this.configuration = builder.configuration;
    }

    public final String type() {
        return this.type;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final boolean hasRateCards() {
        return this.rateCards != null && !(this.rateCards instanceof SdkAutoConstructList);
    }

    public final List<ConfigurableUpfrontRateCardItem> rateCards() {
        return this.rateCards;
    }

    public final ConfigurableUpfrontPricingTermConfiguration configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRateCards() ? this.rateCards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableUpfrontPricingTerm)) {
            return false;
        }
        ConfigurableUpfrontPricingTerm other = (ConfigurableUpfrontPricingTerm)obj;
        return Objects.equals(this.type(), other.type()) && Objects.equals(this.currencyCode(), other.currencyCode()) && this.hasRateCards() == other.hasRateCards() && Objects.equals(this.rateCards(), other.rateCards()) && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurableUpfrontPricingTerm").add("Type", (Object)this.type()).add("CurrencyCode", (Object)this.currencyCode()).add("RateCards", this.hasRateCards() ? this.rateCards() : null).add("Configuration", (Object)this.configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "currencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "rateCards": {
                return Optional.ofNullable(clazz.cast(this.rateCards()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("currencyCode", CURRENCY_CODE_FIELD);
        map.put("rateCards", RATE_CARDS_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigurableUpfrontPricingTerm, T> g) {
        return obj -> g.apply((ConfigurableUpfrontPricingTerm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String currencyCode;
        private List<ConfigurableUpfrontRateCardItem> rateCards = DefaultSdkAutoConstructList.getInstance();
        private ConfigurableUpfrontPricingTermConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurableUpfrontPricingTerm model) {
            this.type(model.type);
            this.currencyCode(model.currencyCode);
            this.rateCards(model.rateCards);
            this.configuration(model.configuration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final List<ConfigurableUpfrontRateCardItem.Builder> getRateCards() {
            List<ConfigurableUpfrontRateCardItem.Builder> result = ConfigurableUpfrontRateCardListCopier.copyToBuilder(this.rateCards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRateCards(Collection<ConfigurableUpfrontRateCardItem.BuilderImpl> rateCards) {
            this.rateCards = ConfigurableUpfrontRateCardListCopier.copyFromBuilder(rateCards);
        }

        @Override
        public final Builder rateCards(Collection<ConfigurableUpfrontRateCardItem> rateCards) {
            this.rateCards = ConfigurableUpfrontRateCardListCopier.copy(rateCards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCards(ConfigurableUpfrontRateCardItem ... rateCards) {
            this.rateCards(Arrays.asList(rateCards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCards(Consumer<ConfigurableUpfrontRateCardItem.Builder> ... rateCards) {
            this.rateCards(Stream.of(rateCards).map(c -> (ConfigurableUpfrontRateCardItem)((ConfigurableUpfrontRateCardItem.Builder)ConfigurableUpfrontRateCardItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ConfigurableUpfrontPricingTermConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(ConfigurableUpfrontPricingTermConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(ConfigurableUpfrontPricingTermConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public ConfigurableUpfrontPricingTerm build() {
            return new ConfigurableUpfrontPricingTerm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurableUpfrontPricingTerm> {
        public Builder type(String var1);

        public Builder currencyCode(String var1);

        public Builder rateCards(Collection<ConfigurableUpfrontRateCardItem> var1);

        public Builder rateCards(ConfigurableUpfrontRateCardItem ... var1);

        public Builder rateCards(Consumer<ConfigurableUpfrontRateCardItem.Builder> ... var1);

        public Builder configuration(ConfigurableUpfrontPricingTermConfiguration var1);

        default public Builder configuration(Consumer<ConfigurableUpfrontPricingTermConfiguration.Builder> configuration) {
            return this.configuration((ConfigurableUpfrontPricingTermConfiguration)((ConfigurableUpfrontPricingTermConfiguration.Builder)ConfigurableUpfrontPricingTermConfiguration.builder().applyMutation(configuration)).build());
        }
    }
}

