/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.marketplaceagreement.model.Acceptor;
import software.amazon.awssdk.services.marketplaceagreement.model.AgreementStatus;
import software.amazon.awssdk.services.marketplaceagreement.model.ProposalSummary;
import software.amazon.awssdk.services.marketplaceagreement.model.Proposer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgreementViewSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgreementViewSummary> {
    private static final SdkField<String> AGREEMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agreementId").getter(AgreementViewSummary.getter(AgreementViewSummary::agreementId)).setter(AgreementViewSummary.setter(Builder::agreementId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementId").build()}).build();
    private static final SdkField<Instant> ACCEPTANCE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("acceptanceTime").getter(AgreementViewSummary.getter(AgreementViewSummary::acceptanceTime)).setter(AgreementViewSummary.setter(Builder::acceptanceTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptanceTime").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(AgreementViewSummary.getter(AgreementViewSummary::startTime)).setter(AgreementViewSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(AgreementViewSummary.getter(AgreementViewSummary::endTime)).setter(AgreementViewSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> AGREEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agreementType").getter(AgreementViewSummary.getter(AgreementViewSummary::agreementType)).setter(AgreementViewSummary.setter(Builder::agreementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementType").build()}).build();
    private static final SdkField<Acceptor> ACCEPTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("acceptor").getter(AgreementViewSummary.getter(AgreementViewSummary::acceptor)).setter(AgreementViewSummary.setter(Builder::acceptor)).constructor(Acceptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceptor").build()}).build();
    private static final SdkField<Proposer> PROPOSER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("proposer").getter(AgreementViewSummary.getter(AgreementViewSummary::proposer)).setter(AgreementViewSummary.setter(Builder::proposer)).constructor(Proposer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proposer").build()}).build();
    private static final SdkField<ProposalSummary> PROPOSAL_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("proposalSummary").getter(AgreementViewSummary.getter(AgreementViewSummary::proposalSummary)).setter(AgreementViewSummary.setter(Builder::proposalSummary)).constructor(ProposalSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("proposalSummary").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AgreementViewSummary.getter(AgreementViewSummary::statusAsString)).setter(AgreementViewSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_ID_FIELD, ACCEPTANCE_TIME_FIELD, START_TIME_FIELD, END_TIME_FIELD, AGREEMENT_TYPE_FIELD, ACCEPTOR_FIELD, PROPOSER_FIELD, PROPOSAL_SUMMARY_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AgreementViewSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String agreementId;
    private final Instant acceptanceTime;
    private final Instant startTime;
    private final Instant endTime;
    private final String agreementType;
    private final Acceptor acceptor;
    private final Proposer proposer;
    private final ProposalSummary proposalSummary;
    private final String status;

    private AgreementViewSummary(BuilderImpl builder) {
        this.agreementId = builder.agreementId;
        this.acceptanceTime = builder.acceptanceTime;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.agreementType = builder.agreementType;
        this.acceptor = builder.acceptor;
        this.proposer = builder.proposer;
        this.proposalSummary = builder.proposalSummary;
        this.status = builder.status;
    }

    public final String agreementId() {
        return this.agreementId;
    }

    public final Instant acceptanceTime() {
        return this.acceptanceTime;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String agreementType() {
        return this.agreementType;
    }

    public final Acceptor acceptor() {
        return this.acceptor;
    }

    public final Proposer proposer() {
        return this.proposer;
    }

    public final ProposalSummary proposalSummary() {
        return this.proposalSummary;
    }

    public final AgreementStatus status() {
        return AgreementStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.agreementId());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptanceTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.agreementType());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptor());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposer());
        hashCode = 31 * hashCode + Objects.hashCode(this.proposalSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgreementViewSummary)) {
            return false;
        }
        AgreementViewSummary other = (AgreementViewSummary)obj;
        return Objects.equals(this.agreementId(), other.agreementId()) && Objects.equals(this.acceptanceTime(), other.acceptanceTime()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.agreementType(), other.agreementType()) && Objects.equals(this.acceptor(), other.acceptor()) && Objects.equals(this.proposer(), other.proposer()) && Objects.equals(this.proposalSummary(), other.proposalSummary()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AgreementViewSummary").add("AgreementId", (Object)this.agreementId()).add("AcceptanceTime", (Object)this.acceptanceTime()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("AgreementType", (Object)this.agreementType()).add("Acceptor", (Object)this.acceptor()).add("Proposer", (Object)this.proposer()).add("ProposalSummary", (Object)this.proposalSummary()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agreementId": {
                return Optional.ofNullable(clazz.cast(this.agreementId()));
            }
            case "acceptanceTime": {
                return Optional.ofNullable(clazz.cast(this.acceptanceTime()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "agreementType": {
                return Optional.ofNullable(clazz.cast(this.agreementType()));
            }
            case "acceptor": {
                return Optional.ofNullable(clazz.cast(this.acceptor()));
            }
            case "proposer": {
                return Optional.ofNullable(clazz.cast(this.proposer()));
            }
            case "proposalSummary": {
                return Optional.ofNullable(clazz.cast(this.proposalSummary()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agreementId", AGREEMENT_ID_FIELD);
        map.put("acceptanceTime", ACCEPTANCE_TIME_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("agreementType", AGREEMENT_TYPE_FIELD);
        map.put("acceptor", ACCEPTOR_FIELD);
        map.put("proposer", PROPOSER_FIELD);
        map.put("proposalSummary", PROPOSAL_SUMMARY_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgreementViewSummary, T> g) {
        return obj -> g.apply((AgreementViewSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String agreementId;
        private Instant acceptanceTime;
        private Instant startTime;
        private Instant endTime;
        private String agreementType;
        private Acceptor acceptor;
        private Proposer proposer;
        private ProposalSummary proposalSummary;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AgreementViewSummary model) {
            this.agreementId(model.agreementId);
            this.acceptanceTime(model.acceptanceTime);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.agreementType(model.agreementType);
            this.acceptor(model.acceptor);
            this.proposer(model.proposer);
            this.proposalSummary(model.proposalSummary);
            this.status(model.status);
        }

        public final String getAgreementId() {
            return this.agreementId;
        }

        public final void setAgreementId(String agreementId) {
            this.agreementId = agreementId;
        }

        @Override
        public final Builder agreementId(String agreementId) {
            this.agreementId = agreementId;
            return this;
        }

        public final Instant getAcceptanceTime() {
            return this.acceptanceTime;
        }

        public final void setAcceptanceTime(Instant acceptanceTime) {
            this.acceptanceTime = acceptanceTime;
        }

        @Override
        public final Builder acceptanceTime(Instant acceptanceTime) {
            this.acceptanceTime = acceptanceTime;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getAgreementType() {
            return this.agreementType;
        }

        public final void setAgreementType(String agreementType) {
            this.agreementType = agreementType;
        }

        @Override
        public final Builder agreementType(String agreementType) {
            this.agreementType = agreementType;
            return this;
        }

        public final Acceptor.Builder getAcceptor() {
            return this.acceptor != null ? this.acceptor.toBuilder() : null;
        }

        public final void setAcceptor(Acceptor.BuilderImpl acceptor) {
            this.acceptor = acceptor != null ? acceptor.build() : null;
        }

        @Override
        public final Builder acceptor(Acceptor acceptor) {
            this.acceptor = acceptor;
            return this;
        }

        public final Proposer.Builder getProposer() {
            return this.proposer != null ? this.proposer.toBuilder() : null;
        }

        public final void setProposer(Proposer.BuilderImpl proposer) {
            this.proposer = proposer != null ? proposer.build() : null;
        }

        @Override
        public final Builder proposer(Proposer proposer) {
            this.proposer = proposer;
            return this;
        }

        public final ProposalSummary.Builder getProposalSummary() {
            return this.proposalSummary != null ? this.proposalSummary.toBuilder() : null;
        }

        public final void setProposalSummary(ProposalSummary.BuilderImpl proposalSummary) {
            this.proposalSummary = proposalSummary != null ? proposalSummary.build() : null;
        }

        @Override
        public final Builder proposalSummary(ProposalSummary proposalSummary) {
            this.proposalSummary = proposalSummary;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgreementStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public AgreementViewSummary build() {
            return new AgreementViewSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgreementViewSummary> {
        public Builder agreementId(String var1);

        public Builder acceptanceTime(Instant var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder agreementType(String var1);

        public Builder acceptor(Acceptor var1);

        default public Builder acceptor(Consumer<Acceptor.Builder> acceptor) {
            return this.acceptor((Acceptor)((Acceptor.Builder)Acceptor.builder().applyMutation(acceptor)).build());
        }

        public Builder proposer(Proposer var1);

        default public Builder proposer(Consumer<Proposer.Builder> proposer) {
            return this.proposer((Proposer)((Proposer.Builder)Proposer.builder().applyMutation(proposer)).build());
        }

        public Builder proposalSummary(ProposalSummary var1);

        default public Builder proposalSummary(Consumer<ProposalSummary.Builder> proposalSummary) {
            return this.proposalSummary((ProposalSummary)((ProposalSummary.Builder)ProposalSummary.builder().applyMutation(proposalSummary)).build());
        }

        public Builder status(String var1);

        public Builder status(AgreementStatus var1);
    }
}

