/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.marketplaceagreement.MarketplaceAgreementClient;
import software.amazon.awssdk.services.marketplaceagreement.internal.UserAgentUtils;
import software.amazon.awssdk.services.marketplaceagreement.model.SearchAgreementsRequest;
import software.amazon.awssdk.services.marketplaceagreement.model.SearchAgreementsResponse;

public class SearchAgreementsIterable
implements SdkIterable<SearchAgreementsResponse> {
    private final MarketplaceAgreementClient client;
    private final SearchAgreementsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchAgreementsIterable(MarketplaceAgreementClient client, SearchAgreementsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchAgreementsResponseFetcher();
    }

    public Iterator<SearchAgreementsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class SearchAgreementsResponseFetcher
    implements SyncPageFetcher<SearchAgreementsResponse> {
        private SearchAgreementsResponseFetcher() {
        }

        public boolean hasNextPage(SearchAgreementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchAgreementsResponse nextPage(SearchAgreementsResponse previousPage) {
            if (previousPage == null) {
                return SearchAgreementsIterable.this.client.searchAgreements(SearchAgreementsIterable.this.firstRequest);
            }
            return SearchAgreementsIterable.this.client.searchAgreements((SearchAgreementsRequest)((Object)SearchAgreementsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

