/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PaymentRequestApprovalStrategy {
    AUTO_APPROVE_ON_EXPIRATION("AUTO_APPROVE_ON_EXPIRATION"),
    WAIT_FOR_APPROVAL("WAIT_FOR_APPROVAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PaymentRequestApprovalStrategy> VALUE_MAP;
    private final String value;

    private PaymentRequestApprovalStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PaymentRequestApprovalStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PaymentRequestApprovalStrategy> knownValues() {
        EnumSet<PaymentRequestApprovalStrategy> knownValues = EnumSet.allOf(PaymentRequestApprovalStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PaymentRequestApprovalStrategy.class, PaymentRequestApprovalStrategy::toString);
    }
}

