/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplaceagreement.model.DocumentItem;
import software.amazon.awssdk.services.marketplaceagreement.model.DocumentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LegalTerm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LegalTerm> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(LegalTerm.getter(LegalTerm::type)).setter(LegalTerm.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<DocumentItem>> DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("documents").getter(LegalTerm.getter(LegalTerm::documents)).setter(LegalTerm.setter(Builder::documents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocumentItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, DOCUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LegalTerm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<DocumentItem> documents;

    private LegalTerm(BuilderImpl builder) {
        this.type = builder.type;
        this.documents = builder.documents;
    }

    public final String type() {
        return this.type;
    }

    public final boolean hasDocuments() {
        return this.documents != null && !(this.documents instanceof SdkAutoConstructList);
    }

    public final List<DocumentItem> documents() {
        return this.documents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDocuments() ? this.documents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LegalTerm)) {
            return false;
        }
        LegalTerm other = (LegalTerm)obj;
        return Objects.equals(this.type(), other.type()) && this.hasDocuments() == other.hasDocuments() && Objects.equals(this.documents(), other.documents());
    }

    public final String toString() {
        return ToString.builder((String)"LegalTerm").add("Type", (Object)this.type()).add("Documents", this.hasDocuments() ? this.documents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "documents": {
                return Optional.ofNullable(clazz.cast(this.documents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("documents", DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LegalTerm, T> g) {
        return obj -> g.apply((LegalTerm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<DocumentItem> documents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LegalTerm model) {
            this.type(model.type);
            this.documents(model.documents);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final List<DocumentItem.Builder> getDocuments() {
            List<DocumentItem.Builder> result = DocumentListCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<DocumentItem.BuilderImpl> documents) {
            this.documents = DocumentListCopier.copyFromBuilder(documents);
        }

        @Override
        public final Builder documents(Collection<DocumentItem> documents) {
            this.documents = DocumentListCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(DocumentItem ... documents) {
            this.documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<DocumentItem.Builder> ... documents) {
            this.documents(Stream.of(documents).map(c -> (DocumentItem)((DocumentItem.Builder)DocumentItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LegalTerm build() {
            return new LegalTerm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LegalTerm> {
        public Builder type(String var1);

        public Builder documents(Collection<DocumentItem> var1);

        public Builder documents(DocumentItem ... var1);

        public Builder documents(Consumer<DocumentItem.Builder> ... var1);
    }
}

