/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.marketplaceagreement.DefaultMarketplaceAgreementClientBuilder;
import software.amazon.awssdk.services.marketplaceagreement.MarketplaceAgreementClientBuilder;
import software.amazon.awssdk.services.marketplaceagreement.MarketplaceAgreementServiceClientConfiguration;
import software.amazon.awssdk.services.marketplaceagreement.model.AccessDeniedException;
import software.amazon.awssdk.services.marketplaceagreement.model.DescribeAgreementRequest;
import software.amazon.awssdk.services.marketplaceagreement.model.DescribeAgreementResponse;
import software.amazon.awssdk.services.marketplaceagreement.model.GetAgreementTermsRequest;
import software.amazon.awssdk.services.marketplaceagreement.model.GetAgreementTermsResponse;
import software.amazon.awssdk.services.marketplaceagreement.model.InternalServerException;
import software.amazon.awssdk.services.marketplaceagreement.model.MarketplaceAgreementException;
import software.amazon.awssdk.services.marketplaceagreement.model.ResourceNotFoundException;
import software.amazon.awssdk.services.marketplaceagreement.model.SearchAgreementsRequest;
import software.amazon.awssdk.services.marketplaceagreement.model.SearchAgreementsResponse;
import software.amazon.awssdk.services.marketplaceagreement.model.ThrottlingException;
import software.amazon.awssdk.services.marketplaceagreement.model.ValidationException;
import software.amazon.awssdk.services.marketplaceagreement.paginators.GetAgreementTermsIterable;
import software.amazon.awssdk.services.marketplaceagreement.paginators.SearchAgreementsIterable;

@SdkPublicApi
@ThreadSafe
public interface MarketplaceAgreementClient
extends AwsClient {
    public static final String SERVICE_NAME = "aws-marketplace";
    public static final String SERVICE_METADATA_ID = "agreement-marketplace";

    default public DescribeAgreementResponse describeAgreement(DescribeAgreementRequest describeAgreementRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, MarketplaceAgreementException {
        throw new UnsupportedOperationException();
    }

    default public DescribeAgreementResponse describeAgreement(Consumer<DescribeAgreementRequest.Builder> describeAgreementRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, MarketplaceAgreementException {
        return this.describeAgreement((DescribeAgreementRequest)((Object)((DescribeAgreementRequest.Builder)DescribeAgreementRequest.builder().applyMutation(describeAgreementRequest)).build()));
    }

    default public GetAgreementTermsResponse getAgreementTerms(GetAgreementTermsRequest getAgreementTermsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, MarketplaceAgreementException {
        throw new UnsupportedOperationException();
    }

    default public GetAgreementTermsResponse getAgreementTerms(Consumer<GetAgreementTermsRequest.Builder> getAgreementTermsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, MarketplaceAgreementException {
        return this.getAgreementTerms((GetAgreementTermsRequest)((Object)((GetAgreementTermsRequest.Builder)GetAgreementTermsRequest.builder().applyMutation(getAgreementTermsRequest)).build()));
    }

    default public GetAgreementTermsIterable getAgreementTermsPaginator(GetAgreementTermsRequest getAgreementTermsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, MarketplaceAgreementException {
        return new GetAgreementTermsIterable(this, getAgreementTermsRequest);
    }

    default public GetAgreementTermsIterable getAgreementTermsPaginator(Consumer<GetAgreementTermsRequest.Builder> getAgreementTermsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, MarketplaceAgreementException {
        return this.getAgreementTermsPaginator((GetAgreementTermsRequest)((Object)((GetAgreementTermsRequest.Builder)GetAgreementTermsRequest.builder().applyMutation(getAgreementTermsRequest)).build()));
    }

    default public SearchAgreementsResponse searchAgreements(SearchAgreementsRequest searchAgreementsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, MarketplaceAgreementException {
        throw new UnsupportedOperationException();
    }

    default public SearchAgreementsResponse searchAgreements(Consumer<SearchAgreementsRequest.Builder> searchAgreementsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, MarketplaceAgreementException {
        return this.searchAgreements((SearchAgreementsRequest)((Object)((SearchAgreementsRequest.Builder)SearchAgreementsRequest.builder().applyMutation(searchAgreementsRequest)).build()));
    }

    default public SearchAgreementsIterable searchAgreementsPaginator(SearchAgreementsRequest searchAgreementsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, MarketplaceAgreementException {
        return new SearchAgreementsIterable(this, searchAgreementsRequest);
    }

    default public SearchAgreementsIterable searchAgreementsPaginator(Consumer<SearchAgreementsRequest.Builder> searchAgreementsRequest) throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, MarketplaceAgreementException {
        return this.searchAgreementsPaginator((SearchAgreementsRequest)((Object)((SearchAgreementsRequest.Builder)SearchAgreementsRequest.builder().applyMutation(searchAgreementsRequest)).build()));
    }

    public static MarketplaceAgreementClient create() {
        return (MarketplaceAgreementClient)MarketplaceAgreementClient.builder().build();
    }

    public static MarketplaceAgreementClientBuilder builder() {
        return new DefaultMarketplaceAgreementClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }

    default public MarketplaceAgreementServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

