/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum QueryTokenStandard {
    ERC20("ERC20"),
    ERC721("ERC721"),
    ERC1155("ERC1155"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, QueryTokenStandard> VALUE_MAP;
    private final String value;

    private QueryTokenStandard(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static QueryTokenStandard fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<QueryTokenStandard> knownValues() {
        EnumSet<QueryTokenStandard> knownValues = EnumSet.allOf(QueryTokenStandard.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(QueryTokenStandard.class, QueryTokenStandard::toString);
    }
}

