/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.ManagedBlockchainQueryRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.OwnerFilter;
import software.amazon.awssdk.services.managedblockchainquery.model.TokenFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTokenBalancesRequest
extends ManagedBlockchainQueryRequest
implements ToCopyableBuilder<Builder, ListTokenBalancesRequest> {
    private static final SdkField<OwnerFilter> OWNER_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ownerFilter").getter(ListTokenBalancesRequest.getter(ListTokenBalancesRequest::ownerFilter)).setter(ListTokenBalancesRequest.setter(Builder::ownerFilter)).constructor(OwnerFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerFilter").build()}).build();
    private static final SdkField<TokenFilter> TOKEN_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tokenFilter").getter(ListTokenBalancesRequest.getter(ListTokenBalancesRequest::tokenFilter)).setter(ListTokenBalancesRequest.setter(Builder::tokenFilter)).constructor(TokenFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenFilter").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTokenBalancesRequest.getter(ListTokenBalancesRequest::nextToken)).setter(ListTokenBalancesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListTokenBalancesRequest.getter(ListTokenBalancesRequest::maxResults)).setter(ListTokenBalancesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_FILTER_FIELD, TOKEN_FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTokenBalancesRequest.memberNameToFieldInitializer();
    private final OwnerFilter ownerFilter;
    private final TokenFilter tokenFilter;
    private final String nextToken;
    private final Integer maxResults;

    private ListTokenBalancesRequest(BuilderImpl builder) {
        super(builder);
        this.ownerFilter = builder.ownerFilter;
        this.tokenFilter = builder.tokenFilter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final OwnerFilter ownerFilter() {
        return this.ownerFilter;
    }

    public final TokenFilter tokenFilter() {
        return this.tokenFilter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTokenBalancesRequest)) {
            return false;
        }
        ListTokenBalancesRequest other = (ListTokenBalancesRequest)((Object)obj);
        return Objects.equals(this.ownerFilter(), other.ownerFilter()) && Objects.equals(this.tokenFilter(), other.tokenFilter()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListTokenBalancesRequest").add("OwnerFilter", (Object)this.ownerFilter()).add("TokenFilter", (Object)this.tokenFilter()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ownerFilter": {
                return Optional.ofNullable(clazz.cast(this.ownerFilter()));
            }
            case "tokenFilter": {
                return Optional.ofNullable(clazz.cast(this.tokenFilter()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ownerFilter", OWNER_FILTER_FIELD);
        map.put("tokenFilter", TOKEN_FILTER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTokenBalancesRequest, T> g) {
        return obj -> g.apply((ListTokenBalancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainQueryRequest.BuilderImpl
    implements Builder {
        private OwnerFilter ownerFilter;
        private TokenFilter tokenFilter;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTokenBalancesRequest model) {
            super(model);
            this.ownerFilter(model.ownerFilter);
            this.tokenFilter(model.tokenFilter);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final OwnerFilter.Builder getOwnerFilter() {
            return this.ownerFilter != null ? this.ownerFilter.toBuilder() : null;
        }

        public final void setOwnerFilter(OwnerFilter.BuilderImpl ownerFilter) {
            this.ownerFilter = ownerFilter != null ? ownerFilter.build() : null;
        }

        @Override
        public final Builder ownerFilter(OwnerFilter ownerFilter) {
            this.ownerFilter = ownerFilter;
            return this;
        }

        public final TokenFilter.Builder getTokenFilter() {
            return this.tokenFilter != null ? this.tokenFilter.toBuilder() : null;
        }

        public final void setTokenFilter(TokenFilter.BuilderImpl tokenFilter) {
            this.tokenFilter = tokenFilter != null ? tokenFilter.build() : null;
        }

        @Override
        public final Builder tokenFilter(TokenFilter tokenFilter) {
            this.tokenFilter = tokenFilter;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTokenBalancesRequest build() {
            return new ListTokenBalancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ManagedBlockchainQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTokenBalancesRequest> {
        public Builder ownerFilter(OwnerFilter var1);

        default public Builder ownerFilter(Consumer<OwnerFilter.Builder> ownerFilter) {
            return this.ownerFilter((OwnerFilter)((OwnerFilter.Builder)OwnerFilter.builder().applyMutation(ownerFilter)).build());
        }

        public Builder tokenFilter(TokenFilter var1);

        default public Builder tokenFilter(Consumer<TokenFilter.Builder> tokenFilter) {
            return this.tokenFilter((TokenFilter)((TokenFilter.Builder)TokenFilter.builder().applyMutation(tokenFilter)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

