/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MemberStatus {
    CREATING("CREATING"),
    AVAILABLE("AVAILABLE"),
    CREATE_FAILED("CREATE_FAILED"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    INACCESSIBLE_ENCRYPTION_KEY("INACCESSIBLE_ENCRYPTION_KEY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MemberStatus> VALUE_MAP;
    private final String value;

    private MemberStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MemberStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MemberStatus> knownValues() {
        EnumSet<MemberStatus> knownValues = EnumSet.allOf(MemberStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MemberStatus.class, MemberStatus::toString);
    }
}

