/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainAsyncClient;
import software.amazon.awssdk.services.managedblockchain.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchain.model.ListInvitationsRequest;
import software.amazon.awssdk.services.managedblockchain.model.ListInvitationsResponse;

public class ListInvitationsPublisher
implements SdkPublisher<ListInvitationsResponse> {
    private final ManagedBlockchainAsyncClient client;
    private final ListInvitationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInvitationsPublisher(ManagedBlockchainAsyncClient client, ListInvitationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInvitationsPublisher(ManagedBlockchainAsyncClient client, ListInvitationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInvitationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInvitationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListInvitationsResponseFetcher
    implements AsyncPageFetcher<ListInvitationsResponse> {
        private ListInvitationsResponseFetcher() {
        }

        public boolean hasNextPage(ListInvitationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInvitationsResponse> nextPage(ListInvitationsResponse previousPage) {
            if (previousPage == null) {
                return ListInvitationsPublisher.this.client.listInvitations(ListInvitationsPublisher.this.firstRequest);
            }
            return ListInvitationsPublisher.this.client.listInvitations((ListInvitationsRequest)((Object)ListInvitationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

