/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mailmanager.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Envelope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Envelope> {
    private static final SdkField<String> HELO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Helo").getter(Envelope.getter(Envelope::helo)).setter(Envelope.setter(Builder::helo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Helo").build()}).build();
    private static final SdkField<String> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("From").getter(Envelope.getter(Envelope::from)).setter(Envelope.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()}).build();
    private static final SdkField<List<String>> TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("To").getter(Envelope.getter(Envelope::to)).setter(Envelope.setter(Builder::to)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HELO_FIELD, FROM_FIELD, TO_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Envelope.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String helo;
    private final String from;
    private final List<String> to;

    private Envelope(BuilderImpl builder) {
        this.helo = builder.helo;
        this.from = builder.from;
        this.to = builder.to;
    }

    public final String helo() {
        return this.helo;
    }

    public final String from() {
        return this.from;
    }

    public final boolean hasTo() {
        return this.to != null && !(this.to instanceof SdkAutoConstructList);
    }

    public final List<String> to() {
        return this.to;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.helo());
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTo() ? this.to() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Envelope)) {
            return false;
        }
        Envelope other = (Envelope)obj;
        return Objects.equals(this.helo(), other.helo()) && Objects.equals(this.from(), other.from()) && this.hasTo() == other.hasTo() && Objects.equals(this.to(), other.to());
    }

    public final String toString() {
        return ToString.builder((String)"Envelope").add("Helo", (Object)this.helo()).add("From", (Object)this.from()).add("To", this.hasTo() ? this.to() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Helo": {
                return Optional.ofNullable(clazz.cast(this.helo()));
            }
            case "From": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "To": {
                return Optional.ofNullable(clazz.cast(this.to()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Helo", HELO_FIELD);
        map.put("From", FROM_FIELD);
        map.put("To", TO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Envelope, T> g) {
        return obj -> g.apply((Envelope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String helo;
        private String from;
        private List<String> to = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Envelope model) {
            this.helo(model.helo);
            this.from(model.from);
            this.to(model.to);
        }

        public final String getHelo() {
            return this.helo;
        }

        public final void setHelo(String helo) {
            this.helo = helo;
        }

        @Override
        public final Builder helo(String helo) {
            this.helo = helo;
            return this;
        }

        public final String getFrom() {
            return this.from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final Collection<String> getTo() {
            if (this.to instanceof SdkAutoConstructList) {
                return null;
            }
            return this.to;
        }

        public final void setTo(Collection<String> to) {
            this.to = StringListCopier.copy(to);
        }

        @Override
        public final Builder to(Collection<String> to) {
            this.to = StringListCopier.copy(to);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder to(String ... to) {
            this.to(Arrays.asList(to));
            return this;
        }

        public Envelope build() {
            return new Envelope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Envelope> {
        public Builder helo(String var1);

        public Builder from(String var1);

        public Builder to(Collection<String> var1);

        public Builder to(String ... var1);
    }
}

