/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mailmanager.MailManagerAsyncClient;
import software.amazon.awssdk.services.mailmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.mailmanager.model.Archive;
import software.amazon.awssdk.services.mailmanager.model.ListArchivesRequest;
import software.amazon.awssdk.services.mailmanager.model.ListArchivesResponse;

public class ListArchivesPublisher
implements SdkPublisher<ListArchivesResponse> {
    private final MailManagerAsyncClient client;
    private final ListArchivesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListArchivesPublisher(MailManagerAsyncClient client, ListArchivesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListArchivesPublisher(MailManagerAsyncClient client, ListArchivesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListArchivesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListArchivesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Archive> archives() {
        Function<ListArchivesResponse, Iterator> getIterator = response -> {
            if (response != null && response.archives() != null) {
                return response.archives().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListArchivesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListArchivesResponseFetcher
    implements AsyncPageFetcher<ListArchivesResponse> {
        private ListArchivesResponseFetcher() {
        }

        public boolean hasNextPage(ListArchivesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListArchivesResponse> nextPage(ListArchivesResponse previousPage) {
            if (previousPage == null) {
                return ListArchivesPublisher.this.client.listArchives(ListArchivesPublisher.this.firstRequest);
            }
            return ListArchivesPublisher.this.client.listArchives((ListArchivesRequest)((Object)ListArchivesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

