/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageBody
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageBody> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Text").getter(MessageBody.getter(MessageBody::text)).setter(MessageBody.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Text").build()}).build();
    private static final SdkField<String> HTML_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Html").getter(MessageBody.getter(MessageBody::html)).setter(MessageBody.setter(Builder::html)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Html").build()}).build();
    private static final SdkField<Boolean> MESSAGE_MALFORMED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MessageMalformed").getter(MessageBody.getter(MessageBody::messageMalformed)).setter(MessageBody.setter(Builder::messageMalformed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageMalformed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, HTML_FIELD, MESSAGE_MALFORMED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageBody.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String text;
    private final String html;
    private final Boolean messageMalformed;

    private MessageBody(BuilderImpl builder) {
        this.text = builder.text;
        this.html = builder.html;
        this.messageMalformed = builder.messageMalformed;
    }

    public final String text() {
        return this.text;
    }

    public final String html() {
        return this.html;
    }

    public final Boolean messageMalformed() {
        return this.messageMalformed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.html());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageMalformed());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageBody)) {
            return false;
        }
        MessageBody other = (MessageBody)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.html(), other.html()) && Objects.equals(this.messageMalformed(), other.messageMalformed());
    }

    public final String toString() {
        return ToString.builder((String)"MessageBody").add("Text", (Object)this.text()).add("Html", (Object)this.html()).add("MessageMalformed", (Object)this.messageMalformed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "Html": {
                return Optional.ofNullable(clazz.cast(this.html()));
            }
            case "MessageMalformed": {
                return Optional.ofNullable(clazz.cast(this.messageMalformed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Text", TEXT_FIELD);
        map.put("Html", HTML_FIELD);
        map.put("MessageMalformed", MESSAGE_MALFORMED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageBody, T> g) {
        return obj -> g.apply((MessageBody)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private String html;
        private Boolean messageMalformed;

        private BuilderImpl() {
        }

        private BuilderImpl(MessageBody model) {
            this.text(model.text);
            this.html(model.html);
            this.messageMalformed(model.messageMalformed);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getHtml() {
            return this.html;
        }

        public final void setHtml(String html) {
            this.html = html;
        }

        @Override
        public final Builder html(String html) {
            this.html = html;
            return this;
        }

        public final Boolean getMessageMalformed() {
            return this.messageMalformed;
        }

        public final void setMessageMalformed(Boolean messageMalformed) {
            this.messageMalformed = messageMalformed;
        }

        @Override
        public final Builder messageMalformed(Boolean messageMalformed) {
            this.messageMalformed = messageMalformed;
            return this;
        }

        public MessageBody build() {
            return new MessageBody(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageBody> {
        public Builder text(String var1);

        public Builder html(String var1);

        public Builder messageMalformed(Boolean var1);
    }
}

