/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngressPointPasswordConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngressPointPasswordConfiguration> {
    private static final SdkField<String> SMTP_PASSWORD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SmtpPasswordVersion").getter(IngressPointPasswordConfiguration.getter(IngressPointPasswordConfiguration::smtpPasswordVersion)).setter(IngressPointPasswordConfiguration.setter(Builder::smtpPasswordVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SmtpPasswordVersion").build()}).build();
    private static final SdkField<String> PREVIOUS_SMTP_PASSWORD_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreviousSmtpPasswordVersion").getter(IngressPointPasswordConfiguration.getter(IngressPointPasswordConfiguration::previousSmtpPasswordVersion)).setter(IngressPointPasswordConfiguration.setter(Builder::previousSmtpPasswordVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousSmtpPasswordVersion").build()}).build();
    private static final SdkField<Instant> PREVIOUS_SMTP_PASSWORD_EXPIRY_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("PreviousSmtpPasswordExpiryTimestamp").getter(IngressPointPasswordConfiguration.getter(IngressPointPasswordConfiguration::previousSmtpPasswordExpiryTimestamp)).setter(IngressPointPasswordConfiguration.setter(Builder::previousSmtpPasswordExpiryTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousSmtpPasswordExpiryTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SMTP_PASSWORD_VERSION_FIELD, PREVIOUS_SMTP_PASSWORD_VERSION_FIELD, PREVIOUS_SMTP_PASSWORD_EXPIRY_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IngressPointPasswordConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String smtpPasswordVersion;
    private final String previousSmtpPasswordVersion;
    private final Instant previousSmtpPasswordExpiryTimestamp;

    private IngressPointPasswordConfiguration(BuilderImpl builder) {
        this.smtpPasswordVersion = builder.smtpPasswordVersion;
        this.previousSmtpPasswordVersion = builder.previousSmtpPasswordVersion;
        this.previousSmtpPasswordExpiryTimestamp = builder.previousSmtpPasswordExpiryTimestamp;
    }

    public final String smtpPasswordVersion() {
        return this.smtpPasswordVersion;
    }

    public final String previousSmtpPasswordVersion() {
        return this.previousSmtpPasswordVersion;
    }

    public final Instant previousSmtpPasswordExpiryTimestamp() {
        return this.previousSmtpPasswordExpiryTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.smtpPasswordVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousSmtpPasswordVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousSmtpPasswordExpiryTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngressPointPasswordConfiguration)) {
            return false;
        }
        IngressPointPasswordConfiguration other = (IngressPointPasswordConfiguration)obj;
        return Objects.equals(this.smtpPasswordVersion(), other.smtpPasswordVersion()) && Objects.equals(this.previousSmtpPasswordVersion(), other.previousSmtpPasswordVersion()) && Objects.equals(this.previousSmtpPasswordExpiryTimestamp(), other.previousSmtpPasswordExpiryTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"IngressPointPasswordConfiguration").add("SmtpPasswordVersion", (Object)this.smtpPasswordVersion()).add("PreviousSmtpPasswordVersion", (Object)this.previousSmtpPasswordVersion()).add("PreviousSmtpPasswordExpiryTimestamp", (Object)this.previousSmtpPasswordExpiryTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SmtpPasswordVersion": {
                return Optional.ofNullable(clazz.cast(this.smtpPasswordVersion()));
            }
            case "PreviousSmtpPasswordVersion": {
                return Optional.ofNullable(clazz.cast(this.previousSmtpPasswordVersion()));
            }
            case "PreviousSmtpPasswordExpiryTimestamp": {
                return Optional.ofNullable(clazz.cast(this.previousSmtpPasswordExpiryTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SmtpPasswordVersion", SMTP_PASSWORD_VERSION_FIELD);
        map.put("PreviousSmtpPasswordVersion", PREVIOUS_SMTP_PASSWORD_VERSION_FIELD);
        map.put("PreviousSmtpPasswordExpiryTimestamp", PREVIOUS_SMTP_PASSWORD_EXPIRY_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngressPointPasswordConfiguration, T> g) {
        return obj -> g.apply((IngressPointPasswordConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String smtpPasswordVersion;
        private String previousSmtpPasswordVersion;
        private Instant previousSmtpPasswordExpiryTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(IngressPointPasswordConfiguration model) {
            this.smtpPasswordVersion(model.smtpPasswordVersion);
            this.previousSmtpPasswordVersion(model.previousSmtpPasswordVersion);
            this.previousSmtpPasswordExpiryTimestamp(model.previousSmtpPasswordExpiryTimestamp);
        }

        public final String getSmtpPasswordVersion() {
            return this.smtpPasswordVersion;
        }

        public final void setSmtpPasswordVersion(String smtpPasswordVersion) {
            this.smtpPasswordVersion = smtpPasswordVersion;
        }

        @Override
        public final Builder smtpPasswordVersion(String smtpPasswordVersion) {
            this.smtpPasswordVersion = smtpPasswordVersion;
            return this;
        }

        public final String getPreviousSmtpPasswordVersion() {
            return this.previousSmtpPasswordVersion;
        }

        public final void setPreviousSmtpPasswordVersion(String previousSmtpPasswordVersion) {
            this.previousSmtpPasswordVersion = previousSmtpPasswordVersion;
        }

        @Override
        public final Builder previousSmtpPasswordVersion(String previousSmtpPasswordVersion) {
            this.previousSmtpPasswordVersion = previousSmtpPasswordVersion;
            return this;
        }

        public final Instant getPreviousSmtpPasswordExpiryTimestamp() {
            return this.previousSmtpPasswordExpiryTimestamp;
        }

        public final void setPreviousSmtpPasswordExpiryTimestamp(Instant previousSmtpPasswordExpiryTimestamp) {
            this.previousSmtpPasswordExpiryTimestamp = previousSmtpPasswordExpiryTimestamp;
        }

        @Override
        public final Builder previousSmtpPasswordExpiryTimestamp(Instant previousSmtpPasswordExpiryTimestamp) {
            this.previousSmtpPasswordExpiryTimestamp = previousSmtpPasswordExpiryTimestamp;
            return this;
        }

        public IngressPointPasswordConfiguration build() {
            return new IngressPointPasswordConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngressPointPasswordConfiguration> {
        public Builder smtpPasswordVersion(String var1);

        public Builder previousSmtpPasswordVersion(String var1);

        public Builder previousSmtpPasswordExpiryTimestamp(Instant var1);
    }
}

